package com.ejianc.business.guarantee.relieve.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.business.guarantee.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.guarantee.relieve.bean.RelieveFinanceEntity;
import com.ejianc.business.guarantee.relieve.service.IContractRelieveService;
import com.ejianc.business.guarantee.relieve.service.IRelieveFinanceService;
import com.ejianc.framework.auth.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

@Service("relieveFinance") 
public class RelieveFinanceBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractService contractService;

	@Autowired
	private IContractRelieveService contractRelieveService;

	@Autowired
	private IRelieveFinanceService service;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		RelieveFinanceEntity relieveFinanceEntity = service.selectById(billId);
		if(relieveFinanceEntity != null){

			ContractRelieveEntity relieveEntity = contractRelieveService.selectById(relieveFinanceEntity.getRelieveId());//担保合同续保
			if(relieveEntity != null){
//				BigDecimal premiumMny = relieveEntity.getPremiumMny();//保费金额
//				BigDecimal totalRelieveMny = BigDecimal.ZERO;//总到账的保费金额
//				ContractEntity contractEntity = contractService.selectById(relieveEntity.getContractId());//担保合同评审
//
//				/**
//				 * 查询条件:
//				 * 		1.解保id
//				 * 		2.未删除
//				 * 		3.已提交，审批通过
//				 * 		4.已到账
//				 * 业务描述:
//				 * 		遍历查询出的数据，将保费金额累加，与保费金额比较
//				 * 		相等时将合同状态更改为已结束
//				 */
//				List<RelieveFinanceEntity> list = service.list(Wrappers.<RelieveFinanceEntity>lambdaQuery()
//						.eq(RelieveFinanceEntity::getRelieveId, relieveFinanceEntity.getRelieveId())
//						.eq(RelieveFinanceEntity::getDr, 0)
//						.in(RelieveFinanceEntity::getBillState, Arrays.asList(1, 3))
//						.eq(RelieveFinanceEntity::getIsReceive, 1)
//				);
//				for (RelieveFinanceEntity financeEntity : list) {
//					if (financeEntity.getRelieveMny() != null){
//						totalRelieveMny = totalRelieveMny.add(financeEntity.getRelieveMny());
//					} else {
//						return CommonResponse.error("系统错误，请联系管理员！(存在保费金额为null)");
//					}
//				}
//				if(totalRelieveMny.compareTo(premiumMny) == 0){
//					contractEntity.setContractStatus(ContractStatuesEnum.已结束.getCode());
//					contractService.saveOrUpdate(contractEntity);
//				}
				ContractEntity contractEntity = contractService.selectById(relieveEntity.getContractId());//担保合同评审
				contractEntity.setContractStatus(ContractStatuesEnum.已结束.getCode());
				contractService.saveOrUpdate(contractEntity);
			}
			return CommonResponse.success();

		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("系统错误,请联系管理员！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
