package com.ejianc.business.gyypoc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 采购需求单据
 *
 * @author CJ
 * @Description: 采购需求单据
 * @date 2021/3/23 16:58
 */
public class PurchaseBillVO extends BaseVO {

    /**
     * 所属采购流程Id
     */
    private Long purchaseProcessId;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;


    /**
     * 采购需求单据编码
     */
    private String billCode;

    /**
     * 采购需求单据名称
     */
    private String billName;

    /**
     * 软件名称
     */
    private String softwareName;

    /**
     * 预算费用（万元）
     */
    private BigDecimal budgetAmt;

    /**
     * 申请单位Id
     */
    private Long applyOrgId;

    /**
     * 申请单位名称
     */
    private String applyOrgName;

    /**
     * 软件采购的必要性
     */
    private String purchaseNecessity;

    /**
     * 软件功能
     */
    private String softwareFunctionDesc;

    /**
     * 类似软件比较
     */
    private String likelySoftwareCompare;

    /**
     * 应用规划
     */
    private String applicationPlanning;

    /**
     * 软件数量
     */
    private String softwareNum;

    /**
     * 预期效益
     */
    private String prospectiveEarnings;

    /**
     * 采购方式及理由
     */
    private String purchaseDesc;

    /**
     * 单据创建人Id
     */
    private Long createUserId;

    /**
     * 软件需求清单
     */
    private List<SoftwareNeedsListVO> softwareNeedsList;

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getPurchaseProcessId() {
        return purchaseProcessId;
    }

    public void setPurchaseProcessId(Long purchaseProcessId) {
        this.purchaseProcessId = purchaseProcessId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }

    public String getSoftwareName() {
        return softwareName;
    }

    public void setSoftwareName(String softwareName) {
        this.softwareName = softwareName;
    }

    public BigDecimal getBudgetAmt() {
        return budgetAmt;
    }

    public void setBudgetAmt(BigDecimal budgetAmt) {
        this.budgetAmt = budgetAmt;
    }

    public Long getApplyOrgId() {
        return applyOrgId;
    }

    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public String getPurchaseNecessity() {
        return purchaseNecessity;
    }

    public void setPurchaseNecessity(String purchaseNecessity) {
        this.purchaseNecessity = purchaseNecessity;
    }

    public String getSoftwareFunctionDesc() {
        return softwareFunctionDesc;
    }

    public void setSoftwareFunctionDesc(String softwareFunctionDesc) {
        this.softwareFunctionDesc = softwareFunctionDesc;
    }

    public String getLikelySoftwareCompare() {
        return likelySoftwareCompare;
    }

    public void setLikelySoftwareCompare(String likelySoftwareCompare) {
        this.likelySoftwareCompare = likelySoftwareCompare;
    }

    public String getApplicationPlanning() {
        return applicationPlanning;
    }

    public void setApplicationPlanning(String applicationPlanning) {
        this.applicationPlanning = applicationPlanning;
    }

    public String getSoftwareNum() {
        return softwareNum;
    }

    public void setSoftwareNum(String softwareNum) {
        this.softwareNum = softwareNum;
    }

    public String getProspectiveEarnings() {
        return prospectiveEarnings;
    }

    public void setProspectiveEarnings(String prospectiveEarnings) {
        this.prospectiveEarnings = prospectiveEarnings;
    }

    public String getPurchaseDesc() {
        return purchaseDesc;
    }

    public void setPurchaseDesc(String purchaseDesc) {
        this.purchaseDesc = purchaseDesc;
    }

    public List<SoftwareNeedsListVO> getSoftwareNeedsList() {
        return softwareNeedsList;
    }

    public void setSoftwareNeedsList(List<SoftwareNeedsListVO> softwareNeedsList) {
        this.softwareNeedsList = softwareNeedsList;
    }
}
