package com.ejianc.poc.gyy.service.impl;

import com.ejianc.poc.gyy.bean.SoftReceiveCheckEntity;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.service.ISoftReceiveCheckService;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("softReceiveCheck") 
public class SoftReceiveCheckBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISoftReceiveCheckService softReceiveCheckService;

	@Autowired
	private ISoftwareNeedsListService needsListService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SoftReceiveCheckEntity entity = softReceiveCheckService.selectById(billId);
		SoftwareNeedsListEntity needsListEntity = needsListService.selectById(entity.getNeedId());
		// 设置成已验收
		needsListEntity.setRecState(1);
		needsListService.saveOrUpdate(needsListEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 无审批流提交撤回后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SoftReceiveCheckEntity entity = softReceiveCheckService.selectById(billId);
		SoftwareNeedsListEntity needsListEntity = needsListService.selectById(entity.getNeedId());
		needsListEntity.setRecState(0);
		needsListService.saveOrUpdate(needsListEntity);
		return CommonResponse.success();
	}
	/**
	 * 有审批流提交撤回后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		SoftReceiveCheckEntity entity = softReceiveCheckService.selectById(billId);
		SoftwareNeedsListEntity needsListEntity = needsListService.selectById(entity.getNeedId());
		needsListEntity.setRecState(0);
		needsListService.saveOrUpdate(needsListEntity);
		return CommonResponse.success();
	};

}
