/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.gyy.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.gyypoc.vo.PurchaseBillVO;
import com.ejianc.business.gyypoc.vo.SoftwareNeedsListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.gyy.bean.PurchaseBillEntity;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.service.IPurchaseBillService;
import com.ejianc.poc.gyy.service.IPurchaseProcessService;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchaseBill/"})
public class PurhcaseBillController {
    @Autowired
    private IPurchaseBillService purchaseBillService;
    @Autowired
    private IPurchaseProcessService purchaseProcessService;
    @Autowired
    private ISoftwareNeedsListService softwareNeedsListService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private final String BILL_CODE = "GYYPOC_PURCHASE_BILL";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<PurchaseBillVO> saveOrUpdate(@RequestBody PurchaseBillVO purchaseBillVO) {
        PurchaseBillEntity saveEntity = (PurchaseBillEntity)((Object)BeanMapper.map((Object)purchaseBillVO, PurchaseBillEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        if (StringUtils.isBlank((CharSequence)saveEntity.getBillCode())) {
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode("GYYPOC_PURCHASE_BILL", InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            saveEntity.setBillCode((String)codeResp.getData());
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getSoftwareNeedsList())) {
            for (SoftwareNeedsListEntity soft : saveEntity.getSoftwareNeedsList()) {
                soft.setPurchaseBillCode(saveEntity.getBillCode());
            }
        }
        if (null != purchaseBillVO.getId()) {
            PurchaseBillEntity dbEntity = (PurchaseBillEntity)((Object)this.purchaseBillService.selectById(purchaseBillVO.getId()));
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setSyncEsFlag(dbEntity.getSyncEsFlag());
            saveEntity.setBillState(dbEntity.getBillState());
            saveEntity.setPurchaseProcessId(dbEntity.getPurchaseProcessId());
            saveEntity.setTenantId(dbEntity.getTenantId());
            saveEntity.setDr(dbEntity.getDr());
        } else {
            saveEntity.setCreateUserName(userContext.getUserName());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserId(userContext.getUserId());
        }
        if (null == saveEntity.getBudgetAmt()) {
            saveEntity.setBudgetAmt(BigDecimal.ZERO.setScale(8));
        }
        saveEntity = this.purchaseBillService.saveOrUpdatePurchaseBill(saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)saveEntity), PurchaseBillVO.class));
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<PurchaseBillVO> queryDetail(@RequestParam(value="id") Long id) {
        PurchaseBillVO vo = null;
        PurchaseBillEntity dbEntity = (PurchaseBillEntity)((Object)this.purchaseBillService.selectById(id));
        if (null != dbEntity) {
            vo = (PurchaseBillVO)BeanMapper.map((Object)((Object)dbEntity), PurchaseBillVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u62a5\u544a\u8be6\u60c5\u6210\u529f\uff01", (Object)vo);
        }
        UserContext userContext = this.sessionManager.getUserContext();
        QueryWrapper billQuery = new QueryWrapper();
        billQuery.eq((Object)"purchase_process_id", (Object)id);
        billQuery.eq((Object)"create_user_id", (Object)userContext.getUserId());
        dbEntity = (PurchaseBillEntity)((Object)this.purchaseBillService.getOne((Wrapper)billQuery));
        if (null != dbEntity) {
            vo = (PurchaseBillVO)BeanMapper.map((Object)((Object)dbEntity), PurchaseBillVO.class);
            QueryWrapper softQuery = new QueryWrapper();
            softQuery.eq((Object)"purchase_bill_id", (Object)dbEntity.getId());
            softQuery.eq((Object)"purchase_process_id", (Object)id);
            softQuery.in((Object)"apply_org_id", this.getPageQueryParam(null));
            List softList = this.softwareNeedsListService.list((Wrapper)softQuery);
            if (CollectionUtils.isNotEmpty((Collection)softList)) {
                vo.setSoftwareNeedsList(BeanMapper.mapList((Iterable)softList, SoftwareNeedsListVO.class));
            }
        } else {
            PurchaseBillEntity newEntity = new PurchaseBillEntity();
            newEntity.setPurchaseProcessId(id);
            newEntity.setCreateUserId(userContext.getUserId());
            newEntity.setCreateUserName(userContext.getUserName());
            this.purchaseBillService.saveOrUpdate((Object)newEntity, false);
            vo = (PurchaseBillVO)BeanMapper.map((Object)((Object)newEntity), PurchaseBillVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u62a5\u544a\u8be6\u60c5\u6210\u529f\uff01", (Object)vo);
    }

    public List<Long> getPageQueryParam(Long orgId) {
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.addAll(((List)childOrgResp.getData()).stream().filter(org -> 5 == org.getOrgType()).map(BaseVO::getId).collect(Collectors.toList()));
        return childIds;
    }
}

