/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.gyy.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.gyypoc.vo.PurchaseProcessVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.poc.gyy.bean.PurchaseBillEntity;
import com.ejianc.poc.gyy.bean.PurchaseProcessEntity;
import com.ejianc.poc.gyy.service.IPurchaseBillService;
import com.ejianc.poc.gyy.service.IPurchaseProcessService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseProcess")
public class PurchaseProcessBpmCallbackServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String APPROVE_SIGN_MEETING_INIT = "init";
    private static final String APPROVE_SIGN_MEETING_APPROVE = "meetingApprove";
    private static final String APPROVE_SIGN_MEETING_REC = "rec";
    private static final String PURCHASE_BILL_BILL_TYPE_CODE = "BT210323000000002";
    private static final String PC_URL = "ejc-gyypoc-frontend/#/purchaseBill/approveCard?id={id}";
    private static final String MA_URL = "ejc-gyypoc-mobile/#/applyApprove?id={id}";
    @Autowired
    private IPurchaseProcessService purchaseProcessService;
    @Autowired
    private IPurchaseBillService purchaseBillService;
    @Autowired
    private IBpmApi bpmApi;

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03 billId-{}, sing-{}", (Object)billId, (Object)sign);
        Long userId = InvocationInfoProxy.getUserid();
        PurchaseProcessEntity processEntity = (PurchaseProcessEntity)((Object)this.purchaseProcessService.selectById(billId));
        if (APPROVE_SIGN_MEETING_APPROVE.equals(sign)) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"purchase_process_id", (Object)billId);
            query.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List unFinishList = this.purchaseBillService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)unFinishList)) {
                this.logger.error("\u91c7\u8d2d\u6d41\u7a0b[billId-{}]\u5b58\u5728\u672a\u5ba1\u6279\u5b8c\u6210\u7684\u7533\u8bf7\u62a5\u544a\uff0c\u65e0\u6cd5\u6267\u5ba1\u6279\u64cd\u4f5c\uff01", (Object)billId);
                return CommonResponse.error((String)"\u5b58\u5728\u672a\u5ba1\u6279\u5b8c\u6210\u7684\u7533\u8bf7\u62a5\u544a\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
            }
        } else if (APPROVE_SIGN_MEETING_INIT.equals(sign)) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"purchase_process_id", (Object)billId);
            query.eq((Object)"create_user_id", (Object)userId);
            PurchaseBillEntity purchaseBill = (PurchaseBillEntity)((Object)this.purchaseBillService.getOne((Wrapper)query));
            if (null == purchaseBill) {
                this.logger.error("\u91c7\u8d2d\u6d41\u7a0b\u5ba1\u63d0\u4ea4\u586b\u62a5\u5931\u8d25\uff0c\u672a\u627e\u5230\u3010\u91c7\u8d2d\u6d41\u7a0b\uff1abillId-{}, \u7533\u8bf7\u7528\u6237:userId-{}\u3011\u5bf9\u5e94\u7684\u7533\u8bf7\u62a5\u544a\uff01", (Object)billId, (Object)userId);
                return CommonResponse.error((String)"\u91c7\u8d2d\u6d41\u7a0b\u5ba1\u63d0\u4ea4\u586b\u62a5\u5931\u8d25\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u7533\u8bf7\u62a5\u544a\uff01");
            }
            HashMap<String, Object> submitParam = new HashMap<String, Object>(20);
            submitParam.put("userId", userId);
            submitParam.put("billtypeId", PURCHASE_BILL_BILL_TYPE_CODE);
            submitParam.put("assignAble", false);
            submitParam.put("businessKey", purchaseBill.getId());
            submitParam.put("messageType", new String[]{"sys", "weixin"});
            submitParam.put("billOrgId", InvocationInfoProxy.getOrgId());
            submitParam.put("procInstName", processEntity.getName() + "-" + purchaseBill.getApplyOrgName());
            submitParam.put("formurl", PC_URL);
            submitParam.put("maurl", MA_URL);
            this.logger.info("\u7533\u8bf7\u62a5\u544a\u63d0\u4ea4\u6d41\u7a0b\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(submitParam));
            CommonResponse submitResp = this.bpmApi.doSubmit(submitParam);
            this.logger.info("\u7533\u8bf7\u62a5\u544a\u63d0\u4ea4\u6d41\u7a0b\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)submitResp));
            if (!submitResp.isSuccess()) {
                this.logger.error("\u7533\u8bf7\u62a5\u544a\u3010id: {}\u3011\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)purchaseBill.getId(), (Object)submitResp.getMsg());
                return CommonResponse.error((String)"\u7533\u8bf7\u62a5\u544a\u586b\u62a5\u63d0\u4ea4\u5931\u8d25\uff01");
            }
        }
        return CommonResponse.success((String)"\u672a\u53d1\u73b0\u672a\u5b8c\u6210\u7684\u7533\u8bf7\u62a5\u544a\uff0c\u53ef\u4ee5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u3010billId-{}\u3011\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\uff0c\u5c06\u8be5\u6d41\u7a0b\u7684\u6d41\u6d41\u7a0b\u72b6\u6001\u8bbe\u7f6e\u4e3a\u5df2\u7ed3\u675f", (Object)billId);
        PurchaseProcessEntity processEntity = (PurchaseProcessEntity)((Object)this.purchaseProcessService.selectById(billId));
        processEntity.setProcessState(PurchaseProcessVO.PROCESS_STATE_END);
        this.purchaseProcessService.saveOrUpdate((Object)processEntity, false);
        return CommonResponse.success((String)"\u91c7\u8d2d\u6d41\u7a0b\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign) {
        this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u3010billId-{},sign-{},isEnd-{}\u3011\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\uff0c\u5c06\u8be5\u6d41\u7a0b\u7684\u6d41\u6d41\u7a0b\u72b6\u6001\u8bbe\u7f6e\u4e3a\u6c47\u603b\u5ba1\u6279", new Object[]{billId, sign, isEnd});
        PurchaseProcessEntity processEntity = (PurchaseProcessEntity)((Object)this.purchaseProcessService.selectById(billId));
        if (isEnd.booleanValue()) {
            switch (sign) {
                case "init": {
                    processEntity.setProcessState(PurchaseProcessVO.PROCESS_STATE_APPROVE);
                    this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u3010billId-{}\u3011\u8282\u70b9\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\uff0c\u5c06\u8be5\u6d41\u7a0b\u7684\u6d41\u6d41\u7a0b\u72b6\u6001\u8bbe\u7f6e\u4e3a\u6c47\u603b\u5ba1\u6279", (Object)billId);
                    break;
                }
                case "meetingApprove": {
                    processEntity.setProcessState(PurchaseProcessVO.PROCESS_STATE_PURCHASE);
                    this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u3010billId-{}\u3011\u8282\u70b9\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\uff0c\u5c06\u8be5\u6d41\u7a0b\u7684\u6d41\u6d41\u7a0b\u72b6\u6001\u8bbe\u7f6e\u4e3a\u91c7\u8d2d", (Object)billId);
                }
            }
            this.purchaseProcessService.saveOrUpdate((Object)processEntity, false);
        } else if (APPROVE_SIGN_MEETING_REC.equals(sign) && !PurchaseProcessVO.PROCESS_STATE_REC.equals(processEntity.getProcessState())) {
            processEntity.setProcessState(PurchaseProcessVO.PROCESS_STATE_REC);
            this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u3010billId-{}\u3011\u8282\u70b9\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\uff0c\u5c06\u8be5\u6d41\u7a0b\u7684\u6d41\u6d41\u7a0b\u72b6\u6001\u8bbe\u7f6e\u4e3a\u9a8c\u6536", (Object)billId);
            this.purchaseProcessService.saveOrUpdate((Object)processEntity, false);
        }
        return CommonResponse.success((String)"\u91c7\u8d2d\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

