package com.ejianc.business.house.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 房屋登记
 * 
 * @author generator
 * 
 */
public class FwdjVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer fclx; // 房产类型，0房产证，1未有房产证
    private String fwqlr; // 房屋权利人，默认郑州一建集团
    private String bdcbh; // 不动产编号
    private String bhczh; // 不动产证号
    private String fwzl; // 房屋坐落
    private BigDecimal fwmj; // 房屋面积
    private Integer sjyt; // 设计用途，0住宅用地/成套住宅，1用地/非成套住宅，2商务金融用地/办公，3商业服务，4工业用地/其他
    private String tdzh; // 土地证号
    private BigDecimal tdmj; // 土地面积
    private String tdxz; // 土地性质
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fzrq; // 发证日期
    private Integer qllx; // 权利类型，0国有建设用地使用权，1房屋所有权
    private String qlxz; // 权利性质，0出让/市场化商品房，1划拨/福利房，2出让/自建房
    private Long fwjgId; // 房屋结构id
    private String fwjgName; // 房屋结构名称
    private Integer zcs; // 总层数
    private Integer szlc; // 所在楼层
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jgrq; // 竣工日期
    private String remark; // 备注
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Date beginDate; // 开始日期
    private Date endDate; // 结束日期
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改人
    private Integer fwzt; // 房屋状态，0正常，1已出售
    private Integer zlzt; // 租赁状态，0已承租，1空闲
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getFclx() {
        return fclx;
    }

    public void setFclx(Integer fclx) {
        this.fclx = fclx;
    }
    public String getFwqlr() {
        return fwqlr;
    }

    public void setFwqlr(String fwqlr) {
        this.fwqlr = fwqlr;
    }
    public String getBdcbh() {
        return bdcbh;
    }

    public void setBdcbh(String bdcbh) {
        this.bdcbh = bdcbh;
    }
    public String getBhczh() {
        return bhczh;
    }

    public void setBhczh(String bhczh) {
        this.bhczh = bhczh;
    }
    public String getFwzl() {
        return fwzl;
    }

    public void setFwzl(String fwzl) {
        this.fwzl = fwzl;
    }
    public BigDecimal getFwmj() {
        return fwmj;
    }

    public void setFwmj(BigDecimal fwmj) {
        this.fwmj = fwmj;
    }
    public Integer getSjyt() {
        return sjyt;
    }

    public void setSjyt(Integer sjyt) {
        this.sjyt = sjyt;
    }
    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }
    public BigDecimal getTdmj() {
        return tdmj;
    }

    public void setTdmj(BigDecimal tdmj) {
        this.tdmj = tdmj;
    }
    public String getTdxz() {
        return tdxz;
    }

    public void setTdxz(String tdxz) {
        this.tdxz = tdxz;
    }
    public Date getFzrq() {
        return fzrq;
    }

    public void setFzrq(Date fzrq) {
        this.fzrq = fzrq;
    }
    public Integer getQllx() {
        return qllx;
    }

    public void setQllx(Integer qllx) {
        this.qllx = qllx;
    }

    public String getQlxz() {
        return qlxz;
    }

    public void setQlxz(String qlxz) {
        this.qlxz = qlxz;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFwjgId() {
        return fwjgId;
    }
    @ReferDeserialTransfer
    public void setFwjgId(Long fwjgId) {
        this.fwjgId = fwjgId;
    }
    public String getFwjgName() {
        return fwjgName;
    }

    public void setFwjgName(String fwjgName) {
        this.fwjgName = fwjgName;
    }
    public Integer getZcs() {
        return zcs;
    }

    public void setZcs(Integer zcs) {
        this.zcs = zcs;
    }
    public Integer getSzlc() {
        return szlc;
    }

    public void setSzlc(Integer szlc) {
        this.szlc = szlc;
    }
    public Date getJgrq() {
        return jgrq;
    }

    public void setJgrq(Date jgrq) {
        this.jgrq = jgrq;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Integer getFwzt() {
        return fwzt;
    }

    public void setFwzt(Integer fwzt) {
        this.fwzt = fwzt;
    }
    public Integer getZlzt() {
        return zlzt;
    }

    public void setZlzt(Integer zlzt) {
        this.zlzt = zlzt;
    }
    
}
