package com.ejianc.business.hr.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.RegisterTypeDataVO;
import com.ejianc.business.hr.vo.ResidencyUserDataVO;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.hr.service.IBaseUserService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Controller
@RequestMapping("baseUser")
public class BaseUserController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBaseUserService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryAllUserData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserDataVO>> queryAllUserData(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");

//        service.queryHrOrgData("1");
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        if (param.getParams().containsKey("workYear")) {
            String flag = param.getParams().get("workYear").getValue().toString();
            param.getParams().remove("workYear");
            if ("1".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year = 1"));
            } else if ("2".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 1 + " and work_year <=" + 3));
            } else if ("3".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 3 + " and work_year <=" + 5));
            } else if ("4".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 5 + " and work_year <=" + 10));
            } else if ("5".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 10 + " and work_year <=" + 15));
            } else if ("6".equals(flag)) {
                param.getParams().put("workYear", new Parameter(QueryParam.SQL, "work_year > " + 15));
            }
        }
        if (param.getParams().containsKey("age")) {
            String flag = param.getParams().get("age").getValue().toString();

            param.getParams().remove("age");
            if ("1".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age <= 25"));
            } else if ("2".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 25 + " and age <=" + 35));
            } else if ("3".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 35 + " and age <=" + 45));
            } else if ("4".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 45 + " and age <=" + 55));
            } else if ("5".equals(flag)) {
                param.getParams().put("age", new Parameter(QueryParam.SQL, "age > " + 55));
            }
        }
        if (param.getParams().containsKey("title")) {
            String flag = param.getParams().get("title").getValue().toString();

            if ("0".equals(flag)) {
                param.getParams().remove("title");
                param.getParams().put("title", new Parameter(QueryParam.SQL, "title is null or title = ''"));
            }
        }
        if (param.getParams().containsKey("educationName")) {
            String flag = param.getParams().get("educationName").getValue().toString();

            if ("无".equals(flag)) {
                param.getParams().remove("educationName");
                param.getParams().put("educationName", new Parameter(QueryParam.SQL, "education_name is null or education_name = '' or education_id = 99 "));
            }
        }

        if (param.getParams().containsKey("departmentName")) {
            String flag = param.getParams().get("departmentName").getValue().toString();

            if (("待岗人员".equals(flag) && "ne".equals(param.getParams().get("departmentName").getType())) || "非待岗人员".equals(flag)) {
                param.getParams().remove("departmentName");
                param.getParams().put("departmentName", new Parameter(QueryParam.SQL, "(department_name is null or department_name != '待岗人员') "));
            }
        }
        /**
         *实现分页
         */
        Page<UserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<UserDataVO> userDataVOS = service.queryAllUserData(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryRegisterReport 查询所有建造师信息
     */
    @RequestMapping(value = "/queryRegisterReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RegisterTypeDataVO>> queryRegisterReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        /**
         *实现分页
         */
        Page<RegisterTypeDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<RegisterTypeDataVO> vos = service.queryRegisterReport(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (RegisterTypeDataVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(vos);


        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryResidencyUserData 查询所有派驻信息
     */
    @RequestMapping(value = "/queryResidencyUserData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryResidencyUserData(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        if(param.getParams().get("org_name") != null && "null".equals(param.getParams().get("org_name").getValue().toString())){
            param.getParams().put("org_name",new Parameter(QueryParam.EQ, null));
        }
        if(param.getParams().get("department_name") != null && "null".equals(param.getParams().get("department_name").getValue().toString())){
            param.getParams().put("department_name",new Parameter(QueryParam.EQ, null));
        }
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = null;
//        List<String> orgCodes = new ArrayList<>();
//        if (!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getName());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgName", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }
        /**
         *实现分页
         */
        Page<ResidencyUserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<ResidencyUserDataVO> vos = service.queryResidencyUserData(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (ResidencyUserDataVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }
        page.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryUserChangeData 查询人事信息
     */
    @RequestMapping(value = "/queryUserChangeData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserDataVO>> queryUserChangeData(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("h.A0101");
        fuzzyFields.add("a.A0100");
        fuzzyFields.add("a.dw");
        fuzzyFields.add("a.gw");
        fuzzyFields.add("c.codeitemdesc");
        /**
         * 组织隔离
         */
        //普通组织 id
//        List<OrgVO> orgVOList = null;
//        List<String> orgCodes = new ArrayList<>();
//        if (!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getName());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgName", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }

        param.getParams().put("postName", new Parameter(QueryParam.LIKE, "人事"));
        /**
         *实现分页
         */
        Page<ResidencyUserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<ResidencyUserDataVO> vos = service.queryUserChangeData(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (ResidencyUserDataVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        page.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryUserChangeData 查询人事信息
     */
    @RequestMapping(value = "/queryOrgType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryOrgType(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getOrderMap().put("typeCode","asc");
        /**
         *实现分页
         */
        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryOrgType(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * @param param
     * @Description queryUserType
     */
    @RequestMapping(value = "/queryUserType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TypeVO>> queryUserType(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /**
         *实现分页
         */
        Page<TypeVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryUserType(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
