package com.ejianc.business.hr.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.service.IResidencyUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.ResidencyUserVO;
import com.ejianc.business.hr.vo.UnderReportVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.business.hr.vo.UserMnyDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 派驻人员管理
 *
 * @author Jiang
 *
 */
@Controller
@RequestMapping("residencyUser")
public class ResidencyUserController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IResidencyUserService residencyUserService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUserApi userApi;


    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryResidencyUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyUser(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");

//        service.queryHrOrgData("1");
        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        /**
         *实现分页
         */
        Page<ResidencyUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
//        param.getParams().put("residencyType",new Parameter(QueryParam.NE,null));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<ResidencyUserVO> userDataVOS = residencyUserService.queryResidencyUser(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryResidencyRange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyRange(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");

//        service.queryHrOrgData("1");
//        /**
//         * 组织隔离
//         */
//        //普通组织 id
//        List<OrgVO> orgVOList = new ArrayList<>();
//        List<String> orgCodes = new ArrayList<>();
//        if(!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getCode());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }

        /**
         *实现分页
         */
        Page<ResidencyUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        param.getParams().put("e_type_name",new Parameter(QueryParam.EQ,"在岗"));
        param.getParams().put("post_code",new Parameter(QueryParam.IN, Arrays.asList(1,2)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<ResidencyUserVO> userDataVOS = residencyUserService.queryResidencyRange(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @param param
     * @Description queryAllUserData 查询人员基本信息
     */
    @RequestMapping(value = "/queryResidencyProjectRange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ResidencyUserVO>> queryResidencyProjectRange(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");

//        service.queryHrOrgData("1");
//        /**
//         * 组织隔离
//         */
//        //普通组织 id
//        List<OrgVO> orgVOList = new ArrayList<>();
//        List<String> orgCodes = new ArrayList<>();
//        if(!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getCode());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }

        if(param.getParams().get("org_name") != null && "null".equals(param.getParams().get("org_name").getValue().toString())){
            param.getParams().put("org_name",new Parameter(QueryParam.EQ, null));
        }
        if(param.getParams().get("department_name") != null && "null".equals(param.getParams().get("department_name").getValue().toString())){
            param.getParams().put("department_name",new Parameter(QueryParam.EQ, null));
        }
        /**
         *实现分页
         */
        Page<ResidencyUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        param.getParams().put("e_type_name",new Parameter(QueryParam.EQ,"在岗"));
        param.getParams().put("post_code",new Parameter(QueryParam.IN, Arrays.asList(1,2)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<ResidencyUserVO> userDataVOS = residencyUserService.queryResidencyProjectRange(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserDataVO reportVO : userDataVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }

        page.setRecords(userDataVOS);
        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
