package com.ejianc.business.hr.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.mapper.BaseUserMapper;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.utils.DateUtil;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UnderReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 人员结构
 *
 * @author generator
 */
@Controller
@RequestMapping("userStruct")
public class UserStructController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBaseUserService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private BaseUserMapper baseUserMapper;

    /**
     * @param param
     * @Description querySexType
     * 年龄分布饼状图;
     */
    @RequestMapping(value = "/querySexType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> querySexType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.querySexType(null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }


    /**
     * @param param
     * @Description queryWorkYearType
     * 工龄分布饼状图;
     */
    @RequestMapping(value = "/queryWorkYearType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryWorkYearType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        List<TypeVO> typeVOS = service.queryWorkYearType(null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryAgeType
     * 年龄分布饼状图;
     */
    @RequestMapping(value = "/queryAgeType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryAgeType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.queryAgeType(null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryEductionType
     * 学历分布饼状图;
     */
    @RequestMapping(value = "/queryEductionType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryEductionType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.queryEductionType(null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryZcType
     * 职称分布饼状图;
     */
    @RequestMapping(value = "/queryZcType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryZcType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }


        List<TypeVO> typeVOS = service.queryZcType(null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryRegisterTypeDetail
     * 根据组织获取证书类别分布
     */
    @RequestMapping(value = "/queryRegisterType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryRegisterType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.queryRegisterType(null, null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryRegisterTypeDetail
     * 根据组织获取建造师类别分布
     */
    @RequestMapping(value = "/queryRegisterTypeDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryRegisterTypeDetail(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        String registerType = "10101";
        if (param.getParams().get("registerType") != null) {
            registerType = param.getParams().get("registerType").getValue().toString();
        }
        List<TypeVO> typeVOS = service.queryRegisterTypeDetail(null, registerType);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryUserLevel
     * 根据组织获取核心人才梯队
     */
    @RequestMapping(value = "/queryUserLevel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryUserLevel(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        List<TypeVO> typeVOS = service.queryUserLevel(null, null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryRegisterTypeDetail
     * 根据组织获取建造师类别分布
     */
    @RequestMapping(value = "/queryUserChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryUserChange(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        String typeCode = null;
        Integer year = null;
        Integer month = null;
        if (param.getParams().get("typeCode") != null) {
            typeCode = param.getParams().get("typeCode").getValue().toString();
        }
        if (param.getParams().get("year") != null) {
            year = Integer.valueOf(param.getParams().get("year").getValue().toString());
        }
        if (param.getParams().get("month") != null) {
            month = Integer.valueOf(param.getParams().get("month").getValue().toString());
        }
        List<TypeVO> typeVOS = new ArrayList<>();
        if (typeCode.equals("6")) {
            typeVOS = service.queryUserChangeLz(null, null, year, month);
        } else {
            typeVOS = service.queryUserChange(null, typeCode, year, month);
        }
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryMnyChange
     * 根据组织获取近12个月工资总额波动
     */
    @RequestMapping(value = "/queryMnyChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryMnyChange(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        List<TypeVO> typeVOS = service.queryMnyChange(null);
        return CommonResponse.success("查询列表数据成功！", typeVOS);
    }

    /**
     * @param param
     * @Description queryMnyChange
     * 根据组织获取近12个月工资总额波动
     */
    @RequestMapping(value = "/queryUnderMnyChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UnderReportVO>> queryUnderMnyChange(@RequestBody QueryParam param) {

        param.getOrderMap().put("date", "asc");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<UnderReportVO> underReportVOS = baseUserMapper.queryUnderChange(wrapper);
        return CommonResponse.success("查询列表数据成功！", underReportVOS);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
