package com.ejianc.business.hr.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.hr.vo.*;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.hr.bean.BaseUserEntity;
import com.ejianc.business.hr.mapper.BaseUserMapper;
import com.ejianc.business.hr.service.IBaseUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Service("baseUserService")
public class BaseUserServiceImpl extends BaseServiceImpl<BaseUserMapper, BaseUserEntity> implements IBaseUserService {

    @Autowired
    private BaseUserMapper baseUserMapper;

    @Override
    public List<HrOrgVO> queryHrOrgData(String orgCode) {

        return baseUserMapper.queryHrOrgData(orgCode);
    }



    @Override
    public List<UserDataVO> queryAllUserData(Page<UserDataVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryAllUserData(page, wrapper);
    }

    @Override
    public List<RegisterTypeDataVO> queryRegisterReport(Page<RegisterTypeDataVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryRegisterReport(page, wrapper);
    }

    @Override
    public List<ResidencyUserDataVO> queryResidencyUserData(Page<ResidencyUserDataVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryResidencyUserData(page, wrapper);
    }

    @Override
    public List<ResidencyUserDataVO> queryUserChangeData(Page<ResidencyUserDataVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryUserChangeData(page, wrapper);
    }

    @Override
    public List<TypeVO> querySexType(List<String> orgCodes) {

        List<TypeVO> typeVOS = baseUserMapper.querySexType(orgCodes);
        for (TypeVO typeVO : typeVOS) {
            if (StrUtil.isNotBlank(typeVO.getType())) {
                if (typeVO.getType().equals("1")) {
                    typeVO.setType("男");
                }
                if (typeVO.getType().equals("2")) {
                    typeVO.setType("女");
                }
            }
        }

        return typeVOS;
    }

    @Override
    public List<TypeVO> queryWorkYearType(List<String> orgCodes) {
        List<TypeVO> typeVOS = baseUserMapper.queryWorkYearType(orgCodes);
        for (TypeVO typeVO : typeVOS) {
            if (StrUtil.isNotBlank(typeVO.getType())) {
                switch (typeVO.getType()) {
                    case "1":
                        typeVO.setType("1年");
                        break;
                    case "2":
                        typeVO.setType("1-3年");
                        break;
                    case "3":
                        typeVO.setType("3-5年");
                        break;
                    case "4":
                        typeVO.setType("5-10年");
                        break;
                    case "5":
                        typeVO.setType("10-15年");
                        break;
                    case "6":
                        typeVO.setType("15年以上");
                        break;
                }
            }
        }
        return typeVOS;
    }

    @Override
    public List<TypeVO> queryAgeType(List<String> orgCodes) {
        List<TypeVO> typeVOS = baseUserMapper.queryAgeType(orgCodes);
        for (TypeVO typeVO : typeVOS) {
            if (StrUtil.isNotBlank(typeVO.getType())) {
                switch (typeVO.getType()) {
                    case "1":
                        typeVO.setType("25岁以下");
                        break;
                    case "2":
                        typeVO.setType("25-35岁");
                        break;
                    case "3":
                        typeVO.setType("35-45岁");
                        break;
                    case "4":
                        typeVO.setType("45-55岁");
                        break;
                    case "5":
                        typeVO.setType("55岁以上");
                        break;
                }
            }
        }
        return typeVOS;
    }

    @Override
    public List<TypeVO> queryEductionType(List<String> orgCodes) {

        return baseUserMapper.queryEductionType(orgCodes);
    }

    @Override
    public List<TypeVO> queryZcType(List<String> orgCodes) {

        return baseUserMapper.queryZcType(orgCodes);
    }

    @Override
    public List<TypeVO> queryRegisterType(List<String> orgCodes, List<String> typeCodes) {
        List<TypeVO> typeVOS = baseUserMapper.queryRegisterType(orgCodes, typeCodes);
        for (TypeVO typeVO : typeVOS) {
            if (StrUtil.isNotBlank(typeVO.getTypeCode())) {
                switch (typeVO.getTypeCode()) {
                    case "01":
                        typeVO.setType("注册一级设计师");
                        break;
                    case "05":
                        typeVO.setType("注册会计师");
                        break;
                    case "09":
                        typeVO.setType("注册一级建造师");
                        break;
                    case "14":
                        typeVO.setType("注册二级建造师");
                        break;
                    case "15":
                        typeVO.setType("注册安全工程师");
                        break;
                    case "16":
                        typeVO.setType("注册造价工程师");
                        break;
                    case "17":
                        typeVO.setType("注册监理工程师");
                        break;
                    case "99":
                        typeVO.setType("其他");
                        break;
                }
            }
        }
        return typeVOS;
    }

    @Override
    public List<TypeVO> queryRegisterTypeDetail(List<String> orgCodes, String registerType) {
        return baseUserMapper.queryRegisterTypeDetail(orgCodes, registerType);
    }

    @Override
    public List<TypeVO> queryUserLevel(List<String> orgCodes, List<String> typeCodes) {
        return baseUserMapper.queryUserLevel(orgCodes, typeCodes);
    }

    @Override
    public List<TypeVO> queryOrgType(Page<TypeVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryOrgType(page, wrapper);
    }

    @Override
    public List<TypeVO> queryUserChange(List<String> orgCodes, String typeCode, Integer year, Integer month) {
        return baseUserMapper.queryUserChange(orgCodes, typeCode, year, month);
    }
    @Override
    public List<TypeVO> queryUserChangeLz(List<String> orgCodes, String typeCode, Integer year, Integer month) {
        return baseUserMapper.queryUserChangeLz(orgCodes, typeCode, year, month);
    }
    @Override
    public List<TypeVO> queryMnyChange(List<String> orgCodes) {
        return baseUserMapper.queryMnyChange(orgCodes);
    }

    @Override
    public List<UserMnyDetailVO> queryUserMnyDetail(Page<UserMnyDetailVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryUserMnyDetail(page, wrapper);
    }

    @Override
    public List<UserMnyDetailVO> queryUserMnyData(Page<UserMnyDetailVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryUserMnyData(page, wrapper);
    }

    @Override
    public List<UnderReportVO> queryUnderReport(Page<UnderReportVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryUnderReport(page, wrapper);
    }

    @Override
    public List<UnderReportVO> queryOrgUnder(Page<UnderReportVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryOrgUnder(page, wrapper);
    }

    @Override
    public List<TypeVO> queryUserType(Page<TypeVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryUserType(page,wrapper);
    }

    @Override
    public List<UnderReportVO> queryOrgUnderNum(Page<UnderReportVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryOrgUnderNum(page,wrapper);
    }
}
