package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.vo.HrAllUserESVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import java.net.URLEncoder;

import com.ejianc.framework.core.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.*;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Author sunxy
 * @Date 22/7/14 11:37
 */
@RestController
@RequestMapping("/es/")
public class EsController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final long serialVersionUID = 1L;

    private final static Integer QUERY_TIMEOUT = 60;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    /**
     * 在职人员一览表es索引
     */
    private final static String HR_INDEX_NAME = "hr_useryl";

    @Autowired(required = false)
    private RestHighLevelClient client;

    @Autowired
    private IUserApi userApi;


    /**
     * 人员任职情况报表
     *
     * @return
     */
    @RequestMapping(value = "getHrAllUserESVO", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<HrAllUserESVO>> employeePage(@RequestBody QueryParam param) {
        //1.ES初始化对象
        //分页对象
        IPage<HrAllUserESVO> page = new Page<>();
        int pageNumber = param.getPageIndex();//当前页
        int pageSize = param.getPageSize();//分页条数
        Map<String, Parameter> params = param.getParams();//前端查询参数
        //ES查询对象
        SearchRequest searchRequest = new SearchRequest(HR_INDEX_NAME);//索引库
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();

        //2.构建查询条件
        //2.1搜索框搜索词
        if (StringUtils.isNotBlank(param.getSearchText())) {
            MatchQueryBuilder emName = QueryBuilders.matchQuery("dw", param.getSearchText());

            boolQuery.must(emName.operator(Operator.AND));
//            boolQuery.must(QueryBuilders.matchAllQuery());
        }
        //2.2组织隔离
//        List<String> orgIdS = new ArrayList<>();
//        List<OrgVO> orgVOS = new ArrayList<>();
//
//        //手机端
//        if(null != params.get("orgId")){
//            Long orgId = Long.valueOf(params.get("orgId").getValue().toString());
//            orgVOS = orgApi.findChildrenByParentId(orgId).getData();
//            params.remove("orgId");
//
//        }
//        //电脑端
//        else {
//            orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
//        }
//        if (orgVOS != null && orgVOS.size() > 0) {
//            for (OrgVO vo : orgVOS) {
//                orgIdS.add(String.valueOf(vo.getId()));
//            }
//        }
//        boolQuery.filter(QueryBuilders.termsQuery("orgId", orgIdS));
        //2.3查询参数
        //TODO 跳转中携带参数处理


        //2.4其他查询参数进行模糊搜索
        for (Map.Entry<String, Parameter> p : params.entrySet()) {
            String key = p.getKey();
            String value = getParamValue(params, key);
            if (StringUtils.isBlank(value)) {
                continue;
            }
            boolQuery.must(QueryBuilders.matchQuery(key, value));
        }
        //2.5分页
        searchRequest.source().from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        searchRequest.source().size(pageSize);
        searchRequest.source().query(boolQuery);
        //2.6排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    searchRequest.source().sort(entry.getKey(), SortOrder.ASC);
                } else {
                    searchRequest.source().sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }
        //2.7放入查询条件
        searchRequest.source().query(boolQuery);
        //3.发送查询请求
        try {
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            //3.1文档类型转换
            ArrayList<HrAllUserESVO> list = new ArrayList<>();
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                logger.info("----------------ES获取数据为--------------：{}", sourceAsString);
                list.add(JSON.parseObject(sourceAsString, HrAllUserESVO.class));
                //3.2处理数据
                /**
                 * url etoken生成并放入VO返回
                 */
                //4.封装pageVO
                page.setCurrent(pageNumber);
                page.setSize(pageSize);
                //查询结果
                page.setRecords(list);
                //总条数
                page.setTotal(hits.getTotalHits().value);
            }
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 paramMap 条件，查询全部记录索引失败，MSG：" + e.getMessage());

        }

        return CommonResponse.success("查询成功！", page);
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

