package com.ejianc.business.hr.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.vo.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.hr.bean.BaseUserEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Mapper
public interface BaseUserMapper extends BaseCrudMapper<BaseUserEntity> {
    /**
     * 查询所有人员信息
     *
     * @return
     */
    List<UserDataVO> queryAllUserData(Page<UserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询所有建造师信息
     *
     * @return
     */
    List<RegisterTypeDataVO> queryRegisterReport(Page<RegisterTypeDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询所有派驻信息
     *
     * @return
     */
    List<ResidencyUserDataVO> queryResidencyUserData(Page<ResidencyUserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询人事信息
     *
     * @return
     */
    List<ResidencyUserDataVO> queryUserChangeData(Page<ResidencyUserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询本下所有组织信息
     *
     * @return
     */
    List<HrOrgVO> queryHrOrgData(@Param("orgCode") String orgCode);


    /**
     * 根据组织获取性别分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> querySexType(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据组织获取工龄分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryWorkYearType(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据组织获取年龄分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryAgeType(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据组织获取学历分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryEductionType(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据组织获取职称分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryZcType(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据组织获取证书类别分布
     *
     * @param orgCodes
     * @param typeCodes 证书种类，不传查询全部
     * @return
     */
    List<TypeVO> queryRegisterType(@Param("orgCodes") List<String> orgCodes, @Param("typeCodes") List<String> typeCodes);

    /**
     * 根据组织获取建造师类别分布
     *
     * @return
     */
    List<TypeVO> queryRegisterTypeDetail(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据组织获取核心人才梯队
     *
     * @param orgCodes
     * @param typeCodes 人员梯队种类，不传查询全部
     * @return
     */
    List<TypeVO> queryUserLevel(@Param("orgCodes") List<String> orgCodes, @Param("typeCodes") List<String> typeCodes);

    /**
     * 根据组织查询组织人员分布
     *
     * @return
     */
    List<TypeVO> queryOrgType(Page<TypeVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 根据组织查询人员类别分布
     *
     * @return
     */
    List<TypeVO> queryUserType(Page<TypeVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);


    /**
     * 根据组织获取人事异动
     *
     * @param orgCodes
     * @param typeCode 人事异动类型，不传查询全部
     * @param year
     * @param month
     * @return
     */
    List<TypeVO> queryUserChange(@Param("orgCodes") List<String> orgCodes,
                                 @Param("typeCodes") List<String> typeCodes,
                                 @Param("year") Integer year,
                                 @Param("month") Integer month);

    /**
     * 根据组织获取人事异动离职
     *
     * @return
     */
    List<TypeVO> queryUserChangeLz(@Param("orgCodes") List<String> orgCodes,
                                   @Param("typeCodes") List<String> typeCodes,
                                   @Param("year") Integer year,
                                   @Param("month") Integer month);


    /**
     * 根据组织获取近12个月工资总额波动
     *
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryMnyChange(@Param("orgCodes") List<String> orgCodes);

    /**
     * 查询人员欠薪明细
     *
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyDetail(Page<UserMnyDetailVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询个人欠薪统计
     *
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyData(Page<UserMnyDetailVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询单位欠薪明细
     *
     * @return
     */
    List<UnderReportVO> queryUnderReport(Page<UnderReportVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询单位欠薪统计
     *
     * @return
     */
    List<UnderReportVO> queryOrgUnder(Page<UnderReportVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<UnderReportVO> queryUnderChange(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<UnderReportVO> queryOrgUnderNum(Page<UnderReportVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询单位薪酬总额
     * @param page
     * @param wrapper
     * @return
     */
    List<OrgPayReportVO> queryOrgPayReport(Page<OrgPayReportVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询单位薪酬总额汇总数据
     * @param page
     * @param wrapper
     * @return
     */
    OrgPayReportVO queryOrgPayReportSum( @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询人员薪酬明细
     * @param page
     * @param wrapper
     * @return
     */
    List<SalaryDetailVO> querySalaryDetail(Page<SalaryDetailVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询单位薪资总额
     * @param page
     * @param wrapper
     * @return
     */
    List<SalaryDetailVO> queryOrgSalarySum(Page<SalaryDetailVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 查询岗级职级
     * @param page
     * @param wrapper
     * @return
     */
    List<JobLevelVO> queryJobLevelReport(Page<JobLevelVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

//    /**
//     * 培训管理每场培训参加人数
//     *
//     * @param startDate
//     * @param endDate
//     * @return
//     */
//    List<TypeVO> queryTrainTop(@Param("startDate") String startDate,
//                                 @Param("endDate") String endDate);

    /**
     * 培训管理每场培训参加人数
     *
     * @param startDate
     * @param endDate
     * @return
     */
    List<TypeVO> queryTrainTop(Page<TypeVO> page,
                               @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 培训管理分类
     *
     * @return
     */
    List<TypeVO> queryTrainType(Page<TypeVO> page,
                               @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 项目任职人员查询
     *
     * @return
     */
    List<ProjectEmployeeVO> queryEmployeeReport(Page<ProjectEmployeeVO> page,
                               @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 人员考勤月度明细
     *
     * @return
     */
    List<AttendanceMonthVO> queryAttendanceMonth(Page<AttendanceMonthVO> page,
                                                @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 组织考勤月度明细
     *
     * @return
     */
    List<AttendanceMonthVO> queryOrgAttendanceMonth(Page<AttendanceMonthVO> page,
                                                 @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 集团考勤月度明细
     *
     * @return
     */
    List<AttendanceMonthVO> queryCompanyAttendanceMonth(Page<AttendanceMonthVO> page,
                                                    @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 任职人员报表
     *
     * @return
     */
    List<ProjectEmployeeVO> queryEmployeeReportNum(Page<ProjectEmployeeVO> page,@Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("comName") String comName);


    /**
     * 招聘岗位明细列表
     *
     * @return
     */
    List<RecruitPostVO> queryRecruitPostList(Page<RecruitPostVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 门户-合同分类
     *
     * @return
     */
    List<TypeVO> queryContractType(@Param(Constants.WRAPPER) QueryWrapper wrapper);


    /**
     * 考核明细
     *
     * @return
     */
    List<AccessVO> accessList(Page<AccessVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    /**
     * 人事移动信息台账
     *
     * @return
     */
    List<UserChangeVO> queryUserChangeReport(Page<UserChangeVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);


}
