package com.ejianc.business.hr.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.bean.BaseUserEntity;
import com.ejianc.business.hr.vo.*;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
public interface IBaseUserService extends IBaseService<BaseUserEntity> {
    /**
     * 查询本下组织信息
     *
     * @return
     */
    List<HrOrgVO> queryHrOrgData(String orgCode);
    /**
     * 查询人员信息
     *
     * @return
     */
    List<UserDataVO> queryUserData(Page<UserDataVO> page, QueryWrapper wrapper);
    /**
     * 查询所有人员信息
     *
     * @return
     */
    List<UserDataVO> queryAllUserData(Page<UserDataVO> page, QueryWrapper wrapper);

    /**
     * 查询所有建造师信息
     *
     * @return
     */
    List<RegisterTypeDataVO> queryRegisterReport(Page<RegisterTypeDataVO> page, QueryWrapper wrapper);

    /**
     * 查询所有派驻信息
     *
     * @return
     */
    List<ResidencyUserDataVO> queryResidencyUserData(Page<ResidencyUserDataVO> page, QueryWrapper wrapper);

    /**
     * 查询人事信息
     *
     * @return
     */
    List<ResidencyUserDataVO> queryUserChangeData(Page<ResidencyUserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);


    /**
     * 根据组织过滤查询年龄分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> querySexType(QueryWrapper wrapper);

    /**
     * 根据组织过滤查询工龄分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryWorkYearType(QueryWrapper wrapper);

    /**
     * 根据组织获取年龄分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryAgeType(QueryWrapper wrapper);

    /**
     * 根据组织获取学历分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryEductionType(QueryWrapper wrapper);

    /**
     * 根据组织获取职称分布
     *
     * @param wrapper
     * @return
     */
    List<TypeVO> queryZcType(QueryWrapper wrapper);

    /**
     * 根据组织获取证书类别分布
     *
     * @param orgCodes
     * @param typeCodes 证书种类，不传查询全部
     * @return
     */
    List<TypeVO> queryRegisterType(List<String> orgCodes, List<String> typeCodes);

    /**
     * 根据组织获取建造师类别分布
     *
     * @return
     */
    List<TypeVO> queryRegisterTypeDetail(QueryWrapper wrapper);

    /**
     * 根据组织获取核心人才梯队
     *
     * @param orgCodes
     * @param typeCodes 人员梯队种类，不传查询全部
     * @return
     */
    List<TypeVO> queryUserLevel(List<String> orgCodes, List<String> typeCodes);

    /**
     * 根据组织查询组织人员分布
     *
     * @return
     */
    List<TypeVO> queryOrgType(Page<TypeVO> page, QueryWrapper wrapper);

    /**
     * 根据组织查询组织人员分布
     *
     * @return
     */
    List<TypeVO> queryUserType(Page<TypeVO> page, QueryWrapper wrapper);

    /**
     * 根据组织获取人事异动
     *
     * @param orgCodes
     * @param typeCode 人事异动类型，不传查询全部
     * @param year
     * @param month
     * @return
     */
    List<TypeVO> queryUserChange(List<String> orgCodes, List<String> typeCodes, Integer year, Integer month);
    List<TypeVO> queryUserChangeLz(List<String> orgCodes, List<String> typeCodes, Integer year, Integer month);
    List<TypeVO> queryUserChangeRetire(List<String> orgCodes, List<String> typeCodes, Integer year, Integer month);


    /**
     * 根据组织获取近12个月工资总额波动
     *
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryMnyChange(List<String> orgCodes);


    /**
     * 查询人员欠薪明细
     *
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyDetail(Page<UserMnyDetailVO> page, QueryWrapper wrapper);

    /**
     * 查询个人欠薪统计
     *
     * @param page
     * @param wrapper
     * @return
     */
    List<UserMnyDetailVO> queryUserMnyData(Page<UserMnyDetailVO> page, QueryWrapper wrapper);

    /**
     * 查询欠薪台账
     *
     * @return
     */
    List<UnderReportVO> queryUnderReport(Page<UnderReportVO> page, QueryWrapper wrapper);

    /**
     * 查询单位欠薪统计
     *
     * @return
     */
    List<UnderReportVO> queryOrgUnder(Page<UnderReportVO> page, QueryWrapper wrapper);

    List<UnderReportVO> queryOrgUnderNum(Page<UnderReportVO> page, QueryWrapper wrapper);

    List<OrgPayReportVO> queryOrgPayReport(Page<OrgPayReportVO> page, QueryWrapper wrapper);

    List<SalaryDetailVO> querySalaryDetail(Page<SalaryDetailVO> page, QueryWrapper wrapper);

    List<SalaryDetailVO> queryOrgSalarySum(Page<SalaryDetailVO> page, QueryWrapper wrapper);

    List<JobLevelVO> queryJobLevelReport(Page<JobLevelVO> page, QueryWrapper wrapper);

//    /**
//     * 培训管理每场培训参加人数
//     *
//     * @param startDate
//     * @param endDate
//     * @return
//     */
//    List<TypeVO> queryTrainTop(String startDate, String endDate);

    /**
     * 培训管理每场培训参加人数
     *
     * @param startDate
     * @param endDate
     * @return
     */
    List<TypeVO> queryTrainTop(Page<TypeVO> page, QueryWrapper wrapper);
    /**
     * 培训管理分类
     *
     * @return
     */
    List<TypeVO> queryTrainType(Page<TypeVO> page, QueryWrapper wrapper);

    /**
     * 项目任职人员查询
     *
     * @return
     */
    List<ProjectEmployeeVO> queryEmployeeReport(Page<ProjectEmployeeVO> page,QueryWrapper wrapper);

    /**
     * 人员考勤月度明细
     *
     * @return
     */
    List<AttendanceMonthVO> queryAttendanceMonth(Page<AttendanceMonthVO> page, QueryWrapper wrapper);

    /**
     * 组织考勤月度明细
     *
     * @return
     */
    List<AttendanceMonthVO> queryOrgAttendanceMonth(Page<AttendanceMonthVO> page,QueryWrapper wrapper);

    /**
     * 集团考勤月度明细
     *
     * @return
     */
    List<AttendanceMonthVO> queryCompanyAttendanceMonth(Page<AttendanceMonthVO> page,QueryWrapper wrapper);

    List<ProjectEmployeeVO> queryEmployeeReportNum(Page<ProjectEmployeeVO> page,QueryWrapper wrapper,String comName);



    /**
     * 招聘岗位明细列表
     *
     * @return
     */
    List<RecruitPostVO> queryRecruitPostList(Page<RecruitPostVO> page, QueryWrapper wrapper);
    /**
     * 门户-合同分类
     *
     * @return
     */
    List<TypeVO> queryContractType(QueryWrapper wrapper);



    /**
     * 考核明细
     *
     * @return
     */
    List<AccessVO> accessList(Page<AccessVO> page, QueryWrapper wrapper);


    /**
     * 查询单位薪酬总额汇总数据
     * @param page
     * @param wrapper
     * @return
     */
    OrgPayReportVO queryOrgPayReportSum(@Param(Constants.WRAPPER) QueryWrapper wrapper);


    /**
     * 人事移动信息台账
     *
     * @return
     */
    List<UserChangeVO> queryUserChangeReport(Page<UserChangeVO> page,QueryWrapper wrapper);


}
