package com.ejianc.foundation.orgcenter.vo;

import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.*;

/**
 * 员工vo
 * 
 * @author guominga
 *
 */
public class EmployeeVO extends BaseVO {

	private static final long serialVersionUID = 1879682970725795763L;

	/**
	 * 公司ID
	 */
	private Long orgId;

	/**
	 * 部门ID
	 */
	private Long deptId;

	/**
	 * 岗位ID
	 */
	private Long postId;

	/**
	 * 员工编号
	 */
	private String code;

	/**
	 * 员工名称
	 */
	private String name;

	/**
	 * 头像
	 */
	private String photoPath;

	/**
	 * 身份证号
	 */
	private String idcard;

	/**
	 * 出生日期
	 */
	private Date birthday;

	/**
	 * 性别 1：男 2：女
	 */
	private Integer sex;

	/**
	 * 手机号码
	 */
	private String mobilePhone;

	/**
	 * 其他电话
	 */
	private String otherPhone;

	/**
	 * 员工状态（1:在职，2：离职， 3：退休， 4：退休返聘）
	 */
	private Integer employeeType;

	/**
	 * 备注
	 */
	private String note;

	/**
	 * 状态标识 (1:启用，0：停用)
	 */
	private Integer state;

	/**
	 * 是否部门负责人 1：是 0：否
	 */
	private Integer deptHead;

	/**
	 * 排序
	 */
	private Integer sequence;

	/**
	 * 用户Id
	 */
	private Long userId;

	private String userName;//审批流使用,兼容之前的接口遗留的字段（-> <-）

	/**
	 * 入职时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date workTime;

	/* 页面展示字段 */

	/**
	 * 任职组织名称
	 */
	private String orgName;
	/**
	 * 任职部门名称
	 */
	private String deptName;
	/**
	 * 任职岗位名称
	 */
	private String postName;
	/**
	 * 职属类型：0-隶属，1-直属
	 */
	private int jobType;

	private Long jobId;

	private String userCode; // 用户登录账号

	private String sourceId; // 来源id

	private String systemId; // 系统id

	private Integer typeId;

	// 参照使用
	private Map<String, Object> org = new HashMap<>();
	private Map<String, Object> dept = new HashMap<>();
	private Map<String, Object> post = new HashMap<>();

	private String userSignaturePath; //用户签名图片路径

	/**
	 * 用户上传签名文件Id
	 */
	private Long userSignatureFileId;
	private List<String> subjectionList = new ArrayList<String>();
	private List<String> roleList= new ArrayList<>();
    private String projectPost;
	private List<String> directlyOrgList = new ArrayList<>();
   //n导出excel
    private String sexName;
    private String subjectionName;
    private String roleName;
	private String jobTypeName;
	private String directlyOrgName;

	private String roleIds; //职位授权角色id列表
	private String roleNames; //职位授权角色名称列表

	private String nation; // 民族 直接使用汉字
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date confirmationDate; // 转正日期
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date insuredDate; // 参保日期
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date resignationDate; // 离职日期
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date insuredEndDate; // 停保日期
	private String termOfLabor; // 劳动合同期限
	private String socialSecurityNum; // 社会保障号
	private String specialties; // 特长

	/**
	 * 华康医疗----start----
	 */
	private String postRankType; // 职级类别
	private String postRank; // 职级
	/**
	 * 华康医疗----end----
	 */

	private List<EmpEduVO> empEduList = new ArrayList<>(); // 学历信息
	private List<EmpCareerVO> empCareerList = new ArrayList<>(); // 入职经历
	private List<EmpBankVO> empBankList = new ArrayList<>(); // 员工银行信息
	/**
	 * 用户的任职角色授权信息
	 */
	private List<RoleUserRelationVO> roleDataList= new ArrayList<>();

	public Long getUserSignatureFileId() {
		return userSignatureFileId;
	}

	public void setUserSignatureFileId(Long userSignatureFileId) {
		this.userSignatureFileId = userSignatureFileId;
	}

	public String getUserSignaturePath() {
		return userSignaturePath;
	}

	public void setUserSignaturePath(String userSignaturePath) {
		this.userSignaturePath = userSignaturePath;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public Long getPostId() {
		return postId;
	}

	public void setPostId(Long postId) {
		this.postId = postId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPhotoPath() {
		return photoPath;
	}

	public void setPhotoPath(String photoPath) {
		this.photoPath = photoPath;
	}

	public String getIdcard() {
		return idcard;
	}

	public void setIdcard(String idcard) {
		this.idcard = idcard;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public Integer getSex() {
		return sex;
	}

	public void setSex(Integer sex) {
		this.sex = sex;
	}

	public String getMobilePhone() {
		return mobilePhone;
	}

	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}

	public String getOtherPhone() {
		return otherPhone;
	}

	public void setOtherPhone(String otherPhone) {
		this.otherPhone = otherPhone;
	}

	public Integer getEmployeeType() {
		return employeeType;
	}

	public void setEmployeeType(Integer employeeType) {
		this.employeeType = employeeType;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getPostName() {
		return postName;
	}

	public void setPostName(String postName) {
		this.postName = postName;
	}

	public int getJobType() {
		return jobType;
	}

	public void setJobType(int jobType) {
		this.jobType = jobType;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public Date getWorkTime() {
		return workTime;
	}

	public void setWorkTime(Date workTime) {
		this.workTime = workTime;
	}

	public Long getJobId() {
		return jobId;
	}

	public void setJobId(Long jobId) {
		this.jobId = jobId;
	}

	public Map<String, Object> getOrg() {
		this.org.put("id", this.orgId);
		this.org.put("name", this.orgName);
		return org;
	}

	public void setOrg(Map<String, Object> org) {
		this.org = org;
	}

	public Map<String, Object> getDept() {
		this.dept.put("id", this.deptId);
		this.dept.put("name", this.deptName);
		return dept;
	}

	public void setDept(Map<String, Object> dept) {
		this.dept = dept;
	}

	public Map<String, Object> getPost() {
		this.post.put("id", this.postId);
		this.post.put("name", this.postName);
		return post;
	}

	public void setPost(Map<String, Object> post) {
		this.post = post;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getUserName() {
		return name;
	}

	public Integer getTypeId() {
		return typeId;
	}

	public void setTypeId(Integer typeId) {
		this.typeId = typeId;
	}

	public Integer getDeptHead() {
		return deptHead;
	}

	public void setDeptHead(Integer deptHead) {
		this.deptHead = deptHead;
	}

	public List<String> getSubjectionList() {
		return subjectionList;
	}

	public void setSubjectionList(List<String> subjectionList) {
		this.subjectionList = subjectionList;
	}

	public String getProjectPost() {
		return projectPost;
	}

	public void setProjectPost(String projectPost) {
		this.projectPost = projectPost;
	}

	public List<String> getRoleList() {
		return roleList;
	}

	public void setRoleList(List<String> roleList) {
		this.roleList = roleList;
	}

	public String getSexName() {
		return sexName;
	}

	public void setSexName(String sexName) {
		this.sexName = sexName;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getSubjectionName() {
		return subjectionName;
	}

	public void setSubjectionName(String subjectionName) {
		this.subjectionName = subjectionName;
	}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	public String getJobTypeName() {
		return jobTypeName;
	}

	public void setJobTypeName(String jobTypeName) {
		this.jobTypeName = jobTypeName;
	}

	public List<String> getDirectlyOrgList() {
		return directlyOrgList;
	}

	public void setDirectlyOrgList(List<String> directlyOrgList) {
		this.directlyOrgList = directlyOrgList;
	}

	public String getDirectlyOrgName() {
		return directlyOrgName;
	}

	public void setDirectlyOrgName(String directlyOrgName) {
		this.directlyOrgName = directlyOrgName;
	}

	public List<RoleUserRelationVO> getRoleDataList() {
		return roleDataList;
	}

	public void setRoleDataList(List<RoleUserRelationVO> roleDataList) {
		this.roleDataList = roleDataList;
	}

	@ReferSerialTransfer(referCode = "idm-role")
	public String getRoleIds() {
		return roleIds;
	}

	@ReferDeserialTransfer
	public void setRoleIds(String roleIds) {
		this.roleIds = roleIds;
	}

	public String getRoleNames() {
		return roleNames;
	}

	public void setRoleNames(String roleNames) {
		this.roleNames = roleNames;
	}

	public List<EmpEduVO> getEmpEduList() {
		return empEduList;
	}

	public void setEmpEduList(List<EmpEduVO> empEduList) {
		this.empEduList = empEduList;
	}

	public List<EmpCareerVO> getEmpCareerList() {
		return empCareerList;
	}

	public void setEmpCareerList(List<EmpCareerVO> empCareerList) {
		this.empCareerList = empCareerList;
	}

	public List<EmpBankVO> getEmpBankList() {
		return empBankList;
	}

	public void setEmpBankList(List<EmpBankVO> empBankList) {
		this.empBankList = empBankList;
	}

	public String getNation() {
		return nation;
	}

	public void setNation(String nation) {
		this.nation = nation;
	}

	public Date getConfirmationDate() {
		return confirmationDate;
	}

	public void setConfirmationDate(Date confirmationDate) {
		this.confirmationDate = confirmationDate;
	}

	public Date getInsuredDate() {
		return insuredDate;
	}

	public void setInsuredDate(Date insuredDate) {
		this.insuredDate = insuredDate;
	}

	public Date getResignationDate() {
		return resignationDate;
	}

	public void setResignationDate(Date resignationDate) {
		this.resignationDate = resignationDate;
	}

	public Date getInsuredEndDate() {
		return insuredEndDate;
	}

	public void setInsuredEndDate(Date insuredEndDate) {
		this.insuredEndDate = insuredEndDate;
	}

	public String getTermOfLabor() {
		return termOfLabor;
	}

	public void setTermOfLabor(String termOfLabor) {
		this.termOfLabor = termOfLabor;
	}

	public String getSocialSecurityNum() {
		return socialSecurityNum;
	}

	public void setSocialSecurityNum(String socialSecurityNum) {
		this.socialSecurityNum = socialSecurityNum;
	}

	public String getSpecialties() {
		return specialties;
	}

	public void setSpecialties(String specialties) {
		this.specialties = specialties;
	}

	public String getPostRankType() {
		return postRankType;
	}

	public void setPostRankType(String postRankType) {
		this.postRankType = postRankType;
	}

	public String getPostRank() {
		return postRank;
	}

	public void setPostRank(String postRank) {
		this.postRank = postRank;
	}
}
