package com.ejianc.foundation.sync.api;

import com.ejianc.foundation.sync.hystrix.SyncHystrix;
import com.ejianc.foundation.sync.vo.SyncBaseDeptVO;
import com.ejianc.foundation.sync.vo.SyncBaseUserVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 同步数据的rpc服务--公共方法
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = SyncHystrix.class)
public interface ISyncBaseApi {

	//同步部门信息
	@PostMapping(value = "api/sync/syncDeptList")
	public CommonResponse<String> syncDeptList(@RequestBody List<SyncBaseDeptVO> deptList);
	//删除部门信息
	@PostMapping(value = "api/sync/delDeptList")
	public CommonResponse<String> delDeptList(@RequestBody List<String> deptSourceIdList);

	//同步人员
	@PostMapping(value = "api/sync/syncUserList")
	public CommonResponse<String> syncUserList(@RequestBody List<SyncBaseUserVO> userList);

	//停用人员信息
	@PostMapping(value = "api/sync/disableUserList")
	public CommonResponse<String> disableUserList(@RequestBody List<String> userSourceIdList);

	//停用人员信息
	@PostMapping(value = "api/sync/enableUserList")
	public CommonResponse<String> enableUserList(@RequestBody List<String> userSourceIdList);
}
