package com.ejianc.foundation.tenant.api;

import com.ejianc.foundation.tenant.hystrix.IdmWebEnterpriseHystrix;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 这个实现在 idm-web里面
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = IdmWebEnterpriseHystrix.class)
public interface IidmWebEnterpriseApi {

	//根据所给企业id查询所属企业信息
	@GetMapping(value = "/api/enterprise/getEnterpriseById")
    CommonResponse<EnterpriseVO> getEnterpriseById(@RequestParam("id") Long id);


	//根据所给租户id查询租户所属企业信息
	@GetMapping(value = "/api/enterprise/getEnterpriseByTenantId")
    CommonResponse<EnterpriseVO> getEnterpriseByTenantId(@RequestParam("tenantId") Long tenantId);

}
