package com.ejianc.foundation.dataCompare.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.dataCompare.hystrix.DataCompareHystrix;
import com.ejianc.foundation.dataCompare.vo.DataCompareDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author liyj
 * @Description:
 * @date 2024/1/19 13:56
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = DataCompareHystrix.class)
public interface IDataCompareApi {

    /**
     * 查询数据对照字段信息
     * systemCode 系统code（必须）
     * appCode 应用code（必须）
     * selfDataId 本系统数据id
     * selfDataCode 本系统数据编码
     * @return
     */
    @GetMapping(value = "/api/dataCompare/getDataList")
    CommonResponse<JSONObject> getDataList(@RequestParam(value = "systemCode") String systemCode,
                                           @RequestParam(value = "appCode") String appCode,
                                           @RequestParam(value = "selfDataId") String selfDataId,
                                           @RequestParam(value = "selfDataCode") String selfDataCode) ;

    /**
     * 查询数据对照字段信息
     * appId 应用id（必须）
     * selfDataCodeList 本系统数据编码集合
     * @return
     */
    @GetMapping(value = "/api/dataCompare/getData")
    public CommonResponse<List<DataCompareDetailVO>> getData(@RequestParam(value = "appId") Long appId,
                                                                 @RequestParam(value = "selfDataCodeList") List<String> selfDataCodeList);


    /**
     * @description: 获取多个app codemap
     *
     * @param appMap key appId, value 本地编码list
     * @return {@link CommonResponse< Map< String, String>>} key:appId + 本地编码；value：对接编码
     * @author songlx
     * @date: 2024/1/23
     */
    @PostMapping(value = "/api/dataCompare/getAppDataMap")
    CommonResponse<Map<String, String>> getAppDataMap(@RequestBody Map<Long, List<String>> appMap);
}
