package com.ejianc.foundation.openapi.vo;

import java.util.ArrayList;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/10 10:04
 */
public class SecurityKeyVO extends BaseVO {
	private static final long serialVersionUID = 1180953469909811693L;

	/**
	 * 参数缺失
	 */
	public static final String ERR_CODE_EMPTY_PARAM = "9001";
	/**
	 * 无效参数
	 */
	public static final String ERR_CODE_INVALID_PARAM = "9002";
	/**
	 * appid已经被停用
	 */
	public static final String ERR_CODE_OVERDUE_PARAM = "9003";

	/**
	 * 服务内部出错
	 */
	public static final String ERR_CODE_INTERNAL_ERR = "9000";

	/**
	 * 申请对象
	 */
	private String securityName;

	/**
	 * 应用Id
	 */
	private String appId;

	/**
	 * 密钥
	 */
	private String secretKey;

	/**
	 * 生效连接url,多个逗号分隔
	 */
	private String includeUrls;

	/**
	 * 描述
	 */
	private String secretDesc;

	/**
	 * 状态： 1：启用，0：停用
	 */
	private Integer secretState;

	// 子表
	private List<SecurityKeyDetailVO> gridheaders = new ArrayList<SecurityKeyDetailVO>();

	public String getSecurityName() {
		return securityName;
	}

	public void setSecurityName(String securityName) {
		this.securityName = securityName;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getSecretKey() {
		return secretKey;
	}

	public void setSecretKey(String secretKey) {
		this.secretKey = secretKey;
	}

	public String getIncludeUrls() {
		return includeUrls;
	}

	public void setIncludeUrls(String includeUrls) {
		this.includeUrls = includeUrls;
	}

	public String getSecretDesc() {
		return secretDesc;
	}

	public void setSecretDesc(String secretDesc) {
		this.secretDesc = secretDesc;
	}

	public Integer getSecretState() {
		return secretState;
	}

	public void setSecretState(Integer secretState) {
		this.secretState = secretState;
	}

	public List<SecurityKeyDetailVO> getGridheaders() {
		return gridheaders;
	}

	public void setGridheaders(List<SecurityKeyDetailVO> gridheaders) {
		this.gridheaders = gridheaders;
	}

}
