package com.ejianc.foundation.sign.api;

import com.ejianc.foundation.permission.hystrix.RoleHystrix;
import com.ejianc.foundation.sign.hystrix.SignHystrix;
import com.ejianc.foundation.sign.vo.SignVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 角色rpc服务
 * 
 * @author cJ
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = SignHystrix.class)
public interface ISignApi {

	/**
	 * 根据用户id查询数据
	 *
	 * @param 
	 * @return
	 */
	@GetMapping(value = "/api/signApi/queryByUserIdList")
    CommonResponse<List<SignVO>> queryByUserIdList(@RequestParam(value = "userList") List<Long> userList);

}
