package com.ejianc.foundation.usercenter.hystrix;

import com.ejianc.foundation.usercenter.api.ISupplierUserProjectApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/6 13:56
 */
@Component
public class SupplierUserProjectHystrix implements ISupplierUserProjectApi {
    /**
     * 供方（公有云）使用，根据用户id查询该用户拥有的私有化项目id集合
     *
     * @param userId
     * @return
     */
    @Override
    public CommonResponse<List<Long>> getProjectIdsByUserId(Long userId) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 供方（公有云）使用，业务数据保存时候，调用该接口，保存业务数据里面的项目信息，供后续业务使用
     *
     * @param projectId   项目id
     * @param code        项目code
     * @param name        项目name
     * @param cooperation 该项目所在的私有化企业id，也就是systemid，企业表的id
     * @return
     */
    @Override
    public CommonResponse<Boolean> saveSupplierProject(Long projectId, String code, String name, Long cooperation) {
        return CommonResponse.error("网络问题，查询失败。");
    }
}
