package com.ejianc.foundation.usercenter.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/6 13:56
 */
@Component
public class FaceHystrix implements IFaceAndIdCardService {

    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param imgUrl 人脸照片地址
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @Override
    public CommonResponse<Boolean> checkFaceQuality(String imgUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }


    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param bytes 人脸照片byte数组
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @Override
    public CommonResponse<Boolean> checkFaceQualityByte(byte[] bytes) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 人脸照片活体检查
     * 通过，返回true，不通过返回false
     *
     * @param imgUrl
     *
     * @return
     */
    @Override
    public CommonResponse<Boolean> liveCheck(String imgUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 对比两张图片是否是同一个人
     * 是，返回true，不是返回false
     * 支持URL与Base64编码字符串混合输入。
     * 例如：输入imgUrlA和imgBase64B的值，不输入imgUrlB和imgBase64A的值,合法。
     *
     * @param imgUrlA
     * @param imgUrlB
     * @param imgBase64A
     * @param imgBase64B
     * @return
     */
    @Override
    public CommonResponse<Boolean> compareFace(JSONObject param) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 对比两张图片是否是同一个人 支持戴口罩进行识别
     * <p>
     * 仅支持Base64编码字符串输入。
     *
     * @param imgBase64A
     * @param imgBase64B
     * @return 是，返回true，不是返回false
     */
    @Override
    public CommonResponse<Boolean> compareFaceWithMask(JSONObject param) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 创建人脸数据库用户
     *
     * @param userId
     * @param userName
     * @return
     */
    @Override
    public CommonResponse<Boolean> createFaceDbUser(Long userId, String userName) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 更新人脸数据库用户
     *
     * @param userId
     * @param userName
     * @return
     */
    @Override
    public CommonResponse<Boolean> updateFaceDbUser(Long userId, String userName) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 删除人脸数据库用户
     *
     * @param userId
     * @return
     */
    @Override
    public CommonResponse<Boolean> deleteFaceDbUser(Long userId) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 查询人脸数据库用户是否存在
     * true 已存在，false不存在
     *
     * @param userId
     * @return
     */
    @Override
    public CommonResponse<Boolean> getFaceDbUser(Long userId) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param imgUrl
     * @return userId
     */
    @Override
    public CommonResponse<List<Long>> getUserByFaceImg(String imgUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param bytes
     * @return userId
     */
    @Override
    public CommonResponse<List<Long>> getUserByFaceImgByte(byte[] bytes) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 添加人脸数据到指定用户
     *
     * @param userId
     * @param imageUrl
     * @return
     */
    @Override
    public CommonResponse<Boolean> addFaceToUser(Long userId, String imageUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 身份证件是否翻拍校验
     * true 翻拍，false 直拍
     *
     * @param imageUrl
     * @return
     */
    @Override
    public CommonResponse<Boolean> detectCardScreenshot(String imageUrl) {
        return CommonResponse.error("网络问题，查询失败。");
    }

    /**
     * 身份证件 信息识别
     * true 翻拍，false 直拍
     * @param imageUrl
     * @param side face：人像面  back：国徽面
     * @return side 是 back 才返回startDate，endDate，issue
     *
     * {
     *     name:姓名,
     *     gender:性别：男、女,
     *     nationality:民族:汉,
     *     birthDate:出生19901122,
     *     address:住址,
     *     idNumber:身份证号,
     *
     *     startDate:起始有效期20200102,
     *     endDate:截止有效期20290102,
     *     issue:颁发机关：xxx公安局
     * }
     */
    @Override
    public CommonResponse<JSONObject> recognizeIdentityCardInfo(String imageUrl, String side) {
        return CommonResponse.error("网络问题，查询失败。");
    }
}
