/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.orgcenter.api;

import com.ejianc.foundation.orgcenter.hystrix.OrgHystrix;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback=OrgHystrix.class)
public interface IOrgApi {
    @RequestMapping(value={"/api/org/getChildrenByPid"}, method={RequestMethod.GET})
    public CommonResponse<List<OrgVO>> findChildrenByParentId(@RequestParam(value="orgId") Long var1);

    @RequestMapping(value={"/api/org/findChildrenByParentIdWithoutProjectDept"}, method={RequestMethod.GET})
    public CommonResponse<List<OrgVO>> findChildrenByParentIdWithoutProjectDept(@RequestParam(value="orgId") Long var1);

    @RequestMapping(value={"/api/org/findChildrenByParentIdsWithoutProjectDept"}, method={RequestMethod.POST})
    public CommonResponse<List<OrgVO>> findChildrenByParentIdsWithoutProjectDept(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/org/findChildrenByParentIds"}, method={RequestMethod.POST})
    public CommonResponse<List<OrgVO>> findChildrenByParentIds(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/org/getParentsByOrgId"}, method={RequestMethod.GET})
    public CommonResponse<List<OrgVO>> findParentsByOrgId(@RequestParam(value="orgId") Long var1);

    @GetMapping(value={"api/org/getOneById"})
    public CommonResponse<OrgVO> getOneById(@RequestParam(value="id") Long var1);

    @PostMapping(value={"api/org/findAllByIds"})
    public CommonResponse<List<OrgVO>> findAllByIds(@RequestBody List<Long> var1);

    @PostMapping(value={"api/org/saveOrgInfo"})
    public CommonResponse<OrgVO> saveOrgInfo(@RequestBody OrgVO var1);

    @GetMapping(value={"api/org/findByNameAndTenantId"})
    public CommonResponse<OrgVO> findByNameAndTenantId(@RequestParam(value="name") String var1, @RequestParam(value="tenantId") Long var2);

    @PostMapping(value={"api/org/saveProOrgList"})
    public CommonResponse<String> saveProOrgList(@RequestBody List<OrgVO> var1);

    @RequestMapping(value={"/api/org/findBySourceId"}, method={RequestMethod.GET})
    public CommonResponse<OrgVO> findBySourceId(@RequestParam(value="sourceId") String var1);

    @RequestMapping(value={"/api/org/findParentByOrgId"}, method={RequestMethod.GET})
    public CommonResponse<OrgVO> findParentByOrgId(@RequestParam(value="orgId") Long var1);

    @RequestMapping(value={"/api/org/findDeptBySourceId"}, method={RequestMethod.GET})
    public CommonResponse<DeptVO> findDeptBySourceId(@RequestParam(value="sourceId") String var1);

    @RequestMapping(value={"/api/org/findProjectOrgsByUserId"}, method={RequestMethod.GET})
    public CommonResponse<List<OrgVO>> findProjectOrgsByUserId(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"api/org/getDirectChildrenByPid"})
    public CommonResponse<List<OrgVO>> getDirectChildrenByPid(@RequestParam(value="parentId", required=false) Long var1, @RequestParam(value="searchText", required=false) String var2);

    @GetMapping(value={"api/org/findOrgByTenantId"})
    public CommonResponse<OrgVO> findOrgByTenantId(@RequestParam(value="tenantId", required=false) Long var1);

    @GetMapping(value={"api/org/findMainOrgByTenantId"})
    public CommonResponse<List<String>> findMainOrgByTenantId(@RequestParam(value="tenantId", required=false) Long var1);

    @RequestMapping(value={"/api/org/findDepartmentByTenantId"}, method={RequestMethod.GET})
    public CommonResponse<List<OrgVO>> findDepartmentByTenantId(@RequestParam(value="tenantId") Long var1, @RequestParam(value="typeList") List<Integer> var2);

    @RequestMapping(value={"/api/org/detailById"}, method={RequestMethod.GET})
    public CommonResponse<OrgVO> detailById(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/org/findOrgByType"})
    public CommonResponse<List<OrgVO>> findOrgByType(@RequestParam(value="tenantId") Long var1, @RequestParam(value="typeList") List<Integer> var2, @RequestParam(value="searchText", required=false) String var3);

    @GetMapping(value={"/api/org/findOrgByTypesAndOrgId"})
    public CommonResponse<List<OrgVO>> findOrgByTypesAndOrgId(@RequestParam(value="tenantId") Long var1, @RequestParam(value="typeList") List<Integer> var2, @RequestParam(value="searchText", required=false) String var3, @RequestParam(value="orgId") Long var4);

    @PostMapping(value={"api/org/delByOrgId"})
    public CommonResponse<String> delByOrgId(@RequestBody Long var1);

    @GetMapping(value={"api/org/delById"})
    public CommonResponse<String> delById(@RequestParam(value="id") Long var1);

    @PostMapping(value={"api/org/delSDSJPrjDepartmentByOrgId"})
    public CommonResponse<String> delSDSJPrjDepartmentByOrgId(@RequestBody Long var1);

    @PostMapping(value={"api/org/findOneByOrgVO"})
    public CommonResponse<OrgVO> findOneByOrgVO(@RequestBody OrgVO var1);

    @RequestMapping(value={"/api/org/findDeptById"}, method={RequestMethod.GET})
    public CommonResponse<DeptVO> findDeptById(@RequestParam(value="deptId") Long var1);
}

