package com.ejianc.foundation.news.vo;

import java.util.Date;
import java.util.List;

import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 新闻vo
 * 
 * @author liyongjia
 */
public class NewsVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	private String title; // 新闻标题

	private Long orgId; // 发布组织ID

	private Integer publishFlag; // 是否发布 ， 1：发布 ， 0：未发布

	private String publishUser; // 发布人

	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date publishTime; // 发布时间

	private String introduce; // 简介

	private Integer topFlag; // 是否置顶, 1:置顶 ， 0： 取消置顶

	private String filePath; // 封面图片

	private Integer rotationFlag; // 是否加入轮播, 1: 是， 0： 否

	private String content; // 内容

	private String author; // 作者

	private Integer newsType; // 新闻类型 1--新闻动态，2--客户案例，3--行业观点,4--解决方案,5--视频课程

	private String newsUrl; // 外部链接地址

	private String enclosurePath; // 附件url地址

	private List<AttachmentVO> attachmentVos;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@ReferSerialTransfer(referCode = "idm-org")
	public Long getOrgId() {
		return orgId;
	}

	@ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getPublishFlag() {
		return publishFlag;
	}

	public void setPublishFlag(Integer publishFlag) {
		this.publishFlag = publishFlag;
	}

	public String getPublishUser() {
		return publishUser;
	}

	public void setPublishUser(String publishUser) {
		this.publishUser = publishUser;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public Integer getTopFlag() {
		return topFlag;
	}

	public void setTopFlag(Integer topFlag) {
		this.topFlag = topFlag;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Integer getRotationFlag() {
		return rotationFlag;
	}

	public void setRotationFlag(Integer rotationFlag) {
		this.rotationFlag = rotationFlag;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public Integer getNewsType() {
		return newsType;
	}

	public void setNewsType(Integer newsType) {
		this.newsType = newsType;
	}

	public String getNewsUrl() {
		return newsUrl;
	}

	public void setNewsUrl(String newsUrl) {
		this.newsUrl = newsUrl;
	}

	public String getEnclosurePath() {
		return enclosurePath;
	}

	public void setEnclosurePath(String enclosurePath) {
		this.enclosurePath = enclosurePath;
	}

	public List<AttachmentVO> getAttachmentVos() {
		return attachmentVos;
	}

	public void setAttachmentVos(List<AttachmentVO> attachmentVos) {
		this.attachmentVos = attachmentVos;
	}

}
