package com.ejianc.foundation.orgcenter.api;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.orgcenter.hystrix.UserHystrix;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 用户的rpc服务
 *
 * @author caojie
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = UserHystrix.class)
public interface IUserApi {

    /**
     * 查询指定组织下所有（本下）人员列表
     *
     * @param orgId
     * @return
     */
    @GetMapping("api/user/getEmployeeList")
    CommonResponse<List<Map<String, Object>>> getEmployeeList(@RequestParam(value = "orgId") Long orgId);

    /**
     * 查询组织下的某些岗位用户列表
     *
     * @param orgIds
     * @param postIds
     * @return
     */
    @GetMapping("api/user/queryUserByPostAndOrg")
    CommonResponse<List<UserVO>> queryUserByPostAndOrg(@RequestParam(value = "postIds") List<Long> postIds, @RequestParam(value = "orgIds", required = false) List<Long> orgIds);

	/**
	 * 根据来源id查询用户信息
	 *
	 * @param sourceId
	 * @return
	 */
	@RequestMapping(value = "api/user/findUserBySourceId", method=RequestMethod.GET)
    CommonResponse<UserVO> findUserBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * 根据用户数组查询用户列表（查询所有租户的----若是一个用户在多个租户下会返回多条结果（租户不同））
	 * 
	 * @param receivers
	 * @return
	 */
	@RequestMapping(value = "no_auth/api/user/queryListByIds", method=RequestMethod.GET)
    CommonResponse<List<UserVO>> queryListByIds(@RequestParam(value = "receivers") String[] receivers);

	/**
	 * 根据用户数组查询用户列表(跨租户查询)
	 * 
	 * @param receivers
	 * @return
	 */
	@RequestMapping(value = "no_auth/api/user/queryListByIdsTenantId", method=RequestMethod.GET)
    CommonResponse<List<UserVO>> queryListByIdsTenantId(@RequestParam(value = "receivers") String[] receivers, @RequestParam(value = "tenantId") Long tenantId);

	/**
	 * 根据用户编码查询用户详情
	 *
	 * @param userCode
	 * @return
	 */
	@GetMapping(value = "api/user/findUserByUserCode")
    CommonResponse<UserVO> queryUserByUserCode(@RequestParam(value = "userCode") String userCode);

	/**
	 * 根据用户编码列表查询用户详情
	 *
	 * @param userCodes
	 * @return
	 */
	@GetMapping(value = "api/user/findUserByUserCodes")
    CommonResponse<List<UserVO>> queryUserByUserCodes(@RequestParam(value = "userCodes") String[] userCodes);
	/**
	 * 根据用户主键查询用户详情
	 *
	 * @param userId
	 * @return
	 */
	@GetMapping(value = "api/user/findUserByUserId")
    CommonResponse<UserVO> findUserByUserId(@RequestParam(value = "userId") Long userId);

	/**
	 * 查询当前租户下 与指定角色名称管理的所有用户列表
	 *  （提供12局使用）
	 *
	 * @param roleNames
	 * @return
	 */
	@GetMapping(value = "api/user/findAllUserByRoleNameList")
    CommonResponse<List<UserVO>> findAllUserByRoleNameList(@RequestParam(value = "roleNames") List<String> roleNames);

	@GetMapping(value = "api/user/findByUserMobile")
    CommonResponse<UserVO> findByUserMobile(@RequestParam(value = "phone") String phone);
	/**
	 * 通过微信公众号返回的code 换取openid 再根据openid查询供方用户信息
	 * 和该租户对应的供应商id
	 * 仅供供方使用
	 *
	 * @param code     微信传的 code
	 * @param systemId 私有化企业在公有云的企业id
	 * @param tenantId 需要协同分享的租户id
	 * @return 格式{userInfo:{},supplierId:xxx} 对应值如果没有会置为null，例如{userInfo:null,supplierId:xxx}，返回值不会为空
	 */
	@GetMapping(value = "api/user/querySupplierUserInfoByWXCode")
	CommonResponse<JSONObject> querySupplierUserInfoByWXCode(@RequestParam(value = "code") String code,
																	@RequestParam(value = "systemId") String systemId,
																	@RequestParam(value = "tenantId") String tenantId);

	@RequestMapping(value = "no_auth/api/user/getUserContextBySourceId", method=RequestMethod.GET)
	public CommonResponse<JSONObject> getUserContextBySourceId(@RequestParam(value = "sourceId") String sourceId);
}

