package com.ejianc.foundation.orgcenter.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.List;

/**
 * ClassName: PostDictionaryVO
 * Description:
 * Date: 2022/3/20 22:14
 *
 * @version:
 * @since JDK 1.8
 */


public class PostDictionaryVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 岗位状态：启用
     */
    public static Integer POST_STATE_ACTIVE = 1;

    /**
     * 岗位状态：停用
     */
    public static Integer POST_STATE_INACTIVE = 0;

    /**
     * 岗位编码
     */
    private String code;

    /**
     * 岗位名称
     */
    private String name;

    /**
     * 备注
     */
    private String note;

    /**
     * 状态（1：启用， 0：停用）
     */
    private Integer state;

    /**
     * 排序号
     */
    private Integer sequence;

    private Long pid;// 上级Id

    private String innerCode; // 内码

    /**
     * 岗位来源数据Id
     */
    private String sourceId;

    private Boolean isLeaf;	//是否叶子节点

    private Boolean isParent;

    /**
     * 岗位层级
     */
    private Integer postLevel;


    private List<PostDictionaryVO> children;


    public Boolean getIsParent() {
        return isParent;
    }

    public void setIsParent(Boolean parent) {
        isParent = parent;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean leaf) {
        isLeaf = leaf;
    }

    public List<PostDictionaryVO> getChildren() {
        return children;
    }

    public void setChildren(List<PostDictionaryVO> children) {
        this.children = children;
    }

    public Integer getPostLevel() {
        return postLevel;
    }

    public void setPostLevel(Integer postLevel) {
        this.postLevel = postLevel;
    }

    private String systemId; // 系统id

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

