package com.ejianc.foundation.resource.api;

import com.ejianc.foundation.resource.hystrix.ResourceHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * @author mrsir
 * @Description: 系统资源api
 * @date 2023年10月27日
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = ResourceHystrix.class)
public interface IResourceApi {


    /**
     * 校验并使用租户的某个系统资源
     *
     * @param resourceCode 要操作资源编码
     * @param tenantId     租户id
     * @param useNum       要操作的数量
     * @param opType       操作类型,字符串：add:      添加相应的资源数量到租户该资源账户余额；
     *                                   subtract: 从租户的该资源账户余额中扣除相应的资源数量
     * @param describe     操作具体描述，例如：人脸识别扣减、xxx原因退回账户
     *
     * @return CommonResponse.code == 0 && CommonResponse.data == true :操作成功，其他操作失败
     */
    @GetMapping(value = "/api/resource/checkAndUseResource")
    CommonResponse<Boolean> checkAndUseResource(@RequestParam("resourceCode") String resourceCode, @RequestParam("tenantId") Long tenantId,
                                                @RequestParam("useNum") BigDecimal useNum, @RequestParam("opType") String opType,
                                                @RequestParam("describe") String describe);

    /**
     * 校验 租户是否开通某个系统资源
     *
     * @param resourceCode 要校验的资源编码
     * @param tenantId     租户id
     *
     * @return CommonResponse.code == 0 && CommonResponse.data == true :已开通资源，其未开通资源
     */
    @GetMapping(value = "/api/resource/checkResource")
    CommonResponse<Boolean> checkResource(@RequestParam("resourceCode") String resourceCode, @RequestParam("tenantId") Long tenantId);


}
