package com.ejianc.foundation.sync.api;

import com.ejianc.foundation.sync.hystrix.ZzyjSyncHystrix;
import com.ejianc.foundation.sync.vo.ZzyjOrgResponseVO;
import com.ejianc.foundation.sync.vo.ZzyjPostResponseVO;
import com.ejianc.foundation.sync.vo.ZzyjUserResponseVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 郑州一建同步数据的rpc服务
 */
@FeignClient(name = "ejc-idm-web", url = "${common.env.feign-client-url}", path = "ejc-idm-web", fallback = ZzyjSyncHystrix.class)
public interface IZzyjSyncApi {


    /**
     * 组织+部门
     */
    @PostMapping(value = "api/zzyjSync/syncOrg")
    CommonResponse<String> syncOrg(ZzyjOrgResponseVO zzyjOrgResponseVO);

    /**
     * 人员
     */
    @PostMapping(value = "api/zzyjSync/syncUser")
    CommonResponse<String> syncUser(ZzyjUserResponseVO zzyjUserResponseVO);


    /**
     * 岗位
     */
    @PostMapping(value = "api/zzyjSync/syncPost")
    CommonResponse<String> syncPost(ZzyjPostResponseVO zzyjPostResponseVO);
}
