package com.ejianc.foundation.usercenter.vo;

import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author CJ
 * @Description: 移动通讯录用户
 * @date 2020/9/10 14:11
 */
public class MaOrgUserVO implements Serializable {

    private static final long serialVersionUID = -3694516458248936657L;

    private Long id;
    private String createUserCode;
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    private String updateUserCode;
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;
    private Integer dr;
    private Long tenantId;
    private String createUserName;
    private String updateUserName;
    /**
     * 所属公司ID
      */
    private Long orgId;
    /**
     * 用户昵称
     */
    private String userName;
    /**
     * 用户账号（区分大小写）
     */
    private String userCode;
    /**
     * 用户手机号
     */
    private String userMobile;
    /**
     * 用户邮箱
     */
    private String userEmail;
    /**
     * 用户性别（1：男，2：女）
     */
    private String sex;
    /**
     * 用户类型（1：超级管理员，2：普通用户）
     */
    private Integer typeId;
    /**
     * 用户头像
     */
    private String avator;
    /**
     * 企业微信Id
     */
    private String weixineeId;
    /**
     * 微信Id
     */
    private String weixinId;
    /**
     * 钉钉Id
     */
    private String dingdingId;
    /**
     * qq ID
     */
    private String qqId;

    private String firstWrodRegion;

    /**
     * 员工状态（1:在职，2：离职， 3：退休， 4：退休返聘）
     */
    private Integer employeeType;
    /**
     * 是否部门负责人 1：是 0：否
     */
    private Integer deptHead;
    /**
     * 企业名称
     */
    private String enterpriseName;
    /**
     * 任职组织名称
     */
    private String orgName;
    /**
     * 任职部门名称
     */
    private String deptName;
    /**
     * 任职岗位名称
     */
    private String postName;
    /**
     * 员工编号
     */
    private String empCode;

    List<JobVO> secondOrgInfo = new ArrayList<>();

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public Integer getEmployeeType() {
        return employeeType;
    }

    public void setEmployeeType(Integer employeeType) {
        this.employeeType = employeeType;
    }

    public Integer getDeptHead() {
        return deptHead;
    }

    public void setDeptHead(Integer deptHead) {
        this.deptHead = deptHead;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public String getEmpCode() {
        return empCode;
    }

    public void setEmpCode(String empCode) {
        this.empCode = empCode;
    }

    public List<JobVO> getSecondOrgInfo() {
        return secondOrgInfo;
    }

    public void setSecondOrgInfo(List<JobVO> secondOrgInfo) {
        this.secondOrgInfo = secondOrgInfo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCreateUserCode() {
        return createUserCode;
    }

    public void setCreateUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateUserCode() {
        return updateUserCode;
    }

    public void setUpdateUserCode(String updateUserCode) {
        this.updateUserCode = updateUserCode;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getDr() {
        return dr;
    }

    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUserMobile() {
        return userMobile;
    }

    public void setUserMobile(String userMobile) {
        this.userMobile = userMobile;
    }

    public String getUserEmail() {
        return userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public Integer getTypeId() {
        return typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public String getAvator() {
        return avator;
    }

    public void setAvator(String avator) {
        this.avator = avator;
    }

    public String getWeixineeId() {
        return weixineeId;
    }

    public void setWeixineeId(String weixineeId) {
        this.weixineeId = weixineeId;
    }

    public String getWeixinId() {
        return weixinId;
    }

    public void setWeixinId(String weixinId) {
        this.weixinId = weixinId;
    }

    public String getDingdingId() {
        return dingdingId;
    }

    public void setDingdingId(String dingdingId) {
        this.dingdingId = dingdingId;
    }

    public String getQqId() {
        return qqId;
    }

    public void setQqId(String qqId) {
        this.qqId = qqId;
    }

    public String getFirstWrodRegion() {
        return firstWrodRegion;
    }

    public void setFirstWrodRegion(String firstWrodRegion) {
        this.firstWrodRegion = firstWrodRegion;
    }
}
