package com.ejianc.foundation.orgcenter.hystrix;

import org.springframework.stereotype.Component;

import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;
import java.util.Map;

@Component
public class EmployeeHystrix implements IEmployeeApi {

	@Override
	public CommonResponse<EmployeeVO> queryEmployeByUserId(Long userId) {
		return CommonResponse.error("网络异常， 查询员工信息失败");
	}

	@Override
	public CommonResponse<String> manageProjectMembers(Map<String, Object> memberInfo) {
		return CommonResponse.error("网络问题，保存项目成员失败。");
	}

	@Override
	public CommonResponse<String> manageUpdateProjectMembers(Map<String, Object> memberInfo) {
		return CommonResponse.error("网络问题，保存项目成员失败。");

	}

	/**
	 * @param userId
	 * @Author mrsir_wxp
	 * @Date 2021/3/10 根据用户id查询用户主兼职组织id
	 * @Description getJobOrgIdsByUserId
	 * @Param [userId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.orgcenter.vo.EmployeeVO>
	 */
	@Override
	public CommonResponse<List<Long>> getJobOrgIdsByUserId(Long userId,Long tenantId) {
		return CommonResponse.error("网络问题，查询任职组织失败。");
	}

	@Override
	public CommonResponse<EmployeeVO> getById(Long id) {
		return CommonResponse.error("网络问题，查询成员信息失败。");
	}

	@Override
	public CommonResponse<List<EmployeeVO>> getByIds(List<Long> ids) {
		return CommonResponse.error("网络问题，查询失败！");
	}

	@Override
	public CommonResponse<EmployeeVO> getByEmpmloyeeCode(String employeeCode) {
		return CommonResponse.error("网络问题，查询失败！");
	}

	@Override
	public CommonResponse<String> updateJobType(Map<String, Object> memberInfo) {
		return CommonResponse.error("网络问题，查询失败！");
	}

	@Override
	public CommonResponse<List<EmployeeVO>> queryEmployeeByPostAndOrg(List<Long> postIds, List<Long> orgIds) {
		return CommonResponse.error("网络问题，查询失败！");
	}

	@Override
	public CommonResponse<List<EmployeeVO>> getByCodeOrIdcard(List<String> codeOrIdcard) {
		return CommonResponse.error("网络问题，查询失败！");
	}

	@Override
	public CommonResponse<List<EmployeeVO>> queryEmployeeByDeptCode(String deptCode) {
		return CommonResponse.error("网络问题，查询失败！");
	}

}
