package com.ejianc.foundation.orgcenter.api;

import com.ejianc.foundation.orgcenter.hystrix.OrgHystrix;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 组织的rpc服务
 *
 * @author guoming
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = OrgHystrix.class)
public interface IOrgApi {
	/**
	 * 根据所给组织id，查询该组织本+下
	 */
	@RequestMapping(value = "/api/org/getChildrenByPid", method=RequestMethod.GET)
    CommonResponse<List<OrgVO>> findChildrenByParentId(@RequestParam(value = "orgId") Long orgId);
	/**
	 * 根据所给组织，查询该组织本+下非项目部组织
	 */
	@RequestMapping(value = "/api/org/findChildrenByParentIdWithoutProjectDept", method=RequestMethod.GET)
    CommonResponse<List<OrgVO>> findChildrenByParentIdWithoutProjectDept(@RequestParam(value = "orgId") Long orgId);

	/**
	 * 根据所给组织id集合，查询该组织集合所有组织本+下非项目部组织
	 */
	@RequestMapping(value = "/api/org/findChildrenByParentIdsWithoutProjectDept", method=RequestMethod.POST)
    CommonResponse<List<OrgVO>> findChildrenByParentIdsWithoutProjectDept(@RequestBody List<Long> orgIds);
	/**
	 * 根据所给组织id集合，查询该组织集合所有组织本下
	 */
	@RequestMapping(value = "/api/org/findChildrenByParentIds", method=RequestMethod.POST)
    CommonResponse<List<OrgVO>> findChildrenByParentIds(@RequestBody List<Long> orgIds);

	/**
	 * 根据所给组织id，查询本上组织集合，返回值包含orgId组织本身
	 * */
	@RequestMapping(value = "/api/org/getParentsByOrgId", method=RequestMethod.GET)
    CommonResponse<List<OrgVO>> findParentsByOrgId(@RequestParam(value = "orgId") Long orgId);

	@GetMapping(value = "api/org/getOneById")
    CommonResponse<OrgVO> getOneById(@RequestParam(value = "id") Long id);

	/**
	 * 根据Id列表查询对应组织信息
	 *
	 * @param orgIds
	 * @return
	 */
	@PostMapping(value = "api/org/findAllByIds")
    CommonResponse<List<OrgVO>> findAllByIds(@RequestBody List<Long> orgIds);

	/**
	 * 项目部保存服务
	 *
	 * @param orgVO
	 * @return
	 */
	@PostMapping(value = "api/org/saveOrgInfo")
    CommonResponse<OrgVO> saveOrgInfo(@RequestBody OrgVO orgVO);

	/**
	 * 根据名称和租户Id查询对应的组织信息
	 *
	 * @param name
	 * @param tenantId
	 * @return
	 */
	@GetMapping(value = "api/org/findByNameAndTenantId")
    CommonResponse<OrgVO> findByNameAndTenantId(@RequestParam(value = "name") String name,
                                                @RequestParam(value = "tenantId") Long tenantId);

	@PostMapping(value = "api/org/saveProOrgList")
    CommonResponse<String> saveProOrgList(@RequestBody List<OrgVO> orgVOS);

	/**
	 * 根据来源id查询组织信息
	 *
	 * @param name
	 * @param sourceId
	 * @return
	 */
	@RequestMapping(value = "/api/org/findBySourceId", method=RequestMethod.GET)
    CommonResponse<OrgVO> findBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * 根据orgId查询其直接上级组织信息
	 *
	 * @param orgId
	 * @return
	 */
	@RequestMapping(value = "/api/org/findParentByOrgId", method=RequestMethod.GET)
    CommonResponse<OrgVO> findParentByOrgId(@RequestParam(value = "orgId") Long orgId);

	/**
	 * 根据来源id查询部门信息
	 *
	 * @param name
	 * @param sourceId
	 * @return
	 */
	@RequestMapping(value = "/api/org/findDeptBySourceId", method=RequestMethod.GET)
    CommonResponse<DeptVO> findDeptBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * 根据当前登录人查询其组织本下所有项目部
	 *
	 * @param userId
	 * @return
	 */
	@RequestMapping(value = "/api/org/findProjectOrgsByUserId", method=RequestMethod.GET)
    CommonResponse<List<OrgVO>> findProjectOrgsByUserId(@RequestParam(value = "userId") Long userId);

	/**
	 * 根据父组织Id查询直接子组织，父组织Id缺省时查询该租户的跟组织
	 *
	 * @param parentId
	 * @param searchText
	 * @return
	 */
	@GetMapping(value = "api/org/getDirectChildrenByPid")
    CommonResponse<List<OrgVO>> getDirectChildrenByPid(@RequestParam(value = "parentId", required = false) Long parentId,
                                                       @RequestParam(value = "searchText", required = false) String searchText);

	/**
	 * 根据租户ID查询其根节点组织信息
	 *
	 * @param tenantId
	 * @return
	 */
	@GetMapping(value = "api/org/findOrgByTenantId")
    CommonResponse<OrgVO> findOrgByTenantId(@RequestParam(value = "tenantId", required = false) Long tenantId);


	/**
	 * 根据租户ID查询组织(只包含集团和分公司)
	 *
	 * @param tenantId
	 * @return
	 */
	@GetMapping(value = "api/org/findMainOrgByTenantId")
    CommonResponse<List<String>> findMainOrgByTenantId(@RequestParam(value = "tenantId", required = false) Long tenantId);
	/**
	 * 根据租户ID查询组织
	 * @param tenantId
	 * @param typeList
	 * @return
	 */
	@RequestMapping(value = "/api/org/findDepartmentByTenantId", method=RequestMethod.GET)
    CommonResponse<List<OrgVO>> findDepartmentByTenantId(@RequestParam(value = "tenantId") Long tenantId,
                                                         @RequestParam(value = "typeList") List<Integer> typeList);

	/**
	 * 详情
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/org/detailById", method=RequestMethod.GET)
    CommonResponse<OrgVO> detailById(@RequestParam(value = "id") Long id);
	/**
	 * 根据租户ID查询组织(只包含集团和分公司)
	 *
	 * @return
	 */
	@GetMapping(value = "/api/org/findOrgByType")
    CommonResponse<List<OrgVO>> findOrgByType(@RequestParam(value = "tenantId") Long tenantId,
                                              @RequestParam(value = "typeList") List<Integer> typeList,
                                              @RequestParam(value = "searchText", required = false) String searchText);

	/**
	 * 删除项目对应项目部
	 *
	 * @param orgId
	 * @return
	 */
	@PostMapping(value = "api/org/delByOrgId")
    CommonResponse<String> delByOrgId(@RequestBody Long orgId);

	/**
	 * 删除组织
	 *
	 * @param id
	 * @return
	 */
	@GetMapping(value = "api/org/delById")
	CommonResponse<String> delById(@RequestParam(value = "id") Long id);

	/**
	 * 删除水电三局项目申请对应项目部
	 *
	 * @param orgId
	 * @return
	 */
	@PostMapping(value = "api/org/delSDSJPrjDepartmentByOrgId")
    CommonResponse<String> delSDSJPrjDepartmentByOrgId(@RequestBody Long orgId);

	/**
	 * 查询匹配的一条组织信息
	 *
	 * @param orgVO
	 * @return
	 */
	@PostMapping(value = "api/org/findOneByOrgVO")
    CommonResponse<OrgVO> findOneByOrgVO(@RequestBody OrgVO orgVO);
	
	/**
	 * 详情
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/org/findDeptById", method=RequestMethod.GET)
    CommonResponse<DeptVO> findDeptById(@RequestParam(value = "deptId") Long deptId);
}
