/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.orgcenter.api;

import com.ejianc.foundation.orgcenter.hystrix.EmployeeHystrix;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback=EmployeeHystrix.class)
public interface IEmployeeApi {
    @RequestMapping(value={"/api/employee/getByUserId"}, method={RequestMethod.GET})
    public CommonResponse<EmployeeVO> queryEmployeByUserId(@RequestParam(value="userId") Long var1);

    @PostMapping(value={"api/employee/manageProjectMembers"})
    public CommonResponse<String> manageProjectMembers(@RequestBody Map<String, Object> var1);

    @PostMapping(value={"api/employee/manageUpdateProjectMembers"})
    public CommonResponse<String> manageUpdateProjectMembers(@RequestBody Map<String, Object> var1);

    @RequestMapping(value={"api/employee/getJobOrgIdsByUserId"}, method={RequestMethod.GET})
    public CommonResponse<List<Long>> getJobOrgIdsByUserId(@RequestParam(value="userId") Long var1, @RequestParam(value="tenantId") Long var2);

    @RequestMapping(value={"/api/employee/getById"}, method={RequestMethod.GET})
    public CommonResponse<EmployeeVO> getById(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/employee/getByIds"})
    public CommonResponse<List<EmployeeVO>> getByIds(@RequestParam(value="ids") List<Long> var1);

    @RequestMapping(value={"/api/employee/getByEmployeeCode"}, method={RequestMethod.GET})
    public CommonResponse<EmployeeVO> getByEmpmloyeeCode(@RequestParam(value="emplmoyeeCode") String var1);

    @PostMapping(value={"api/employee/updateJobType"})
    public CommonResponse<String> updateJobType(@RequestBody Map<String, Object> var1);

    @GetMapping(value={"api/employee/queryEmployeeByPostAndOrg"})
    public CommonResponse<List<EmployeeVO>> queryEmployeeByPostAndOrg(@RequestParam(value="postIds") List<Long> var1, @RequestParam(value="orgIds") List<Long> var2);

    @RequestMapping(value={"/api/employee/getByCodeOrIdcard"}, method={RequestMethod.GET})
    public CommonResponse<List<EmployeeVO>> getByCodeOrIdcard(@RequestParam(value="codeOrIdcard") List<String> var1);

    @GetMapping(value={"api/employee/queryByDeptCode"})
    public CommonResponse<List<EmployeeVO>> queryEmployeeByDeptCode(@RequestParam(value="deptCode") String var1);
}

