/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.idmclient.cas.logout;

import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.idmclient.IdmFilterConfiguration;
import com.ejianc.framework.idmclient.cas.logout.SingleSignOutHandler;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.AbstractConfigurationFilter;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class SingleSignOutFilter
extends AbstractConfigurationFilter {
    private static final SingleSignOutHandler HANDLER = new SingleSignOutHandler();
    private AtomicBoolean handlerInitialized = new AtomicBoolean(false);
    IdmFilterConfiguration idmFilterConfiguration = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        if (!this.isIgnoreInitConfiguration()) {
            HANDLER.setArtifactParameterName(this.getPropertyFromInitParams(filterConfig, "artifactParameterName", "ticket"));
            HANDLER.setLogoutParameterName(this.getPropertyFromInitParams(filterConfig, "logoutParameterName", "logoutRequest"));
            HANDLER.setFrontLogoutParameterName(this.getPropertyFromInitParams(filterConfig, "frontLogoutParameterName", "SAMLRequest"));
            HANDLER.setRelayStateParameterName(this.getPropertyFromInitParams(filterConfig, "relayStateParameterName", "RelayState"));
            this.idmFilterConfiguration = (IdmFilterConfiguration)ctx.getBean("idmFilterConfiguration", IdmFilterConfiguration.class);
            String casUrl = this.idmFilterConfiguration.getCasUrl();
            if (StringUtils.isNotBlank((String)casUrl)) {
                HANDLER.setCasServerUrlPrefix(casUrl);
            } else {
                HANDLER.setCasServerUrlPrefix(this.getPropertyFromInitParams(filterConfig, "casServerUrlPrefix", null));
            }
            HANDLER.setArtifactParameterOverPost(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "artifactParameterOverPost", "false")));
        }
        HANDLER.init();
        this.handlerInitialized.set(true);
    }

    public void setArtifactParameterName(String name) {
        HANDLER.setArtifactParameterName(name);
    }

    public void setLogoutParameterName(String name) {
        HANDLER.setLogoutParameterName(name);
    }

    public void setFrontLogoutParameterName(String name) {
        HANDLER.setFrontLogoutParameterName(name);
    }

    public void setRelayStateParameterName(String name) {
        HANDLER.setRelayStateParameterName(name);
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
        HANDLER.setCasServerUrlPrefix(casServerUrlPrefix);
    }

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        HANDLER.setSessionMappingStorage(storage);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.handlerInitialized.getAndSet(true)) {
            HANDLER.init();
        }
        String serverName = request.getServerName();
        String casUrl = this.idmFilterConfiguration.getCasUrl();
        if (Utils.getDingDingDomain().contains(serverName)) {
            String casServerName = Utils.getDingDingDomain();
            HANDLER.setCasServerUrlPrefix(casServerName + "/sso");
        } else if ("localhost".equals(serverName) || "127.0.0.1".equals(serverName) || this.idmFilterConfiguration.getServerName().contains(serverName) || "false".equals(this.idmFilterConfiguration.getMultiDomain())) {
            HANDLER.setCasServerUrlPrefix(casUrl);
        } else if (this.idmFilterConfiguration.getCasUrl().startsWith("https")) {
            HANDLER.setCasServerUrlPrefix("https://" + request.getServerName() + "/sso");
        } else {
            HANDLER.setCasServerUrlPrefix("http://" + request.getServerName() + "/sso");
        }
        if (HANDLER.process(request, response)) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    protected static SingleSignOutHandler getSingleSignOutHandler() {
        return HANDLER;
    }
}

