package com.ejianc.framework.idmclient.cas;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

import javax.net.ssl.HostnameVerifier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.proxy.AbstractEncryptedProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.proxy.Cas20ProxyRetriever;
import org.jasig.cas.client.proxy.CleanUpTimerTask;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.idmclient.IdmFilterConfiguration;
import com.ejianc.framework.idmclient.cas.logout.entity.TenantUser;
import com.ejianc.framework.idmclient.esapi.EncryptException;
import com.ejianc.framework.idmclient.sdk.RedisUtils;
import com.ejianc.framework.idmclient.utils.TokenGenerator;

public class TenantProxyReceivingTicketValidationFilter extends AbstractCasFilter {
	private static final String[] RESERVED_INIT_PARAMS = new String[]{"proxyGrantingTicketStorageClass",
			"proxyReceptorUrl", "acceptAnyProxy", "allowedProxyChains", "casServerUrlPrefix", "proxyCallbackUrl",
			"renew", "exceptionOnValidationFailure", "redirectAfterValidation", "useSession", "serverName", "service",
			"artifactParameterName", "serviceParameterName", "encodeServiceUrl", "millisBetweenCleanUps",
			"hostnameVerifier", "encoding", "config", "ticketValidatorClass"};
	private String proxyReceptorUrl;
	private Timer timer;
	private TimerTask timerTask;
	private int millisBetweenCleanUps;
	private static final String TENANT_ASSERTION = "tenant_assertion";
	private TicketValidator ticketValidator;
	private boolean redirectAfterValidation = true;
	private boolean exceptionOnValidationFailure = false;
	private boolean useSession = true;
	private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();
	private IdmFilterConfiguration idmFilterConfiguration ;
	
	public void init() {
		super.init();
		CommonUtils.assertNotNull(this.proxyGrantingTicketStorage, "proxyGrantingTicketStorage cannot be null.");
		CommonUtils.assertNotNull(this.ticketValidator, "ticketValidator cannot be null.");
		if (this.timer == null) {
			this.timer = new Timer(true);
		}

		if (this.timerTask == null) {
			this.timerTask = new CleanUpTimerTask(this.proxyGrantingTicketStorage);
		}

		this.timer.schedule(this.timerTask, (long) this.millisBetweenCleanUps, (long) this.millisBetweenCleanUps);
	}

	protected void initInternal(FilterConfig filterConfig) throws ServletException {
		ServletContext context = filterConfig.getServletContext();  
		ApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(context);
		idmFilterConfiguration = ctx.getBean("idmFilterConfiguration",IdmFilterConfiguration.class);
		
		this.setProxyReceptorUrl(this.getPropertyFromInitParams(filterConfig, "proxyReceptorUrl", (String) null));
		String proxyGrantingTicketStorageClass = this.getPropertyFromInitParams(filterConfig, "proxyGrantingTicketStorageClass", (String) null);
		if (proxyGrantingTicketStorageClass != null) {
			this.proxyGrantingTicketStorage = (ProxyGrantingTicketStorage) ReflectUtils.newInstance(proxyGrantingTicketStorageClass, new Object[0]);
			if (this.proxyGrantingTicketStorage instanceof AbstractEncryptedProxyGrantingTicketStorageImpl) {
				AbstractEncryptedProxyGrantingTicketStorageImpl servername = (AbstractEncryptedProxyGrantingTicketStorageImpl) this.proxyGrantingTicketStorage;
				String cipherAlgorithm = this.getPropertyFromInitParams(filterConfig, "cipherAlgorithm", "DESede");
				String secretKey = this.getPropertyFromInitParams(filterConfig, "secretKey", (String) null);
				servername.setCipherAlgorithm(cipherAlgorithm);

				try {
					if (secretKey != null) {
						servername.setSecretKey(secretKey);
					}
				} catch (Exception arg6) {
					throw new RuntimeException(arg6);
				}
			}
		}

		this.logger.trace("Setting proxyReceptorUrl parameter: {}", this.proxyReceptorUrl);
		this.millisBetweenCleanUps = Integer.parseInt(this.getPropertyFromInitParams(filterConfig, "millisBetweenCleanUps", Integer.toString('')));
		this.setExceptionOnValidationFailure(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "exceptionOnValidationFailure", "false")));
		this.logger.trace("Setting exceptionOnValidationFailure parameter: {}",Boolean.valueOf(this.exceptionOnValidationFailure));
		this.setRedirectAfterValidation(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "redirectAfterValidation", "true")));
		this.logger.trace("Setting redirectAfterValidation parameter: {}",Boolean.valueOf(this.redirectAfterValidation));
		this.setUseSession(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "useSession", "true")));
		this.logger.trace("Setting useSession parameter: {}", Boolean.valueOf(this.useSession));
		if (!this.useSession && this.redirectAfterValidation) {
			this.logger.warn("redirectAfterValidation parameter may not be true when useSession parameter is false. Resetting it to false in order to prevent infinite redirects.");
			this.setRedirectAfterValidation(false);
		}

		this.setTicketValidator(this.getTicketValidator(filterConfig));
		super.initInternal(filterConfig);
		String serverName = idmFilterConfiguration.getServerName();
		if (StringUtils.isNotBlank(serverName)) {
			this.setServerName(serverName);
		} else {
			this.setServerName(this.getPropertyFromInitParams(filterConfig, "serverName", (String) null));
		}

	}

	private <T> T createNewTicketValidator(String ticketValidatorClass, String casServerUrlPrefix, Class<T> clazz) {
		return CommonUtils.isBlank(ticketValidatorClass) ? ReflectUtils.newInstance(clazz, new Object[]{casServerUrlPrefix}) : ReflectUtils.newInstance(ticketValidatorClass, new Object[]{casServerUrlPrefix});
	}

	protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
		String allowAnyProxy = this.getPropertyFromInitParams(filterConfig, "acceptAnyProxy", (String) null);
		String allowedProxyChains = this.getPropertyFromInitParams(filterConfig, "allowedProxyChains", (String) null);
		String casServerUrlPrefix = this.getCasUrl(filterConfig);
		String ticketValidatorClass = this.getPropertyFromInitParams(filterConfig, "ticketValidatorClass",(String) null);
		Object validator;
		if (!CommonUtils.isNotBlank(allowAnyProxy) && !CommonUtils.isNotBlank(allowedProxyChains)) {
			validator = (Cas20ServiceTicketValidator) this.createNewTicketValidator(ticketValidatorClass, casServerUrlPrefix, Cas20ServiceTicketValidator.class);
		} else {
			Cas20ProxyTicketValidator factory = (Cas20ProxyTicketValidator) this.createNewTicketValidator(ticketValidatorClass, casServerUrlPrefix, Cas20ProxyTicketValidator.class);
			factory.setAcceptAnyProxy(this.parseBoolean(allowAnyProxy));
			factory.setAllowedProxyChains(CommonUtils.createProxyList(allowedProxyChains));
			validator = factory;
		}

		((Cas20ServiceTicketValidator) validator).setProxyCallbackUrl(this.getPropertyFromInitParams(filterConfig, "proxyCallbackUrl", (String) null));
		((Cas20ServiceTicketValidator) validator).setProxyGrantingTicketStorage(this.proxyGrantingTicketStorage);
		HttpsURLConnectionFactory factory1 = new HttpsURLConnectionFactory(this.getHostnameVerifier(filterConfig),this.getSSLConfig(filterConfig));
		((Cas20ServiceTicketValidator) validator).setURLConnectionFactory(factory1);
		((Cas20ServiceTicketValidator) validator).setProxyRetriever(new Cas20ProxyRetriever(casServerUrlPrefix, this.getPropertyFromInitParams(filterConfig, "encoding", (String) null), factory1));
		((Cas20ServiceTicketValidator) validator).setRenew(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
		((Cas20ServiceTicketValidator) validator).setEncoding(this.getPropertyFromInitParams(filterConfig, "encoding", (String) null));
		HashMap<String, String> additionalParameters = new HashMap<String, String>();
		List<String> params = Arrays.asList(RESERVED_INIT_PARAMS);
		Enumeration<String> e = filterConfig.getInitParameterNames();

		while (e.hasMoreElements()) {
			String s = (String) e.nextElement();
			if (!params.contains(s)) {
				additionalParameters.put(s, filterConfig.getInitParameter(s));
			}
		}

		((Cas20ServiceTicketValidator) validator).setCustomParameters(additionalParameters);
		return (TicketValidator) validator;
	}

	public void destroy() {
		super.destroy();
		this.timer.cancel();
	}

	protected final boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest) servletRequest;
		HttpServletResponse response = (HttpServletResponse) servletResponse;
		String requestUri = request.getRequestURI();
		if (!CommonUtils.isEmpty(this.proxyReceptorUrl) && requestUri.endsWith(this.proxyReceptorUrl)) {
			try {
				CommonUtils.readAndRespondToProxyReceptorRequest(request, response, this.proxyGrantingTicketStorage);
				return false;
			} catch (RuntimeException arg7) {
				this.logger.error(arg7.getMessage(), arg7);
				throw arg7;
			}
		} else {
			return true;
		}
	}

	public final void setProxyReceptorUrl(String proxyReceptorUrl) {
		this.proxyReceptorUrl = proxyReceptorUrl;
	}

	public void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage storage) {
		this.proxyGrantingTicketStorage = storage;
	}

	public void setTimer(Timer timer) {
		this.timer = timer;
	}

	public void setTimerTask(TimerTask timerTask) {
		this.timerTask = timerTask;
	}

	public void setMillisBetweenCleanUps(int millisBetweenCleanUps) {
		this.millisBetweenCleanUps = millisBetweenCleanUps;
	}

	protected Properties getSSLConfig(FilterConfig filterConfig) {
		Properties properties = new Properties();
		String fileName = this.getPropertyFromInitParams(filterConfig, "sslConfigFile", (String) null);
		if (fileName != null) {
			FileInputStream fis = null;

			try {
				fis = new FileInputStream(fileName);
				properties.load(fis);
				this.logger.trace("Loaded {} entries from {}", Integer.valueOf(properties.size()), fileName);
			} catch (IOException arg8) {
				this.logger.error(arg8.getMessage(), arg8);
			} finally {
				CommonUtils.closeQuietly(fis);
			}
		}

		return properties;
	}

	protected HostnameVerifier getHostnameVerifier(FilterConfig filterConfig) {
		String className = this.getPropertyFromInitParams(filterConfig, "hostnameVerifier", (String) null);
		this.logger.trace("Using hostnameVerifier parameter: {}", className);
		String config = this.getPropertyFromInitParams(filterConfig, "hostnameVerifierConfig", (String) null);
		this.logger.trace("Using hostnameVerifierConfig parameter: {}", config);
		return className != null ? (config != null ? (HostnameVerifier) ReflectUtils.newInstance(className, new Object[]{config}) : (HostnameVerifier) ReflectUtils.newInstance(className, new Object[0])) : null;
	}

	protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
	}

	protected void onFailedValidation(HttpServletRequest request, HttpServletResponse response) {
	}

	public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
		if (this.preFilter(servletRequest, servletResponse, filterChain)) {
			HttpServletRequest request = (HttpServletRequest) servletRequest;
			HttpServletResponse response = (HttpServletResponse) servletResponse;
			
			//入驻钉钉应用市场而修改
			String redirectUrl = idmFilterConfiguration.getCasServer();
			String serverName = request.getServerName();
			if(Utils.getDingDingDomain().contains(serverName)) {
				String casServerName = Utils.getDingDingDomain();
				setServerName(casServerName);
				
				redirectUrl = casServerName + "/portal/sso/login";
				((Cas20ServiceTicketValidator) ticketValidator).setCasServerUrlPrefix(casServerName+"/sso");
			}else{
				if("localhost".equals(serverName) || "127.0.0.1".equals(serverName) 
						|| idmFilterConfiguration.getServerName().contains(serverName)
						|| "false".equals(idmFilterConfiguration.getMultiDomain())) {
					String casServerName = idmFilterConfiguration.getServerName();
					if (StringUtils.isNotBlank(casServerName)) {
						this.setServerName(casServerName);
					}
					redirectUrl = idmFilterConfiguration.getCasServer();
					String casUrl = idmFilterConfiguration.getCasUrl();
					((Cas20ServiceTicketValidator) ticketValidator).setCasServerUrlPrefix(casUrl);
				}else{
					String casServerName = "http://"+request.getServerName();
					if(idmFilterConfiguration.getCasServer().startsWith("https")) {
						casServerName = "https://"+request.getServerName();
					}
					if (StringUtils.isNotBlank(casServerName)) {
						this.setServerName(casServerName);
					}
					redirectUrl = casServerName + "/portal/sso/login";
					String casUrl = casServerName + "/sso";
					((Cas20ServiceTicketValidator) ticketValidator).setCasServerUrlPrefix(casUrl);
				}
			}
			
			String ticket = this.retrieveTicketFromRequest(request);
			if (CommonUtils.isNotBlank(ticket)) {
				this.logger.debug("Attempting to validate ticket: {}", ticket);

				try {
					Assertion e = this.ticketValidator.validate(ticket, this.constructServiceUrl(request, response));
					this.logger.debug("Successfully authenticated user: {}", e.getPrincipal().getName());
					request.setAttribute("_const_cas_assertion_", e);
					if (this.useSession) {
						request.getSession().setAttribute("_const_cas_assertion_", e);
					}

					this.createToken(ticket, e, response);
					this.saveAssertion(ticket, e);
					this.onSuccessfulValidation(request, response, e);
					if (this.redirectAfterValidation) {
						this.logger.debug("Redirecting after successful ticket validation.");
						response.sendRedirect(redirectUrl);
						return;
					}
				} catch (TicketValidationException arg7) {
					this.logger.debug(arg7.getMessage(), arg7);
					this.onFailedValidation(request, response);
					if (this.exceptionOnValidationFailure) {
						throw new ServletException(arg7);
					}

					response.sendError(403, arg7.getMessage());
					return;
				}
			}

			filterChain.doFilter(request, response);
		}
	}

	public final void setTicketValidator(TicketValidator ticketValidator) {
		this.ticketValidator = ticketValidator;
	}

	public final void setRedirectAfterValidation(boolean redirectAfterValidation) {
		this.redirectAfterValidation = redirectAfterValidation;
	}

	public final void setExceptionOnValidationFailure(boolean exceptionOnValidationFailure) {
		this.exceptionOnValidationFailure = exceptionOnValidationFailure;
	}

	public final void setUseSession(boolean useSession) {
		this.useSession = useSession;
	}

	private void createToken(String ticket, Assertion assertion, HttpServletResponse response) {
		AttributePrincipal principal = assertion.getPrincipal();
		String userID = "";
		if (principal != null) {
			Map<String, Object> saveUserid = principal.getAttributes();
			Object existUser = saveUserid.get("userId");
			if (existUser != null) {
				userID = existUser.toString();
			}
		}

		if (!StringUtils.isBlank(userID)) {
			String saveUserid1 = ticket + "__" + userID;
			TenantUser existUser1 = RedisUtils.getUserCache("user.info.login.tenant:" + saveUserid1);
			if (existUser1 == null) {
				TenantUser ts = new TenantUser();
				ts.setUserId(saveUserid1);
				long ts1 = System.currentTimeMillis();
				ts.setLoginTs(ts1);
				String cookiesMap = "";

				try {
					cookiesMap = TokenGenerator.genToken(saveUserid1, ts1, RedisUtils.findSeed());
				} catch (EncryptException arg17) {
					this.logger.error("Fail to generate cookie!", arg17);
				}

				HashMap<String, String> iterator = new HashMap<String, String>();
				iterator.put("tenant_username", saveUserid1);
				iterator.put("tenant_token", cookiesMap);
				Iterator<String> key = iterator.keySet().iterator();

				try {
					while (key.hasNext()) {
						String cookie = (String) key.next();
						Cookie cookie1 = new Cookie(cookie, URLEncoder.encode((String) iterator.get(cookie), "utf-8"));
						if(StringUtils.isNotBlank(idmFilterConfiguration.getContextName())) {
							cookie1.setPath("/");
						}else{
							cookie1.setPath("/");
						}
						cookie1.setMaxAge(-1);
						cookie1.setHttpOnly(true);
						response.addCookie(cookie1);
					}
					
					RedisUtils.cacheUser(saveUserid1, ts);
				} catch (Exception arg16) {
					this.logger.error("登陆信息写入到redis缓存中失败", arg16);
				}
			} else {
				long ts2 = existUser1.getLoginTs();
				String cookieValue = "";

				try {
					cookieValue = TokenGenerator.genToken(saveUserid1, ts2, RedisUtils.findSeed());
				} catch (EncryptException arg15) {
					this.logger.error("Fail to generate cookie!", arg15);
				}

				HashMap<String, String> cookiesMap1 = new HashMap<String, String>();
				cookiesMap1.put("tenant_username", saveUserid1);
				cookiesMap1.put("tenant_token", cookieValue);
				Iterator<String> iterator1 = cookiesMap1.keySet().iterator();

				while (iterator1.hasNext()) {
					try {
						String key1 = (String) iterator1.next();
						Cookie cookie2 = new Cookie(key1, URLEncoder.encode((String) cookiesMap1.get(key1), "utf-8"));
						if(StringUtils.isNotBlank(idmFilterConfiguration.getContextName())) {
							cookie2.setPath("/");
						}else{
							cookie2.setPath("/");
						}
						cookie2.setMaxAge(-1);
						cookie2.setHttpOnly(true);
						response.addCookie(cookie2);
					}catch(Exception e) {
						e.printStackTrace();
					}
				}
			}
		}

	}

	private void saveAssertion(String ticket, Assertion assertion) {
		if (assertion != null) {
			AttributePrincipal principal = assertion.getPrincipal();
			String userID = "";
			if (principal != null) {
				Map<String, Object> saveUserid = principal.getAttributes();
				Object userId = saveUserid.get("userId");
				if (userId != null) {
					userID = userId.toString();
				}
			}

			if (userID != null && !userID.equalsIgnoreCase("")) {
				String saveUserid1 = ticket + "__" + userID;
				RedisUtils.putSessionCacheAttribute(TENANT_ASSERTION, saveUserid1, assertion);
			}
		}

	}

	private String getCasUrl(FilterConfig filterConfig) {
		String casUrl = idmFilterConfiguration.getCasUrl();
		if (StringUtils.isBlank(casUrl)) {
			casUrl = this.getPropertyFromInitParams(filterConfig, "casServerUrlPrefix", (String) null);
		}

		return casUrl;
	}
}