/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.idmclient.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static Logger logger = LoggerFactory.getLogger(CookieUtil.class);

    public static Cookie createCookie(String key, String value) {
        return CookieUtil.createCookie(key, value, true);
    }

    public static Cookie createCookie(String key, String value, boolean httpOnly) {
        Cookie cookie = null;
        try {
            cookie = new Cookie(key, URLEncoder.encode(value, "UTF-8"));
            cookie.setHttpOnly(httpOnly);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("encode error!", (Throwable)e);
        }
        return cookie;
    }

    public static String findCookieValue(Cookie[] cookies, String key) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(key)) continue;
                try {
                    return URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error("decode error!", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static Cookie expireCookieWithPath(String key, String path) {
        Cookie cookie = new Cookie(key, null);
        cookie.setMaxAge(0);
        cookie.setPath(path);
        return cookie;
    }
}

