/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.oms.bean.ComboAppEntity;
import com.ejianc.foundation.oms.mapper.ComboAppMapper;
import com.ejianc.foundation.oms.mapper.ComboRoleMapper;
import com.ejianc.foundation.oms.service.IComboAppService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.vo.ComboAppVO;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComboAppServiceImpl
extends BaseServiceImpl<ComboAppMapper, ComboAppEntity>
implements IComboAppService {
    @Autowired
    private ComboAppMapper mapper;
    @Autowired
    private ComboRoleMapper comboRoleMapper;
    @Value(value="${oms.tenantid}")
    private Long omsTenantId;
    @Autowired
    private IComboEnterpriseService comboEnterpriseService;
    @Autowired
    private IRoleAppRelationService roleAppRelationService;
    @Autowired
    private IAppService appService;

    @Override
    public IPage<AppVO> queryPage(Map<String, Object> params, boolean isEs) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        Long count = this.mapper.countByProPerties(params);
        Page page = new Page();
        if (count > 0L) {
            List<AppVO> appVO = this.mapper.queryPageByProperties(params);
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<ComboAppEntity> appVos) {
        ArrayList<RoleAppRelationEntity> roleAppRelation = new ArrayList<RoleAppRelationEntity>();
        for (ComboAppEntity appVo : appVos) {
            this.mapper.deleteAuthApp(appVo.getComboId(), appVo.getAppId());
            List<Long> tenantIds = this.comboEnterpriseService.queryTenantIdBycomboId(appVo.getComboId());
            if (tenantIds == null || tenantIds.size() <= 0 || appVo.getClassify() == 1) continue;
            for (Long tenantId : tenantIds) {
                Long exit;
                List<RoleVO> roleVOs = this.comboRoleMapper.queryRoleByAppAndComboId(appVo.getComboId(), tenantId, this.omsTenantId, appVo.getAppId());
                if (roleVOs != null && roleVOs.size() > 0) {
                    roleVOs.forEach(e -> {
                        RoleAppRelationEntity entity = new RoleAppRelationEntity();
                        entity.setAppId(appVo.getAppId());
                        entity.setDataType("app");
                        entity.setRoleId(e.getId());
                        roleAppRelation.add(entity);
                    });
                }
                if ((exit = this.mapper.exitAppNotComboId(appVo.getComboId(), appVo.getAppId(), tenantId)) != 0L) continue;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"dr", (Object)0);
                queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
                queryWrapper.eq((Object)"app_id", (Object)appVo.getAppId());
                List list = this.roleAppRelationService.list((Wrapper)queryWrapper);
                if (list == null || list.size() <= 0) continue;
                list.forEach(e -> e.setDataType("app"));
                roleAppRelation.addAll(list);
            }
            this.roleAppRelationService.delete(roleAppRelation);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> saveComboApp(ComboAppVO comboAppVO) {
        List<Long> tenantIds;
        if (comboAppVO.getComboId() == null) return CommonResponse.error((String)"\u5957\u9910id\u4e0d\u80fd\u4e3a\u7a7a");
        List<AppVO> appVo = comboAppVO.getAppVO();
        if (appVo == null || appVo.size() <= 0) return CommonResponse.error((String)"\u4fdd\u5b58\u5e94\u7528\u6570\u636e\u4e3a\u7a7a");
        ArrayList<ComboAppEntity> appList = new ArrayList<ComboAppEntity>();
        for (AppVO vo : appVo) {
            ComboAppEntity entity = new ComboAppEntity();
            entity.setAppId(vo.getId());
            entity.setComboId(comboAppVO.getComboId());
            appList.add(entity);
        }
        if (appList.size() > 0) {
            this.saveOrUpdateBatch(appList, appList.size(), false);
        }
        if ((tenantIds = this.comboEnterpriseService.queryTenantIdBycomboId(comboAppVO.getComboId())) == null || tenantIds.size() <= 0) return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        for (AppVO vo : appVo) {
            if (vo.getClassify() == 1) continue;
            for (Long tenantId : tenantIds) {
                List<RoleVO> roleVOs = this.comboRoleMapper.queryRoleByAppAndComboId(comboAppVO.getComboId(), tenantId, this.omsTenantId, vo.getId());
                if (roleVOs == null || roleVOs.size() <= 0) continue;
                roleVOs.forEach(e -> {
                    RoleAppVO roleAppVO = new RoleAppVO();
                    ArrayList<AppVO> app = new ArrayList<AppVO>();
                    app.add(vo);
                    roleAppVO.setAppVO(app);
                    roleAppVO.setRoleId(e.getId());
                    this.appService.saveRoleApp(roleAppVO);
                });
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public IPage<AppVO> comboAppRefList(Map<String, Object> params) {
        Long count;
        Page page = new Page();
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        if ((count = this.mapper.countComboAppRefList(params)) > 0L) {
            List<AppVO> appVO = this.mapper.comboAppRefList(params);
            appVO.forEach(e -> e.setChildren(null));
            page.setRecords(appVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }
}

