package com.ejianc.foundation.tenant.service.impl;

import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import com.ejianc.foundation.workbench.bean.MenuCategoryEntity;
import com.ejianc.foundation.workbench.service.IMenuCategoryService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.apache.http.conn.ConnectTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.initData.api.InitDataApi;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import com.ejianc.foundation.oms.bean.ComboEntity;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.service.IComboService;
import com.ejianc.foundation.oms.vo.ComboEnterpriseVO;
import com.ejianc.foundation.openapi.bean.OpenApiEntity;
import com.ejianc.foundation.openapi.bean.OpenApiGroupEntity;
import com.ejianc.foundation.openapi.bean.SecurityKeyDetailEntity;
import com.ejianc.foundation.openapi.bean.SecurityKeyEntity;
import com.ejianc.foundation.openapi.service.IOpenApiGroupService;
import com.ejianc.foundation.openapi.service.IOpenApiService;
import com.ejianc.foundation.openapi.service.ISecurityKeyDetailService;
import com.ejianc.foundation.openapi.service.ISecurityKeyService;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.bean.EnterpriseEntity;
import com.ejianc.foundation.tenant.bean.PasswordPolicyEntity;
import com.ejianc.foundation.tenant.bean.TenantAffiliatedEntity;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.mapper.EnterpriseMapper;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.tenant.service.IEnterpriseService;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.tenant.service.ITenantAffiliatedService;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.EnterpriseAndTenantVO;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.tenant.vo.PasswordPolicyVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.foundation.usercenter.bean.CooperateEnterpriseEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.ICooperateEnterpriseService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.PinYinUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Base64Util;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;

import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;

@Service
public class EnterpriseServiceImpl extends BaseServiceImpl<EnterpriseMapper, EnterpriseEntity> implements IEnterpriseService {

	private final Logger logger = LoggerFactory.getLogger(getClass());
	private static final String ROLE_BILL_CODE = "IDM_ROLE";
	@Autowired
	private ITenantService iTenantService;
	@Autowired
	private IPasswordPolicyService iPasswordPolicyService;
	@Autowired
	private IDefaultpwdService iDefaultpwdService;
	@Autowired
	private IOrgService iOrgService;
	@Autowired
	private IUserService iUserService;
	@Autowired
	private InitDataApi initDataApi;
	@Autowired
	private IEmployeeService iEmployeeService;
    @Autowired
    private IComboService comboService; 
    @Autowired
    private IComboEnterpriseService comboEnterpriseService; 
    @Autowired
    private IUserTenantRelationService userTenantRelationService; 
    @Autowired
    private IJobService jobService;
    @Autowired
    private ICooperateEnterpriseService cooperateEnterpriseService;
    @Autowired
    private ISecurityKeyService securityKeyService;
    @Autowired
    private ISecurityKeyDetailService securityKeyDetailService;
    @Autowired
    private IOpenApiGroupService openApiGroupService;
    @Autowired
    private IOpenApiService openApiService;
    @Autowired
    private ITenantAffiliatedService tenantAffiliatedService;
	@Autowired
	private IRoleUserRelationService roleUserRelationService;
	@Autowired
	private IEmployeeService employeeService;
	@Autowired
	private IMenuCategoryService menuCategoryService;
	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private EnterpriseMapper enterpriseMapper;

	@Override
	public EnterpriseVO selectById(Long enterpriseId) {
		EnterpriseEntity entity = this.getById(enterpriseId);
		if(entity != null) {
			EnterpriseVO enterpriseVo = BeanMapper.map(entity, EnterpriseVO.class);
			return enterpriseVo;
		}
		return null;
	}

	@Override
	public EnterpriseVO queryEnterpriseByTenantId(Long tenantId) {
		QueryWrapper<EnterpriseEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", tenantId);
		List<EnterpriseEntity> entities = baseMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.map(entities.get(0), EnterpriseVO.class);
		}
		return null;
	}
	
	/**
	 * 企业信息审批通过
	 *
	 * @param entity
	 */
	@Override
	@Transactional
	public void approvalPassed(EnterpriseEntity entity) {
		UserEntity userEntity = iUserService.getById(entity.getUserId());
		if(userEntity == null){
			throw new BusinessException("没有找到创建企业的用户信息！");
		}
		//1、创建租户
		Long tenantId = IdWorker.getId();
		Long passwordPolicyId = IdWorker.getId();
		Long orgId = IdWorker.getId();
		entity.setTenantId(tenantId);
		userEntity.setTenantId(tenantId);
		userEntity.setOrgId(orgId);
		TenantEntity tenantEntity = new TenantEntity();
		tenantEntity.setId(tenantId);
		tenantEntity.setTenantId(tenantId);
		tenantEntity.setName(entity.getName());
		tenantEntity.setCode("T"+tenantId);
		tenantEntity.setEnterpriseId(entity.getId());
		tenantEntity.setPasswordPolicyId(passwordPolicyId);
		tenantEntity.setState(1);
		tenantEntity.setMenuCategoryId(entity.getMenuCategoryId());
		
		//3、创建密码策略
		PasswordPolicyVO passwordPolicyVO = iPasswordPolicyService.findByTenantId(999999L);
		passwordPolicyVO.setId(passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setCode("PP"+passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setForceUpdateFlag(0);
		passwordPolicyVO.setValiditeDays(30);
		passwordPolicyVO.setPwdComplexity(1);
		passwordPolicyVO.setMinLength(6);
		PasswordPolicyEntity policyEntity = BeanMapper.map(passwordPolicyVO,PasswordPolicyEntity.class);
		//4、租户默认密码
		DefaultPwdEntity defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(999999L);
		defaultPwdEntity.setId(IdWorker.getId());
		defaultPwdEntity.setTenantId(tenantId);
		defaultPwdEntity.setDefaultpwd("a123456");
		defaultPwdEntity.setCreateTime(null);
		defaultPwdEntity.setUpdateTime(null);
		defaultPwdEntity.setUpdateUserCode(null);
		defaultPwdEntity.setCreateUserCode(null);
		defaultPwdEntity.setVersion(null);
		//5、创建组织
		OrgEntity orgEntity = new OrgEntity();
		orgEntity.setId(orgId);
		orgEntity.setCode("BASE"+orgId);
		orgEntity.setEnterpriseId(entity.getId());
		orgEntity.setInnerCode(orgEntity.getId().toString());
		orgEntity.setState(1);
		orgEntity.setTenantId(tenantId);
		orgEntity.setName(entity.getName());
		orgEntity.setOrgType(1);
		orgEntity.setShortName(entity.getName());
		orgEntity.setManager(entity.getLegalName());
		orgEntity.setPhone(entity.getTelephone());
		orgEntity.setSequence(1);
		EmployeeVO employeeVO = new EmployeeVO();
		if("2".equals(entity.getWays())){
			//个人、企业认证
			QueryWrapper<EmployeeEntity> wrapper = new QueryWrapper<>();
			wrapper.eq("user_id", userEntity.getId());
			List<EmployeeEntity> employeeEntity = iEmployeeService.list(wrapper);
			employeeVO = BeanMapper.map(employeeEntity.get(0), EmployeeVO.class);//后面只用到人员id（避免超级管理员时人员、用户id不一致）---所以直接查询就可以
			
		}else{//官网注册
			//6、创建人员
			employeeVO.setName(userEntity.getUserName());
			employeeVO.setCode("BASE-EMP"+userEntity.getId());
			employeeVO.setEmployeeType(1);
			employeeVO.setSex(1);
			employeeVO.setMobilePhone(userEntity.getUserMobile());
			employeeVO.setOrgName(orgEntity.getName());
			employeeVO.setOrgId(orgId);
			employeeVO.setTenantId(tenantId);
		}
		
		//2、生成租户与用户之间的关系
		UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
		QueryWrapper<UserTenantRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("user_id", entity.getUserId());
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("main_space_flag", 1);
		List<UserTenantRelationEntity> exit = userTenantRelationService.list(queryWrapper);
		if(exit!=null&&exit.size()>0){
			userTenantRelationEntity.setMainSpaceFlag(0);
		}else{
			userTenantRelationEntity.setMainSpaceFlag(1);
		}
		userTenantRelationEntity.setEmployeeId(employeeVO.getId()!=null?employeeVO.getId():entity.getUserId());
		userTenantRelationEntity.setUserId(entity.getUserId());
		userTenantRelationEntity.setTenantId(tenantId);
		userTenantRelationEntity.setTypeId(1);
		userTenantRelationEntity.setOrgId(orgId);
		userTenantRelationEntity.setState(1);
		//7、向支撑中心初始化数据
		try {
			EnterpriseInitVO vo = BeanMapper.map(entity,EnterpriseInitVO.class);
			initDataApi.initData(vo);
		}catch (Exception e){
			initDataApi.rollBack(tenantId);
			throw new BusinessException("初始化支撑中心数据出错："+e.getMessage());
		}
		//8、数据持久化
		try {
			iTenantService.saveOrUpdate(tenantEntity,false);
			iPasswordPolicyService.saveOrUpdate(policyEntity,false);
			iDefaultpwdService.saveOrUpdate(defaultPwdEntity,false);
			iOrgService.saveOrUpdate(orgEntity,false);

			if("2".equals(entity.getWays())){
				//个人、企业认证
				//生成job信息
		        JobEntity jobEntity = new JobEntity();
		        // 属性类型：主职
		        jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
		        jobEntity.setEmployeeId(employeeVO.getId());
		        // 新的工作记录
		        jobEntity.setCurState(JobVO.STATE_ACTIVE);
		        jobEntity.setJobStartTime(employeeVO.getWorkTime());
		        jobEntity.setOrgId(orgId);
		        jobEntity.setDr(BaseVO.DR_UNDELETE);
		        jobEntity.setTenantId(tenantId);
		        jobService.saveOrUpdate(jobEntity, false);
			}else{//官网注册
				//6、创建人员
				iEmployeeService.save(employeeVO,userEntity);
				iUserService.saveOrUpdate(userEntity);
			}
			super.saveOrUpdate(entity,false);
			logger.info("------插入用户租户关系表start------");
			logger.info("userTenantRelationEntity"+JSONObject.toJSONString(userTenantRelationEntity));
			userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
		}catch (Exception e){
			initDataApi.rollBack(tenantId);
			throw new BusinessException("持久化数据出错："+e.getMessage());
		}
	}

	@Override
	public List<EnterpriseEntity> queryEnterpriseByUserId(Long userId) {
		QueryWrapper<EnterpriseEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("user_id", userId);
		List<EnterpriseEntity> entities = baseMapper.selectList(queryWrapper);

		return entities;
	}

	@Override
	public EnterpriseAndTenantVO queryEnterpriseAndTenantByTenantId(Long tenantId) {
		EnterpriseAndTenantVO vo = new EnterpriseAndTenantVO(); 
		QueryWrapper<EnterpriseEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", tenantId);
		List<EnterpriseEntity> entities = baseMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			vo = BeanMapper.map(entities.get(0), EnterpriseAndTenantVO.class);
			TenantEntity tenantEntity = iTenantService.getById(tenantId);
			vo.setTenantName(tenantEntity.getName());
			vo.setTenantRegisterTime(tenantEntity.getCreateTime());
			UserEntity userEntity = iUserService.getById(vo.getUserId());
			vo.setTenantUserName(userEntity.getUserName());
			vo.setTenantUserMobile(userEntity.getUserMobile());
		}
		return vo;
	}

	@Override
	public CommonResponse<EnterpriseVO> supplierCollaboration(EnterpriseVO enterpriseVO) {

		if(enterpriseVO.getUserId()!= null ){
			/** 更新手机号和姓名*/
			JSONObject vo = new JSONObject();
			vo.put("userId",enterpriseVO.getUserId());
			vo.put("systemId",enterpriseVO.getId());
			vo.put("tenantId",enterpriseVO.getTenantId());
			vo.put("newPhone",enterpriseVO.getTelephone());
			vo.put("newName",enterpriseVO.getAuditName());
			CommonResponse<String> res = updateSupplierUserPhoneAndName(vo);
			if(res.isSuccess()){
				return CommonResponse.success(enterpriseVO);
			}
			return CommonResponse.error(res.getMsg());
		}
		enterpriseVO.setEnterpriseType("1");
		//根据手机号校验是否重复
		QueryWrapper<UserEntity> userPhoneWrapper = new QueryWrapper<>();
		userPhoneWrapper.eq("user_mobile", enterpriseVO.getTelephone()).eq("dr", 0);
		UserEntity userEntity = iUserService.getOne(userPhoneWrapper);
		//根据社会信用代码校验企业是否重复
		QueryWrapper<EnterpriseEntity> entityQueryWrapper = new QueryWrapper<>();
		entityQueryWrapper.eq("social_credit_code", enterpriseVO.getSocialCreditCode()).eq("dr", 0).eq("business_type",3);
		EnterpriseEntity entity = this.getOne(entityQueryWrapper,false);
		if(entity != null) {
			return CommonResponse.error("已有供应商【"+entity.getName()+"】协同了该社会信用代码，请确认是否重复录入了供应商！");
		}
		enterpriseVO.setWays("3");//供方协同
		enterpriseVO.setBusinessType("2");//供应商
//		enterpriseVO.setOemHost("https://bid.whhksj.com");
		//1、创建租户
		Long tenantId = IdWorker.getId();
		Long passwordPolicyId = IdWorker.getId();
		Long orgId = IdWorker.getId();

		enterpriseVO.setTenantId(tenantId);
		TenantEntity tenantEntity = new TenantEntity();
		tenantEntity.setId(tenantId);
		tenantEntity.setTenantId(tenantId);
		tenantEntity.setName(enterpriseVO.getName());
		tenantEntity.setCode("T"+tenantId);
		tenantEntity.setEnterpriseId(enterpriseVO.getId());
		tenantEntity.setPasswordPolicyId(passwordPolicyId);
		tenantEntity.setState(1);
		//2、创建密码策略
		PasswordPolicyVO passwordPolicyVO = iPasswordPolicyService.findByTenantId(999999L);
		passwordPolicyVO.setId(passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setCode("PP"+passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setForceUpdateFlag(0);
		passwordPolicyVO.setValiditeDays(30);
		passwordPolicyVO.setPwdComplexity(1);
		passwordPolicyVO.setMinLength(6);
		PasswordPolicyEntity policyEntity = BeanMapper.map(passwordPolicyVO,PasswordPolicyEntity.class);
		//3、租户默认密码
		DefaultPwdEntity defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(999999L);
		defaultPwdEntity.setId(IdWorker.getId());
		defaultPwdEntity.setTenantId(tenantId);
		if(StringUtils.isNotBlank(enterpriseVO.getPassword())){
			defaultPwdEntity.setDefaultpwd(enterpriseVO.getPassword());
		}
		defaultPwdEntity.setCreateTime(null);
		defaultPwdEntity.setUpdateTime(null);
		defaultPwdEntity.setUpdateUserCode(null);
		defaultPwdEntity.setCreateUserCode(null);
		defaultPwdEntity.setVersion(null);
		//4、创建组织
		OrgEntity orgEntity = new OrgEntity();
		orgEntity.setId(orgId);
		orgEntity.setCode("BASE"+orgId);
		orgEntity.setEnterpriseId(enterpriseVO.getId());
		orgEntity.setInnerCode(orgEntity.getId().toString());
		orgEntity.setState(1);
		orgEntity.setTenantId(tenantId);
		orgEntity.setName(enterpriseVO.getName());
		orgEntity.setOrgType(1);
		orgEntity.setShortName(enterpriseVO.getName());
		orgEntity.setManager(enterpriseVO.getLegalName());
		orgEntity.setPhone(enterpriseVO.getTelephone());
		orgEntity.setSequence(1);

		boolean isNewUser = false;
		//4、租户默认密码
		EmployeeVO employeeVO = null;
		Long userId = null;
		//2、生成租户与用户之间的关系
		UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
		if(userEntity == null){
			//新用户是主空间
			userTenantRelationEntity.setMainSpaceFlag(1);
			isNewUser = true;
			//创建用户
			userId = IdWorker.getId();
			UserVO userVO = new UserVO();
			//5、创建用户
			userVO .setTenantId(tenantId);
			userVO.setOrgId(orgId);
			userVO.setId(userId);
			userVO.setUserName(enterpriseVO.getAuditName());
			userVO.setUserMobile(enterpriseVO.getTelephone());
			userVO.setUserCode("SU"+ IdWorker.getId());
			userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
			userVO.setDr(BaseVO.DR_UNDELETE);
			userVO.setTypeId(1); //超级管理员
			PasswordUtils.setSalt(userVO);
			String password = enterpriseVO.getTelephone().substring(enterpriseVO.getTelephone().length() - 6);
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userVO.setPassword(shaPassword);
			userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
			userVO.setPwdStartTime(new Date());
			userEntity = BeanMapper.map(userVO, UserEntity.class);

			//6、创建人员
			employeeVO = new EmployeeVO();
			employeeVO.setId(userId);
			employeeVO.setUserId(userId);
			employeeVO.setName(userEntity.getUserName());
			employeeVO.setCode("BASE-SUP"+userEntity.getId());
			employeeVO.setEmployeeType(1);
			employeeVO.setState(0);
			employeeVO.setSex(1);
			employeeVO.setMobilePhone(userEntity.getUserMobile());
			employeeVO.setOrgName(orgEntity.getName());
			employeeVO.setOrgId(orgId);
			employeeVO.setTenantId(tenantId);
		}else{
			//老用户不是主空间
			userTenantRelationEntity.setMainSpaceFlag(0);
			userId = userEntity.getId();
		}
		enterpriseVO.setUserId(userId);
		userTenantRelationEntity.setUserId(userId);
		userTenantRelationEntity.setTenantId(tenantId);
		userTenantRelationEntity.setTypeId(1);
		userTenantRelationEntity.setEmployeeId(userId);
		userTenantRelationEntity.setOrgId(orgId);
		userTenantRelationEntity.setState(1);
		//7、生成默认套餐关系
        QueryWrapper<ComboEntity> roleWrapper = new QueryWrapper<>();
        roleWrapper.eq("dr", 0);
        roleWrapper.eq("code", "PRO-GFMH");
        ComboEntity comboEntity = comboService.getOne(roleWrapper);
		ComboEnterpriseVO comboEnterpriseVO = new ComboEnterpriseVO();
        if(comboEntity!=null){
        	comboEnterpriseVO.setBuyerId(tenantId);
        	comboEnterpriseVO.setComboId(comboEntity.getId());
        	comboEnterpriseVO.setUserId(userId);
        	comboEnterpriseVO.setEnabled("1");
        	comboEnterpriseVO.setComboName(comboEntity.getName());
        	comboEnterpriseVO.setOpeningTime(new Date());
        	comboEnterpriseVO.setStartTime(new Date());
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        	try {
				comboEnterpriseVO.setEndTime(sdf2.parse("2900-10-10"));
			} catch (ParseException e) {
				e.printStackTrace();
			}
        }

		//生成openapi并初始化数据
		//查询默认的供方api服务地址
		QueryWrapper<OpenApiGroupEntity> openApiGroupWaper = new QueryWrapper<>();
		openApiGroupWaper.eq("group_name", "协同交互接口");
		openApiGroupWaper.eq("dr", 0);
		List<OpenApiGroupEntity> openApiGroupList = openApiGroupService.list(openApiGroupWaper);
		SecurityKeyEntity securityKeyEntity = new SecurityKeyEntity();
		List<SecurityKeyDetailEntity> securityKeyDetailList = new ArrayList<>();
		Long securityKeyId = IdWorker.getId();
		String appid = IdWorker.getId()+"";
		String secret = Base64Util.encode(appid.getBytes());
		if(ListUtil.isNotEmpty(openApiGroupList)){
			securityKeyEntity.setAppId(appid);
			securityKeyEntity.setId(securityKeyId);
			securityKeyEntity.setSecretKey(secret);
			securityKeyEntity.setTenantId(tenantId);
			securityKeyEntity.setSecretDesc("供方生成租户：【"+enterpriseVO.getName()+"】接收数据服务接口");
			securityKeyEntity.setSecretState(1);//启用
			securityKeyEntity.setSecurityName(enterpriseVO.getName()+"接收数据服务接口");

			//获取具体的api服务
			QueryWrapper<OpenApiEntity> openApiWrapper = new QueryWrapper<>();
			openApiWrapper.eq("group_id", openApiGroupList.get(0).getId());
			openApiWrapper.eq("dr", 0);
			List<OpenApiEntity> openApiList = openApiService.list(openApiWrapper);
			if(ListUtil.isNotEmpty(openApiList)){
				for(OpenApiEntity apiEntity : openApiList){
					SecurityKeyDetailEntity detailEntity = new SecurityKeyDetailEntity();
					detailEntity.setOpenApiId(apiEntity.getId());
					detailEntity.setSecurityKeyId(securityKeyId);
					detailEntity.setTenantId(tenantId);
					securityKeyDetailList.add(detailEntity);
				}
				securityKeyService.saveOrUpdate(securityKeyEntity,false);
				securityKeyDetailService.saveOrUpdateBatch(securityKeyDetailList, securityKeyDetailList.size(),false);
				enterpriseVO.setDataAppId(appid);
				enterpriseVO.setDataAppSecret(secret);
				enterpriseVO.setDataHost(environmentTools.getBaseHost().substring(0,environmentTools.getBaseHost().length()-1));
				logger.info("内部推送供应商，初始化【协同交互接口】组具体的openapi服务成功！ "+enterpriseVO.getName());
			}else {
				logger.error("未初始化【协同交互接口】组具体的openapi服务,请联系管理员初始化数据 , enterpriseEntity = "+enterpriseVO.getId());
			}
		}else{
			logger.error("未初始化openapi的【协同交互接口】组,请联系管理员初始化数据 , enterpriseEntity = "+enterpriseVO.getId());
		}

		/** 将合作企业更新一下 */
		QueryParam queryParam = QueryParam.getInstance();
		queryParam.getParams().put("supplierId", Parameter.getEqInstance(enterpriseVO.getSupplierId()));
		List<CooperateEnterpriseEntity> cooperateEnterpriseList = cooperateEnterpriseService.queryList(queryParam);
		if(ListUtil.isNotEmpty(cooperateEnterpriseList)){
			for (CooperateEnterpriseEntity cooperateEntity : cooperateEnterpriseList) {
				cooperateEntity.setTenantId(tenantId);
			}
		}

		/** 挂载供应商菜单分类 */
		QueryWrapper<MenuCategoryEntity> categoryWapper = new QueryWrapper<>();
		categoryWapper.eq("code", "supplier").eq("dr", 0);
		List<MenuCategoryEntity> list = menuCategoryService.list(categoryWapper);
		if(ListUtil.isNotEmpty(list)){
			tenantEntity.setMenuCategoryId(list.get(0).getId());
		}

		//9、数据持久化
		try {
			iTenantService.saveOrUpdate(tenantEntity,false);
			iPasswordPolicyService.saveOrUpdate(policyEntity,false);
			iDefaultpwdService.saveOrUpdate(defaultPwdEntity,false);
			iOrgService.saveOrUpdate(orgEntity,false);
			//生成job信息
			JobEntity jobEntity = new JobEntity();
			// 属性类型：主职
			jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
			jobEntity.setEmployeeId(userId);
			// 新的工作记录
			jobEntity.setCurState(JobVO.STATE_ACTIVE);
			jobEntity.setJobStartTime(new Date());
			jobEntity.setOrgId(orgId);
			jobEntity.setDr(BaseVO.DR_UNDELETE);
			jobEntity.setTenantId(tenantId);
			jobService.saveOrUpdate(jobEntity, false);

			if(isNewUser){
				iUserService.saveOrUpdate(userEntity);
				iEmployeeService.saveOrUpdate(BeanMapper.map(employeeVO, EmployeeEntity.class));
			}
			logger.info("------插入用户租户关系表start------");
			userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
	        if(comboEntity!=null){
	        	comboEnterpriseService.saveComboEnterprise(comboEnterpriseVO);
	        }
			entity = BeanMapper.map(enterpriseVO, EnterpriseEntity.class);
			super.saveOrUpdate(entity,false);
			if(ListUtil.isNotEmpty(cooperateEnterpriseList)){
				logger.info("------更新供应商合作关系表，补充tenantId------");
				cooperateEnterpriseService.saveOrUpdateBatch(cooperateEnterpriseList);
			}
			return CommonResponse.success(enterpriseVO);
		}catch (Exception e){
			throw new BusinessException("持久化数据出错："+e.getMessage());
		}
	}

    /**
     * 生成租户信息
     * 根据纳税人识别码获取企业档案：
		1、没有企业档案：
			存在人员信息：返回错误
			没有人员信息：生成企业、租户、人员、自定义档案
		2、有企业档案：
			1）、没有生成租户；手机号存在，返回错误；手机号不存在，生成租户、超级超级管理员信息；
			2）、有租户：直接返回租户信息+超级管理员信息
     */
	@Override
	public CommonResponse<TenantVO> createGfmhTenant(EnterpriseVO vo) {
		//1、获取企业档案信息
		EnterpriseEntity enterpriseEntity = null;
		Long loadTenantId = vo.getLoadTenantId();
        if("1".equals(vo.getEnterpriseType())){
			//企业
        	if(StringUtils.isNotBlank(vo.getTaxCode())){
        		QueryParam param2 = new QueryParam();
                param2.getParams().put("taxCode",new Parameter(QueryParam.EQ,vo.getTaxCode()));
                param2.getParams().put("examineState",new Parameter(QueryParam.NE,2));
                List<EnterpriseEntity> listTaxCode = this.queryList(param2);
                if(listTaxCode!=null&&listTaxCode.size()>0){
                	enterpriseEntity = listTaxCode.get(0);
                }
        	}else{
        		throw new BusinessException("缺少参数：纳税人识别号");
        	}
        } else {
			//个人
        	if(StringUtils.isNotBlank(vo.getIdCard())){
	        	QueryParam param2 = new QueryParam();
	            param2.getParams().put("idcard",new Parameter(QueryParam.EQ,vo.getIdCard()));
	            param2.getParams().put("examineState",new Parameter(QueryParam.NE,2));
	            List<EnterpriseEntity> listIdcard = this.queryList(param2);
	            if(listIdcard!=null&&listIdcard.size()>0){
	            	enterpriseEntity = listIdcard.get(0);
	            }
        	}else{
        		throw new BusinessException("缺少参数：身份证号");
        	}
        }
        if(enterpriseEntity!=null){
        	enterpriseEntity.setLoadTenantId(loadTenantId);
        	logger.info("企业档案存在-- "+JSONObject.toJSONString(enterpriseEntity));
        	if(enterpriseEntity.getAuditTime()==null){
        		enterpriseEntity.setAuditTime(new Date());
			}
        	//有企业档案：
        	if(enterpriseEntity.getTenantId()!=null&&enterpriseEntity.getTenantId()!=-1L){

				QueryParam param = new QueryParam();
				param.getParams().put("tenantId",new Parameter(QueryParam.EQ,enterpriseEntity.getTenantId()));
				param.getParams().put("supplierId",new Parameter(QueryParam.EQ,vo.getSupplierId()));
				param.getParams().put("cooperate_enterid",new Parameter(QueryParam.EQ,vo.getSystemId()));
				List<CooperateEnterpriseEntity> entities = cooperateEnterpriseService.queryList(param,false);
				CooperateEnterpriseEntity cooperateEnterpriseEntity = new CooperateEnterpriseEntity();
				if(ListUtil.isEmpty(entities)){
					//不存在则维护 合作企业
					cooperateEnterpriseEntity.setCooperateEnterId(Long.parseLong(vo.getSystemId()));
					cooperateEnterpriseEntity.setCooperationEnterpriseName(selectById(vo.getSystemId()).getName());
					cooperateEnterpriseEntity.setMyEnterpriseId(enterpriseEntity.getId());
					cooperateEnterpriseEntity.setSupplierId(vo.getSupplierId().toString());
					cooperateEnterpriseEntity.setApplyState("3");
					cooperateEnterpriseEntity.setTenantId(enterpriseEntity.getTenantId());
					cooperateEnterpriseService.saveOrUpdate(cooperateEnterpriseEntity, false);
					logger.info("企业档案存在,有租户-- 合作企业维护完成");
				}else {
					cooperateEnterpriseEntity = entities.get(0);
				}
				if(StringUtils.isEmpty(enterpriseEntity.getDataAppId())){
					//生成openapi并初始化数据
					//查询默认的供方api服务地址
					QueryWrapper<OpenApiGroupEntity> openApiGroupWaper = new QueryWrapper<>();
					openApiGroupWaper.eq("group_name", "协同交互接口");
					openApiGroupWaper.eq("dr", 0);
					List<OpenApiGroupEntity> openApiGroupList = openApiGroupService.list(openApiGroupWaper);
					SecurityKeyEntity securityKeyEntity = new SecurityKeyEntity();
					List<SecurityKeyDetailEntity> securityKeyDetailList = new ArrayList<>();
					Long securityKeyId = IdWorker.getId();
					String appid = IdWorker.getId()+"";
					String secret = Base64Util.encode(appid.getBytes());
					enterpriseEntity.setDataAppId(appid);
					enterpriseEntity.setDataAppSecret(secret);
					if(openApiGroupList!=null&&openApiGroupList.size()>0){
						securityKeyEntity.setAppId(appid);
						securityKeyEntity.setId(securityKeyId);
						securityKeyEntity.setSecretKey(secret);
						securityKeyEntity.setSecurityName(enterpriseEntity.getName()+"接收数据服务接口");
						securityKeyEntity.setSecretDesc("供方平台生成租户初始化服务："+enterpriseEntity.getName()+"接收数据服务接口");
						securityKeyEntity.setSecretState(1);//启用

						//获取具体的api服务
						QueryWrapper<OpenApiEntity> openApiWrapper = new QueryWrapper<>();
						openApiWrapper.eq("group_id", openApiGroupList.get(0).getId());
						openApiWrapper.eq("dr", 0);
						List<OpenApiEntity> openApiList = openApiService.list(openApiWrapper);
						if(openApiList!=null&&openApiList.size()>0){
							for(OpenApiEntity apiEntity : openApiList){
								SecurityKeyDetailEntity entity = new SecurityKeyDetailEntity();
								entity.setOpenApiId(apiEntity.getId());
								entity.setSecurityKeyId(securityKeyId);
								securityKeyDetailList.add(entity);
							}
							securityKeyService.saveOrUpdate(securityKeyEntity,false);
							securityKeyDetailService.saveOrUpdateBatch(securityKeyDetailList, securityKeyDetailList.size(),false);
						}else {
							logger.error("未初始化具体的openapi服务,请联系管理员初始化数据 , enterpriseEntity = "+enterpriseEntity.getId());
						}
					}else{
						logger.error("未初始化openapi,请联系管理员初始化数据 , enterpriseEntity = "+enterpriseEntity.getId());
					}
				}
				logger.info("企业档案存在,有租户-- "+JSONObject.toJSONString(enterpriseEntity));
				TenantVO tenantVO = iTenantService.selectById(enterpriseEntity.getTenantId());
				UserVO userVO = iUserService.querySuperAdminByTenantId(enterpriseEntity.getTenantId());
				EmployeeEntity employeeEntity= iEmployeeService.selectById(userVO.getId());
				if(employeeEntity == null){
					employeeEntity = new EmployeeEntity();
					employeeEntity.setId(userVO.getId());
					employeeEntity.setUserId(userVO.getId());
					employeeEntity.setName(userVO.getUserName());
					employeeEntity.setCode("BASE-GFMH"+userVO.getId());
					employeeEntity.setEmployeeType(1);
					employeeEntity.setState(0);
					employeeEntity.setSex(1);
					employeeEntity.setMobilePhone(userVO.getUserMobile());
					employeeEntity.setOrgId(iOrgService.findOrgByTenantId(tenantVO.getId()).getId());
					employeeEntity.setTenantId(enterpriseEntity.getTenantId());
					logger.info("企业档案存在,有租户,无人员重新生成-- "+JSONObject.toJSONString(employeeEntity));
					QueryParam utrp = new QueryParam();
					utrp.getParams().put("employeeId",new Parameter(QueryParam.EQ,userVO.getId()));
					utrp.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantVO.getId()));
					utrp.getParams().put("orgId",new Parameter(QueryParam.EQ,employeeEntity.getOrgId()));
					List<JobEntity> listJ = jobService.queryList(utrp);
					if(ListUtil.isEmpty(listJ)){
						//生成job信息
						JobEntity jobEntity = new JobEntity();
						// 属性类型：主职
						jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
						jobEntity.setEmployeeId(userVO.getId());
						// 新的工作记录
						jobEntity.setCurState(JobVO.STATE_ACTIVE);
						jobEntity.setJobStartTime(new Date());
						jobEntity.setOrgId(employeeEntity.getOrgId());
						jobEntity.setDr(BaseVO.DR_UNDELETE);
						jobEntity.setTenantId(tenantVO.getId());
						jobEntity.setId(IdWorker.getId());
						jobService.saveOrUpdate(jobEntity, false);
						logger.info("企业档案存在,有租户,无人员，无任职记录，重新持久化job成功-- "+JSONObject.toJSONString(jobEntity));
					}
				}
				//更换最新的
				if(StringUtils.isNotEmpty(vo.getAuditName()) && PinYinUtil.getFullSpell(enterpriseEntity.getName()).equals(userVO.getUserName())){
					userVO.setUserName(vo.getAuditName());
					employeeEntity.setName(userVO.getUserName());
					userVO.setUserMobile(vo.getTelephone());
					employeeEntity.setMobilePhone(userVO.getUserMobile());
					logger.info("企业档案存在,有租户,判断手机号是否重复  -- "+JSONObject.toJSONString(userVO));
					userVO.setTenantId(enterpriseEntity.getTenantId());
					employeeEntity.setTenantId(enterpriseEntity.getTenantId());
					UserVO dbVO = iUserService.queryLoginUserByUserCodeOrPhoneNumOrEMail(vo.getTelephone());
					if(dbVO==null){
						/** 手机号不重复 */
						logger.info("企业档案存在,有租户,手机号不重复，更新管理员名称和手机号  -- "+JSONObject.toJSONString(userVO));
						UserEntity userEntity = BeanMapper.map(userVO,UserEntity.class);
						iUserService.saveOrUpdate(userEntity,false);
						userVO = BeanMapper.map(userEntity,UserVO.class);
						iEmployeeService.saveOrUpdate(employeeEntity,false);
					}else {
						/** 手机号重复 */
						logger.info("企业档案存在,有租户,手机号重复，删除以前默认生成的用户，重新挂载用户租户关系  -- "+JSONObject.toJSONString(userVO));
						QueryParam utrp = new QueryParam();
						utrp.getParams().put("userId",new Parameter(QueryParam.EQ,userVO.getId()));
						utrp.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantVO.getId()));
						List<UserTenantRelationEntity> list = userTenantRelationService.queryList(utrp);
						UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
						if(ListUtil.isNotEmpty(list)){
							userTenantRelationEntity = list.get(0);
						}else {
							userTenantRelationEntity.setMainSpaceFlag(1);
						}
						userTenantRelationEntity.setUserId(dbVO.getId());
						userTenantRelationEntity.setEmployeeId(dbVO.getEmployeeId());
						userTenantRelationEntity.setTenantId(tenantVO.getId());
						userTenantRelationEntity.setTypeId(1);
						userTenantRelationEntity.setState(1);

						userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
						logger.info("更新租户用户关系成功-- "+JSONObject.toJSONString(userTenantRelationEntity));
						//生成job信息
						JobEntity jobEntity = new JobEntity();
						utrp = new QueryParam();
						utrp.getParams().put("employeeId",new Parameter(QueryParam.EQ,userVO.getId()));
						utrp.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantVO.getId()));
						List<JobEntity> listJ = jobService.queryList(utrp);
						if(ListUtil.isNotEmpty(list)){
							jobEntity = listJ.get(0);
						}
						jobEntity.setEmployeeId(dbVO.getEmployeeId());
						jobService.saveOrUpdate(jobEntity, false);
						logger.info("更新用户任职关系成功-- "+JSONObject.toJSONString(userTenantRelationEntity));
						utrp = new QueryParam();
						utrp.getParams().put("employeeId",new Parameter(QueryParam.EQ,userVO.getId()));
						utrp.getParams().put("userId",new Parameter(QueryParam.EQ,userVO.getId()));
						utrp.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantVO.getId()));
						List<RoleUserRelationEntity> entityList = roleUserRelationService.queryList(utrp);
						if(ListUtil.isNotEmpty(entityList)){
							for (RoleUserRelationEntity entity : entityList) {
								entity.setEmployeeId(dbVO.getEmployeeId());
								entity.setUserId(dbVO.getId());
								List<RoleUserRelationVO> data = new ArrayList<>();
								data.add(BeanMapper.map(entity,RoleUserRelationVO.class));
								roleUserRelationService.saveRoleUser(data);
							}
							logger.info("更新用户角色关系成功-- "+JSONObject.toJSONString(userTenantRelationEntity));
						}
						userVO = dbVO;
						/** 暂时先不删除临时用户 人员*/
//						EmployeeVO  employeeVo = employeeService.detail(userVO.getEmployeeId());
//						employeeService.deleteEmployee(employeeVo);
					}
				}
				if(userVO.getTenantId() == null){
					userVO.setTenantId(enterpriseEntity.getTenantId());
				}
				if(employeeEntity.getTenantId() == null){
					employeeEntity.setTenantId(enterpriseEntity.getTenantId());
				}
				iUserService.saveOrUpdate(BeanMapper.map(userVO,UserEntity.class),false);
				iEmployeeService.saveOrUpdate(employeeEntity,false);
				logger.info("企业档案存在,有租户,有用户，重新挂载租户id  -- "+JSONObject.toJSONString(userVO));

				TenantAffiliatedEntity affiliatedEntity = null;
				if("3".equals(enterpriseEntity.getEnterpriseType())){
					if(loadTenantId!=null){
						param = new QueryParam();
						param.getParams().put("tenantId",new Parameter(QueryParam.EQ,enterpriseEntity.getTenantId()));
						param.getParams().put("target_tenant_id",new Parameter(QueryParam.EQ,loadTenantId));
						List<TenantAffiliatedEntity> affiliatedEntities = tenantAffiliatedService.queryList(param,false);
						if(ListUtil.isEmpty(affiliatedEntities)){
							TenantVO targetTenantVo = iTenantService.selectById(loadTenantId);
							affiliatedEntity = new TenantAffiliatedEntity();
							affiliatedEntity.setTenantId(enterpriseEntity.getTenantId());
							affiliatedEntity.setTargetTenantId(loadTenantId);
							affiliatedEntity.setTargetTenantName(targetTenantVo.getName());
							affiliatedEntity.setMyTenantName(enterpriseEntity.getName());
							affiliatedEntity.setMemo("同意-系统自动挂靠");
							affiliatedEntity.setTenantStatus(3L);
							affiliatedEntity.setApplyDate(new Date());
							affiliatedEntity.setSupplierId(entities.get(0).getSupplierId());
							tenantAffiliatedService.saveOrUpdate(affiliatedEntity,false);
							logger.info("分包负责人挂靠到分包供应商租户---{}",JSONObject.toJSONString(affiliatedEntity));
						}else {
							logger.error("分包班组租户未挂靠到供应商租户上，因为没有找到要挂靠的供应商租户所在的私有化企业的supplierId，分包供应商的合作表没找到！"+JSONObject.toJSONString(enterpriseEntity));
						}
					}else {
						logger.error("分包班组租户未挂靠到供应商租户上，因为参数没携带要挂靠的供应商租户id, enterpriseEntity = "+enterpriseEntity.getId()+"  tenantId = "+tenantVO.getId());
					}
				}
				DefaultPwdEntity defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(userVO.getTenantId());

				tenantVO.setManagerId(userVO.getId());
				tenantVO.setManagerName(userVO.getUserName());
				tenantVO.setManagerPhone(userVO.getUserMobile());
//				sendMsg(userVO,cooperateEnterpriseEntity,defaultPwdEntity,tenantVO);
    			return CommonResponse.success(tenantVO);
        	}else{
				enterpriseEntity.setAuditName(vo.getAuditName());
				enterpriseEntity.setTelephone(vo.getTelephone());
				logger.info("企业档案存在,没有生成租户-- "+JSONObject.toJSONString(enterpriseEntity));
//            	1）、没有生成租户；手机号存在用户，生成租户、将该用户作为超级超级管理员挂载用户下；
				if(StringUtils.isNotBlank(vo.getTelephone())){
					enterpriseEntity.setTelephone(vo.getTelephone());
				}
        		UserVO userVO = iUserService.queryLoginUserByUserCodeOrPhoneNumOrEMail(enterpriseEntity.getTelephone());
        		if(userVO==null){
        			enterpriseEntity.setAuditName(vo.getAuditName());
					userVO = new UserVO();
					logger.info("企业档案存在,没有生成租户，手机号不存在用户-- "+JSONObject.toJSONString(enterpriseEntity));
        		}else {
					logger.info("企业档案存在,没有生成租户，手机号存在用户-- "+JSONObject.toJSONString(enterpriseEntity)+" userVO = "+JSONObject.toJSONString(userVO));
				}
				return this.createGfmh(enterpriseEntity,vo.getSupplierId(),userVO,vo.getSystemId());
			}
        }else{
			logger.info("企业档案不存在,没有生成租户 -- "+JSONObject.toJSONString(enterpriseEntity));
        	//没有企业档案：
        	//1)、先生成企业档案
			vo.setId(IdWorker.getId());
			enterpriseEntity = BeanMapper.map(vo, EnterpriseEntity.class);
			enterpriseEntity.setExamineState("1");
			enterpriseEntity.setWays("4");//供方门户生成
			enterpriseEntity.setTenantId(-1L);
			enterpriseEntity.setAuditTime(new Date());
			saveOrUpdateNoES(enterpriseEntity);
			logger.info("企业档案不存在,没有生成租户-- 保存企业成功"+JSONObject.toJSONString(enterpriseEntity));
			//1)、存在人员信息：返回错误

        	//2)、没有人员信息：生成企业、租户、人员、自定义档案
        	//根据手机号校验是否重复
    		QueryWrapper<UserEntity> userPhoneWrapper = new QueryWrapper<>();
    		userPhoneWrapper.eq("user_mobile", vo.getTelephone()).eq("dr", 0);
    		UserEntity checkEntity = iUserService.getOne(userPhoneWrapper);
			UserVO userVO = new UserVO();
    		if(checkEntity != null) {
				userVO = BeanMapper.map(checkEntity,UserVO.class);
				logger.info("企业档案不存在,没有生成租户，手机号存在用户-- "+JSONObject.toJSONString(enterpriseEntity)+" userVo = "+JSONObject.toJSONString(userVO));
			}
	        return this.createGfmh(enterpriseEntity,vo.getSupplierId(),userVO,vo.getSystemId());
        }
	}

	/**
	 * 生成租户信息
	 * 更换手机号姓名
	 * @param vo
	 */
	@Override
	public CommonResponse<String> generateSupplierTenant(JSONObject vo) {
		UserVO userVO = iUserService.selectById(vo.getLong("userId"));
		if(userVO == null){
			logger.error("生成供方失败，vo= "+vo.toJSONString());
			return CommonResponse.error("供方用户不存在");
		}
		userVO.setUserName(vo.getString("userName"));
		userVO.setUserMobile(vo.getString("telephone"));
		iUserService.saveOrUpdate(BeanMapper.map(userVO, UserEntity.class),false);
		return CommonResponse.success("操作成功");
	}

	public CommonResponse<TenantVO> createGfmh(EnterpriseEntity enterpriseEntity, Long supplierId,UserVO userVO,String systemId){
		enterpriseEntity.setExamineState("1");
		enterpriseEntity.setWays("4");//供方门户生成
		enterpriseEntity.setBusinessType("2");//强制改成 2： 供应商
		//1、创建租户
		Long tenantId = IdWorker.getId();
		Long passwordPolicyId = IdWorker.getId();
		Long orgId = IdWorker.getId();
		Long userId = userVO.getId()==null?IdWorker.getId():userVO.getId();
		enterpriseEntity.setTenantId(tenantId);
		enterpriseEntity.setUserId(userId);
		TenantEntity tenantEntity = new TenantEntity();
		tenantEntity.setId(tenantId);
		tenantEntity.setTenantId(tenantId);
		tenantEntity.setName(enterpriseEntity.getName());
		tenantEntity.setCode("T"+tenantId);
		tenantEntity.setEnterpriseId(enterpriseEntity.getId());
		tenantEntity.setPasswordPolicyId(passwordPolicyId);
		tenantEntity.setState(1);
		QueryWrapper<MenuCategoryEntity> categoryWapper = new QueryWrapper<>();
		categoryWapper.eq("default_flag", "1").eq("dr", 0);
		List<MenuCategoryEntity> list = menuCategoryService.list(categoryWapper);
		if(list!=null && list.size()>0){
			tenantEntity.setMenuCategoryId(list.get(0).getId());
		}
		//2、生成租户与用户之间的关系
		UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
		if(userVO.getId()==null){
			//新用户标注主空间
			userTenantRelationEntity.setMainSpaceFlag(1);
		}else {
			//老用户标注非主空间，可切换
			userTenantRelationEntity.setMainSpaceFlag(0);
		}
		userTenantRelationEntity.setUserId(userId);
		userTenantRelationEntity.setTenantId(tenantId);
		userTenantRelationEntity.setTypeId(1);
		userTenantRelationEntity.setEmployeeId(userId);
		userTenantRelationEntity.setOrgId(orgId);
		userTenantRelationEntity.setState(1);
		//2、创建密码策略
		PasswordPolicyVO passwordPolicyVO = iPasswordPolicyService.findByTenantId(999999L);
		passwordPolicyVO.setId(passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setCode("PP"+passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setForceUpdateFlag(0);
		passwordPolicyVO.setValiditeDays(30);
		passwordPolicyVO.setPwdComplexity(1);
		passwordPolicyVO.setMinLength(6);
		PasswordPolicyEntity policyEntity = BeanMapper.map(passwordPolicyVO,PasswordPolicyEntity.class);
		//3、租户默认密码
		DefaultPwdEntity defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(999999L);
		defaultPwdEntity.setId(IdWorker.getId());
		defaultPwdEntity.setTenantId(tenantId);
		defaultPwdEntity.setCreateTime(null);
		defaultPwdEntity.setUpdateTime(null);
		defaultPwdEntity.setUpdateUserCode(null);
		defaultPwdEntity.setCreateUserCode(null);
		defaultPwdEntity.setVersion(null);
		//4、创建组织
		OrgEntity orgEntity = new OrgEntity();
		orgEntity.setId(orgId);
		orgEntity.setCode("BASE"+orgId);
		orgEntity.setEnterpriseId(enterpriseEntity.getId());
		orgEntity.setInnerCode(orgEntity.getId().toString());
		orgEntity.setState(1);
		orgEntity.setTenantId(tenantId);
		orgEntity.setName(enterpriseEntity.getName());
		orgEntity.setOrgType(1);
		orgEntity.setShortName(enterpriseEntity.getName());
		orgEntity.setManager(enterpriseEntity.getLegalName());
		orgEntity.setPhone(enterpriseEntity.getTelephone());
		orgEntity.setSequence(1);
		//5、创建用户
		EmployeeVO employeeVO = null;
		UserEntity userEntity = null;
		if(userVO.getId() == null){
			//不存在用户
			userVO.setId(userId);
			userVO .setTenantId(tenantId);
			userVO.setOrgId(orgId);
			userVO.setUserName(enterpriseEntity.getAuditName()!=null?enterpriseEntity.getAuditName(): PinYinUtil.getFullSpell(enterpriseEntity.getName()));
			userVO.setUserMobile(enterpriseEntity.getTelephone()!=null?enterpriseEntity.getTelephone():"M"+IdWorker.getId());
			userVO.setUserCode("U"+ IdWorker.getId());
			userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
			userVO.setDr(BaseVO.DR_UNDELETE);
			userVO.setTypeId(1); //超级管理员
			PasswordUtils.setSalt(userVO);
			String password = userVO.getUserMobile().substring(userVO.getUserMobile().length() - 6);
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userVO.setPassword(shaPassword);
			userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
			userVO.setPwdStartTime(new Date());
			userEntity = BeanMapper.map(userVO, UserEntity.class);

			//6、创建人员
			employeeVO = new EmployeeVO();
			employeeVO.setId(userId);
			employeeVO.setUserId(userId);
			employeeVO.setName(userEntity.getUserName());
			employeeVO.setCode("BASE-GFMH"+userEntity.getId());
			employeeVO.setEmployeeType(1);
			employeeVO.setState(0);
			employeeVO.setSex(1);
			employeeVO.setMobilePhone(userEntity.getUserMobile());
			employeeVO.setOrgName(orgEntity.getName());
			employeeVO.setOrgId(orgId);
			employeeVO.setTenantId(tenantId);
		}else {
			EmployeeEntity employeeEntity = employeeService.selectById(userId);
			userVO.setUserName(enterpriseEntity.getAuditName()!=null?enterpriseEntity.getAuditName(): PinYinUtil.getFullSpell(enterpriseEntity.getName()));
			/** 修改默认密码 */
			PasswordUtils.setSalt(userVO);
			String password = userVO.getUserMobile().substring(userVO.getUserMobile().length() - 6);
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userVO.setPassword(shaPassword);
			userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
			userVO.setPwdStartTime(new Date());
			if(userVO.getTenantId() == null){
				userVO.setTenantId(tenantId);
			}
			if(userVO.getOrgId() == null){
				userVO.setOrgId(orgId);
			}
			userEntity = BeanMapper.map(userVO, UserEntity.class);
			if(employeeEntity == null){
				//用户对应人员为空，则自动生成
				employeeVO = new EmployeeVO();
				employeeVO.setId(userId);
				employeeVO.setUserId(userId);
				employeeVO.setName(userEntity.getUserName());
				employeeVO.setCode("BASE-GFMH"+userEntity.getId());
				employeeVO.setEmployeeType(1);
				employeeVO.setState(0);
				employeeVO.setSex(1);
				employeeVO.setMobilePhone(userEntity.getUserMobile());
				employeeVO.setOrgName(orgEntity.getName());
				employeeVO.setOrgId(orgId);
				employeeVO.setTenantId(tenantId);
			}else {
				employeeVO = BeanMapper.map(employeeEntity,EmployeeVO.class);
			}
		}

		//生成job信息
		JobEntity jobEntity = new JobEntity();
		// 属性类型：主职
		jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
		jobEntity.setEmployeeId(userId);
		// 新的工作记录
		jobEntity.setCurState(JobVO.STATE_ACTIVE);
		jobEntity.setJobStartTime(new Date());
		jobEntity.setOrgId(orgId);
		jobEntity.setDr(BaseVO.DR_UNDELETE);
		jobEntity.setTenantId(tenantId);
		jobEntity.setId(IdWorker.getId());



		//7、生成默认套餐关系
        QueryWrapper<ComboEntity> roleWrapper = new QueryWrapper<>();
        roleWrapper.eq("dr", 0);
        roleWrapper.eq("code", "PRO-GFMH");
        ComboEntity comboEntity = comboService.getOne(roleWrapper);
		ComboEnterpriseVO comboEnterpriseVO = new ComboEnterpriseVO();
        if(comboEntity!=null){
        	comboEnterpriseVO.setTenantId(999999l);//套餐生成在999999租户下
        	comboEnterpriseVO.setBuyerId(tenantId);
        	comboEnterpriseVO.setComboId(comboEntity.getId());
        	comboEnterpriseVO.setUserId(userId);
        	comboEnterpriseVO.setEnabled("1");
        	comboEnterpriseVO.setComboName(comboEntity.getName());
        	comboEnterpriseVO.setOpeningTime(new Date());
        	comboEnterpriseVO.setStartTime(new Date());
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        	try {
				comboEnterpriseVO.setEndTime(sdf2.parse("2900-10-10"));
			} catch (ParseException e) {
				e.printStackTrace();
			}
        }else {
        	logger.info("没有配置供应商默认套餐！");
		}

		//8、向支撑中心初始化数据
		EnterpriseInitVO initvo = BeanMapper.map(enterpriseEntity,EnterpriseInitVO.class);
		try {
			initDataApi.initDataByParams(initvo);
		}catch (Exception e){
			initDataApi.rollBackByParams(initvo);
			logger.error("初始化支撑中心数据出错："+e.getMessage()+", enterpriseEntity = "+enterpriseEntity.getId());
		}
		//9、合作企业
		CooperateEnterpriseEntity cooperateEnterpriseEntity = new CooperateEnterpriseEntity();
		cooperateEnterpriseEntity.setCode("CO-"+IdWorker.getId());
		cooperateEnterpriseEntity.setCooperateEnterId(Long.parseLong(systemId));
		cooperateEnterpriseEntity.setCooperationEnterpriseName(selectById(systemId).getName());
		cooperateEnterpriseEntity.setMyEnterpriseId(enterpriseEntity.getId());
		cooperateEnterpriseEntity.setSupplierId(supplierId.toString());
		cooperateEnterpriseEntity.setApplyState("3");
		cooperateEnterpriseEntity.setTenantId(tenantId);
		cooperateEnterpriseEntity.setApplyTime(new Date());
		cooperateEnterpriseEntity.setApplyReason("施工方推送生成");
		cooperateEnterpriseEntity.setApplyPerson("系统生成");
		//10、生成openapi并初始化数据
		//查询默认的供方api服务地址
		QueryWrapper<OpenApiGroupEntity> openApiGroupWaper = new QueryWrapper<>();
		openApiGroupWaper.eq("group_name", "协同交互接口");
		openApiGroupWaper.eq("dr", 0);
		List<OpenApiGroupEntity> openApiGroupList = openApiGroupService.list(openApiGroupWaper);
		SecurityKeyEntity securityKeyEntity = new SecurityKeyEntity();
		List<SecurityKeyDetailEntity> securityKeyDetailList = new ArrayList<>();
		Long securityKeyId = IdWorker.getId();
		String appid = IdWorker.getId()+"";
		String secret = Base64Util.encode(appid.getBytes());
		enterpriseEntity.setDataAppId(appid);
		enterpriseEntity.setDataAppSecret(secret);
		securityKeyEntity.setAppId(appid);
		securityKeyEntity.setSecretState(1);//启用
		securityKeyEntity.setId(securityKeyId);
		securityKeyEntity.setSecretKey(secret);
		securityKeyEntity.setTenantId(tenantId);
		securityKeyEntity.setSecurityName(enterpriseEntity.getName()+"接收数据服务接口");
		securityKeyEntity.setSecretDesc("供方平台生成租户初始化服务："+enterpriseEntity.getName()+"接收数据服务接口");
		if(openApiGroupList!=null&&openApiGroupList.size()>0){

			//获取具体的api服务
			QueryWrapper<OpenApiEntity> openApiWrapper = new QueryWrapper<>();
			openApiWrapper.eq("group_id", openApiGroupList.get(0).getId());
			openApiWrapper.eq("dr", 0);
			List<OpenApiEntity> openApiList = openApiService.list(openApiWrapper);
			if(openApiList!=null&&openApiList.size()>0){
				for(OpenApiEntity apiEntity : openApiList){
					SecurityKeyDetailEntity entity = new SecurityKeyDetailEntity();
					entity.setOpenApiId(apiEntity.getId());
					entity.setSecurityKeyId(securityKeyId);
					securityKeyDetailList.add(entity);
				}
			}else {
				logger.error("未初始化具体的openapi服务,请联系管理员初始化数据 , enterpriseEntity = "+enterpriseEntity.getId()+"  tenantId = "+tenantId);
			}
		}else{
			logger.error("未初始化openapi,请联系管理员初始化数据 , enterpriseEntity = "+enterpriseEntity.getId()+"  tenantId = "+tenantId);
		}

		//11、如果是分包班组，则挂载该租户到供应商租户上
		TenantAffiliatedEntity affiliatedEntity = null;
		if("3".equals(enterpriseEntity.getEnterpriseType())){
			if(enterpriseEntity.getLoadTenantId()!=null){
				QueryParam  param = new QueryParam();
				param.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantId));
				param.getParams().put("target_tenant_id",new Parameter(QueryParam.EQ,enterpriseEntity.getLoadTenantId()));
				List<TenantAffiliatedEntity> entities = tenantAffiliatedService.queryList(param,false);
				if(ListUtil.isEmpty(entities)){
					TenantVO targetTenantVo = iTenantService.selectById(enterpriseEntity.getLoadTenantId());
					affiliatedEntity = new TenantAffiliatedEntity();
					affiliatedEntity.setTenantId(tenantId);
					affiliatedEntity.setTargetTenantId(enterpriseEntity.getLoadTenantId());
					affiliatedEntity.setTargetTenantName(targetTenantVo.getName());
					affiliatedEntity.setMyTenantName(tenantEntity.getName());
					affiliatedEntity.setMemo("同意-系统自动挂靠");
					affiliatedEntity.setTenantStatus(3L);
					affiliatedEntity.setApplyDate(new Date());
					affiliatedEntity.setSupplierId(entities.get(0).getSupplierId());
					logger.info("分包负责人挂靠到分包供应商租户---{}",JSONObject.toJSONString(affiliatedEntity));
				}else {
					logger.error("分包班组租户未挂靠到供应商租户上，因为没有找到要挂靠的供应商租户所在的私有化企业的supplierId，分包供应商的合作表没找到！"+JSONObject.toJSONString(enterpriseEntity));
				}
			}else {
				logger.error("分包班组租户未挂靠到供应商租户上，因为参数没携带要挂靠的供应商租户id, enterpriseEntity = "+enterpriseEntity.getId()+"  tenantId = "+tenantId);
			}
		}
		
		//12、数据持久化
		try {
			logger.info("开始持久化数据-- ");
			iTenantService.saveOrUpdate(tenantEntity,false);
			logger.info("持久化租户成功-- "+JSONObject.toJSONString(tenantEntity));
			iPasswordPolicyService.saveOrUpdate(policyEntity,false);
			logger.info("持久化密码策略成功-- ");
			iDefaultpwdService.saveOrUpdate(defaultPwdEntity,false);
			logger.info("持久化默认密码成功-- ");
			iOrgService.saveOrUpdate(orgEntity,false);
			logger.info("持久化根组织成功-- "+JSONObject.toJSONString(orgEntity));
			iEmployeeService.saveOrUpdate(BeanMapper.map(employeeVO, EmployeeEntity.class));
			iUserService.saveOrUpdate(userEntity);
			logger.info("持久化用户人员成功-- "+JSONObject.toJSONString(userEntity));
			QueryParam utrp = new QueryParam();
			utrp.getParams().put("employeeId",new Parameter(QueryParam.EQ,userId));
			utrp.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantId));
			utrp.getParams().put("orgId",new Parameter(QueryParam.EQ,orgId));
			List<JobEntity> listJ = jobService.queryList(utrp);
			if(ListUtil.isEmpty(listJ)){
				jobService.saveOrUpdate(jobEntity, false);
				logger.info("持久化job成功-- "+JSONObject.toJSONString(jobEntity));
			}
			cooperateEnterpriseService.saveOrUpdate(cooperateEnterpriseEntity, false);
			logger.info("持久化合作企业成功-- "+JSONObject.toJSONString(cooperateEnterpriseEntity));
	        if(comboEntity!=null){
	        	if(employeeVO == null){
	        		EmployeeEntity employeeEntity = iEmployeeService.selectById(userId);
	        		if(employeeEntity == null){
						logger.error("啊欧，还是没找到employeeVO, enterpriseEntity = "+enterpriseEntity.getId());
					}
	        		employeeVO = BeanMapper.map(employeeEntity,EmployeeVO.class);
				}
				employeeVO.setJobType(jobEntity.getProperty());
				employeeVO.setJobId(jobEntity.getId());
				comboEnterpriseService.loadComboEnterprise(comboEnterpriseVO,orgId,employeeVO);
				logger.info("持久化套餐成功-- "+JSONObject.toJSONString(comboEnterpriseVO));
	        }
			securityKeyService.saveOrUpdate(securityKeyEntity,false);
	        if(securityKeyDetailList!=null&&securityKeyDetailList.size()>0){
	        	securityKeyDetailService.saveOrUpdateBatch(securityKeyDetailList, securityKeyDetailList.size(),false);
	        }
			logger.info("持久化租户openAPI成功-- "+JSONObject.toJSONString(securityKeyEntity));
			super.saveOrUpdate(enterpriseEntity,false);
			logger.info("持久化企业信息成功-- "+JSONObject.toJSONString(enterpriseEntity));
			userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
			logger.info("持久化租户用户关系成功-- "+JSONObject.toJSONString(userTenantRelationEntity));
			if(affiliatedEntity!=null){
				tenantAffiliatedService.saveOrUpdate(affiliatedEntity,false);
				logger.info("持久化租户挂载成功-- "+JSONObject.toJSONString(affiliatedEntity));
			}
			logger.info("持久化数据结束-- ");

			TenantVO tenantVO = BeanMapper.map(tenantEntity, TenantVO.class);
			tenantVO.setManagerId(userVO.getId());
			tenantVO.setManagerName(userVO.getUserName());
			tenantVO.setManagerPhone(userVO.getUserMobile());
//			sendMsg(userVO,cooperateEnterpriseEntity,defaultPwdEntity,tenantVO);
			return CommonResponse.success(tenantVO);
		}catch (Exception e){
			logger.error("持久化数据出错："+e.getMessage()+", enterpriseEntity = "+enterpriseEntity.getId());
			e.printStackTrace();
		}
		TenantVO tenantVO = BeanMapper.map(tenantEntity, TenantVO.class);
		tenantVO.setManagerId(userVO.getId());
		tenantVO.setManagerName(userVO.getUserName());
		tenantVO.setManagerPhone(userVO.getUserMobile());

		return CommonResponse.success(tenantVO);
	}
	private void sendMsg(UserVO userVO,CooperateEnterpriseEntity cooperateEnterpriseEntity,DefaultPwdEntity defaultPwdEntity,TenantVO tenantVO){
		if(StringUtils.isNotBlank(userVO.getUserMobile()) && userVO.getUserMobile().length() == 11){
			JSONObject messageParam = new JSONObject();
			messageParam.put("phone", userVO.getUserMobile());
			messageParam.put("templateCode", "SMS_250340068");
			messageParam.put("signName", "分供一体化服务平台");
			JSONObject params = new JSONObject();
			params.put("enterpriseName","["+cooperateEnterpriseEntity.getCooperationEnterpriseName()+"]");
			params.put("userCode",userVO.getUserMobile());
			params.put("userPassword",defaultPwdEntity.getDefaultpwd());
			messageParam.put("params",params);

			String messageUrl = environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
			try {
				String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
				CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
				if(response.isSuccess()) {
					logger.info("协同成功的短信通知发送成功！----"+JSONObject.toJSONString(tenantVO));
				}else {
					logger.info("协同成功的短信通知 发送失败！----"+JSONObject.toJSONString(tenantVO)+"   "+JSONObject.toJSONString(response));
				}
			} catch (ConnectTimeoutException | SocketTimeoutException e) {
				e.printStackTrace();
				logger.error("协同成功的短信通知 发送失败！----"+JSONObject.toJSONString(tenantVO),e);
			} catch (Exception e) {
				e.printStackTrace();
				logger.error("协同成功的短信通知 发送失败！----"+JSONObject.toJSONString(tenantVO),e);
			}
		}else {
			logger.info("协同成功的短信通知 未发送！----"+JSONObject.toJSONString(tenantVO));
		}
	}

	@Override
	public CommonResponse<String> updateSupplierUserPhoneAndName(JSONObject vo) {
		logger.info("更新供方手机号相关参数："+vo.toJSONString());
		Long userId = vo.getLong("userId");
		Long systemId = vo.getLong("systemId");
		Long tenantId = vo.getLong("tenantId");
		String newPhone = vo.getString("newPhone");
		String newName = vo.getString("newName");
		if(StringUtils.isBlank(newPhone) || newPhone.length()!=11){
			return CommonResponse.error("手机号格式不正确！");
		}
		UserEntity userEntity = iUserService.getById(userId);
		if(userEntity == null){
			return CommonResponse.error("用户不存在！");
		}
		EmployeeEntity employeeEntity = iEmployeeService.getById(userId);
		if(employeeEntity == null){
			return CommonResponse.error("人员不存在！");
		}
		EnterpriseEntity enterpriseEntity = getById(systemId);
		if(enterpriseEntity == null){
			return CommonResponse.error("供应商企业不存在！");
		}
		TenantVO tenantVO = iTenantService.selectById(tenantId);
		if(tenantVO == null){
			return CommonResponse.error("供应商租户不存在！");
		}
		QueryParam param = new QueryParam();
		param.getParams().put("userId",new Parameter(QueryParam.EQ,userId));
		param.getParams().put("tenantId",new Parameter(QueryParam.EQ,tenantId));
		List<UserTenantRelationEntity> userTenantList = userTenantRelationService.queryList(param);
		if(ListUtil.isEmpty(userTenantList)){
			return CommonResponse.error("该用户数据在租户下不存在！");
		}
		if(!Objects.equals(tenantVO.getEnterpriseId(),enterpriseEntity.getId())){
			return CommonResponse.error("企业与租户数据不匹配！");
		}
		param = new QueryParam();
		param.getParams().put("user_mobile",new Parameter(QueryParam.EQ,newPhone));
		List<UserEntity> exist = iUserService.queryList(param);
		if(ListUtil.isNotEmpty(exist)){
			if(exist.size()>1 || !exist.get(0).getId().equals(userId)){
				return CommonResponse.error("新手机号在系统内已被他人使用，不能更新！");
			}
		}
		String op = userEntity.getUserMobile();
		String name = userEntity.getUserName();
		userEntity.setUserMobile(newPhone);
		employeeEntity.setMobilePhone(newPhone);
		if(StringUtils.isNotBlank(newName)){
			userEntity.setUserName(newName);
			employeeEntity.setName(newName);
		}
		iUserService.saveOrUpdate(userEntity,false);
		employeeService.saveOrUpdate(employeeEntity,false);
		logger.info("更新供方手机号相关参数："+vo.toJSONString()+" 已将供方用户id:"+userEntity.getId()+"  用户名："+name+",手机号："+op+" 更新为 "+newName+"  "+newPhone);
		return CommonResponse.success("供应商账号信息更新成功！");
	}

	/**
	 * 初始化租户、用户、组织等信息-----钉钉或企业微信初始化信息调用
	 * @param enterpriseVO
	 */
	@Override
	@Transactional
	public void initData(EnterpriseVO enterpriseVO) {
		logger.info("1、初始化租户、用户、组织等信息-----钉钉或企业微信初始化信息调用！"+JSONObject.toJSONString(enterpriseVO));
		if(StringUtils.isBlank(enterpriseVO.getSourceFrom())){
			throw new BusinessException("钉钉或企业微信初始化信息出错：来源不能为空！" );
		}
		if(StringUtils.isBlank(enterpriseVO.getCorpid())){
			throw new BusinessException("钉钉或企业微信初始化信息出错：钉钉或者企业微信id不能为空！" );
		}
//		if(StringUtils.isBlank(enterpriseVO.getPermanentCode())){
//			throw new BusinessException("钉钉或企业微信初始化信息出错：永久授权码不能为空！" );
//		}
		//判断该企业是否存在，存在则判断人员
		boolean exitTenant = false;
		QueryWrapper<TenantEntity> tenantWrapper = new QueryWrapper<>();
		tenantWrapper.eq("corpid", enterpriseVO.getCorpid()).eq("dr", 0);
		TenantEntity exitTenantEntity = iTenantService.getOne(tenantWrapper);
		OrgVO exitOrgVO = new OrgVO();
		if(exitTenantEntity != null) {
			exitTenant = true;
			//获取根组织
			exitOrgVO = iOrgService.findOrgByTenantId(exitTenantEntity.getId());
		}
		//根据sourceId判断人员是否存在，存在则直接生成租户、组织关系信息
		boolean exitUser = false;
		QueryWrapper<UserEntity> checkUserWrapper = new QueryWrapper<>();
		checkUserWrapper.eq("source_id", enterpriseVO.getUserSourceId()).eq("dr", 0);
		UserEntity exitUserEntity = iUserService.getOne(checkUserWrapper);

		if(exitUserEntity != null) {
			exitUser = true;
		}
		logger.info("2、初始化租户、用户、组织等信息-----exitTenant="+exitTenant+" exitUser =  "+exitUser);
		//1、创建租户
		Long tenantId = IdWorker.getId();
		Long orgId = IdWorker.getId();
		if(exitTenant){
			tenantId = exitTenantEntity.getId();
			orgId = exitOrgVO.getId();
		}else {
			enterpriseVO.setId(IdWorker.getId());
		}
		Long passwordPolicyId = IdWorker.getId();

		Long userId = IdWorker.getId();
		if(exitUser) {
			userId = exitUserEntity.getId();
		}
		enterpriseVO.setTenantId(tenantId);
		TenantEntity tenantEntity = new TenantEntity();
		if(!exitTenant){
			tenantEntity.setId(tenantId);
			tenantEntity.setTenantId(tenantId);
			tenantEntity.setName(enterpriseVO.getName());
			tenantEntity.setCode("T"+tenantId);
			tenantEntity.setEnterpriseId(enterpriseVO.getId());
			tenantEntity.setPasswordPolicyId(passwordPolicyId);
			tenantEntity.setState(1);
			tenantEntity.setSourceFrom(enterpriseVO.getSourceFrom());
			tenantEntity.setCorpid(enterpriseVO.getCorpid());
			tenantEntity.setPermanentCode(enterpriseVO.getPermanentCode());
			QueryWrapper<MenuCategoryEntity> categoryWapper = new QueryWrapper<>();
			categoryWapper.eq("default_flag", "1").eq("dr", 0);
			List<MenuCategoryEntity> list = menuCategoryService.list(categoryWapper);
			if(list!=null && list.size()>0){
				tenantEntity.setMenuCategoryId(list.get(0).getId());
			}
		}else {
			tenantEntity = exitTenantEntity;
			/** 更新 永久授权码*/
			tenantEntity.setPermanentCode(enterpriseVO.getPermanentCode());
		}

		//2、生成租户与用户之间的关系
		UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
		userTenantRelationEntity.setMainSpaceFlag(1);
		userTenantRelationEntity.setUserId(userId);
		userTenantRelationEntity.setTenantId(tenantId);
		userTenantRelationEntity.setTypeId(1);
		userTenantRelationEntity.setEmployeeId(userId);
		userTenantRelationEntity.setOrgId(orgId);
		userTenantRelationEntity.setState(1);

		PasswordPolicyEntity policyEntity = new PasswordPolicyEntity();
		DefaultPwdEntity defaultPwdEntity = new DefaultPwdEntity();
		OrgEntity orgEntity = new OrgEntity();
		//2、创建密码策略
		if(!exitTenant) {
			PasswordPolicyVO passwordPolicyVO = iPasswordPolicyService.findByTenantId(999999L);
			passwordPolicyVO.setId(passwordPolicyId);
			passwordPolicyVO.setTenantId(tenantId);
			passwordPolicyVO.setCode("PP" + passwordPolicyId);
			passwordPolicyVO.setTenantId(tenantId);
			passwordPolicyVO.setForceUpdateFlag(0);
			passwordPolicyVO.setValiditeDays(30);
			passwordPolicyVO.setPwdComplexity(1);
			passwordPolicyVO.setMinLength(6);
			policyEntity = BeanMapper.map(passwordPolicyVO, PasswordPolicyEntity.class);
			//3、租户默认密码
			defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(999999L);
			defaultPwdEntity.setId(IdWorker.getId());
			defaultPwdEntity.setTenantId(tenantId);
			if(StringUtils.isNotBlank(enterpriseVO.getPassword())){
				defaultPwdEntity.setDefaultpwd(enterpriseVO.getPassword());
			}
			defaultPwdEntity.setCreateTime(null);
			defaultPwdEntity.setUpdateTime(null);
			defaultPwdEntity.setUpdateUserCode(null);
			defaultPwdEntity.setCreateUserCode(null);
			defaultPwdEntity.setVersion(null);
			//4、创建组织
			orgEntity.setId(orgId);
			orgEntity.setCode("BASE"+orgId);
			orgEntity.setEnterpriseId(enterpriseVO.getId());
			orgEntity.setInnerCode(orgEntity.getId().toString());
			orgEntity.setState(1);
			orgEntity.setTenantId(tenantId);
			orgEntity.setName(enterpriseVO.getName());
			orgEntity.setOrgType(1);
			orgEntity.setShortName(enterpriseVO.getName());
			orgEntity.setManager(enterpriseVO.getLegalName());
			orgEntity.setPhone(enterpriseVO.getTelephone());
			orgEntity.setSequence(1);
		}else {
			orgEntity = BeanMapper.map(exitOrgVO,OrgEntity.class);
		}

		UserVO userVO = new UserVO();
		UserEntity userEntity = new UserEntity();
		EmployeeVO employeeVO = new EmployeeVO();

		if(!exitUser) {
			//5、创建用户
			userVO.setTenantId(tenantId);
			userVO.setOrgId(orgId);
			userVO.setId(userId);
			userVO.setUserName(enterpriseVO.getUserName());
			userVO.setUserMobile(enterpriseVO.getTelephone());
			userVO.setSourceId(enterpriseVO.getUserSourceId());
			userVO.setUserCode(enterpriseVO.getUserCode());
			userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
			userVO.setTypeId(1); //超级管理员
			userVO.setDr(BaseVO.DR_UNDELETE);
			PasswordUtils.setSalt(userVO);
			String password = defaultPwdEntity.getDefaultpwd();
			if (StringUtils.isNotBlank(enterpriseVO.getPassword())) {
				password = enterpriseVO.getPassword();
			}
			String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
			userVO.setPassword(shaPassword);
			userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
			userVO.setPwdStartTime(new Date());
			userEntity = BeanMapper.map(userVO, UserEntity.class);

			//6、创建人员
			employeeVO.setId(userId);
			employeeVO.setUserId(userId);
			employeeVO.setName(userEntity.getUserName());
			employeeVO.setCode(enterpriseVO.getUserCode());
			employeeVO.setEmployeeType(1);
			employeeVO.setState(0);
			employeeVO.setSex(1);
			if(StringUtils.isBlank(userEntity.getUserMobile())){
				employeeVO.setMobilePhone(userEntity.getSourceId());
			}else {
				employeeVO.setMobilePhone(userEntity.getUserMobile());
			}
			employeeVO.setOrgName(orgEntity.getName());
			employeeVO.setOrgId(orgId);
			employeeVO.setTenantId(tenantId);
		}
		enterpriseVO.setUserId(userId);
		//7、生成默认套餐关系
		QueryWrapper<ComboEntity> roleWrapper = new QueryWrapper<>();
		roleWrapper.eq("dr", 0);
		roleWrapper.eq("code", enterpriseVO.getComboCode());
		ComboEntity comboEntity = comboService.getOne(roleWrapper);
		ComboEnterpriseVO comboEnterpriseVO = new ComboEnterpriseVO();
		if(comboEntity!=null){
			comboEnterpriseVO.setBuyerId(tenantId);
			comboEnterpriseVO.setComboId(comboEntity.getId());
			comboEnterpriseVO.setUserId(userId);
			comboEnterpriseVO.setEnabled("1");
			comboEnterpriseVO.setComboName(comboEntity.getName());
			comboEnterpriseVO.setOpeningTime(new Date());
			comboEnterpriseVO.setStartTime(new Date());
			comboEnterpriseVO.setTenantId(999999l);
			Calendar cal = Calendar.getInstance();
			cal.setTime(new Date());
			cal.add(Calendar.DAY_OF_MONTH, 15);
			comboEnterpriseVO.setEndTime(cal.getTime());
		}
		logger.info("3、初始化租户、用户、组织等信息-----向支撑中心初始化数据="+JSONObject.toJSONString(enterpriseVO));
		if(!exitTenant) {
			//8、向支撑中心初始化数据-----不需要插入表
			try {
				EnterpriseInitVO vo = BeanMapper.map(enterpriseVO, EnterpriseInitVO.class);
				initDataApi.initData(vo);
			} catch (Exception e) {
				logger.info("3、初始化租户、用户、组织等信息-----向支撑中心初始化数据出差****"+e.getMessage());
				e.printStackTrace();
				initDataApi.rollBack(tenantId);
				throw new BusinessException("初始化支撑中心数据出错：" + e.getMessage());
			}
		}
		//9、数据持久化
		logger.info("4、初始化租户、用户、组织等信息-----数据持久化");
		try {
			iTenantService.saveOrUpdate(tenantEntity, false);
			if(!exitTenant) {
				logger.info("4、初始化租户");
				iPasswordPolicyService.saveOrUpdate(policyEntity, false);
				iDefaultpwdService.saveOrUpdate(defaultPwdEntity, false);
				iOrgService.saveOrUpdate(orgEntity, false);
				enterpriseVO.setLogoPath(environmentTools.getBaseHost()+"portal/themes/default/images/yjb_logo.png");
				EnterpriseEntity entity = BeanMapper.map(enterpriseVO, EnterpriseEntity.class);
				super.saveOrUpdate(entity,false);
			}else {
				enterpriseVO = selectById(tenantEntity.getEnterpriseId());
			}
			if(!exitUser) {
				logger.info("4、初始化 用户");
				iEmployeeService.save(employeeVO, userEntity);
				iUserService.saveOrUpdate(userEntity);
				logger.info("4、初始化租户、用户关系");
				userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
			}else{
				JobEntity vo = new JobEntity();
				// 属性类型：主职
				vo.setProperty(JobVO.JOB_TYPE_MAIN);
				vo.setEmployeeId(employeeVO.getId());
				// 新的工作记录
				vo.setCurState(JobVO.STATE_ACTIVE);
				vo.setJobStartTime(new Date());
				vo.setOrgId(employeeVO.getOrgId());
				vo.setDeptId(employeeVO.getDeptId());
				vo.setPostId(employeeVO.getPostId());
				vo.setDr(BaseVO.DR_UNDELETE);
				vo.setTenantId(employeeVO.getTenantId());
				vo.setDeptHead(employeeVO.getDeptHead());
				jobService.saveOrUpdate(vo, false);
				//当用户存在时，生成这个用户和租户的关系
				userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
			}
			if(comboEntity!=null && !exitTenant){
				logger.info("4、初始化套餐");
				comboEnterpriseService.saveComboEnterprise(comboEnterpriseVO);

			}
			initQYWXAndDDDefaultProject(tenantEntity,orgEntity,enterpriseVO);
		}catch (Exception e){
			logger.info("4、初始化租户、用户、组织等信息-----数据持久化出差****{}",e);
			e.printStackTrace();
			if(!exitTenant) {
				initDataApi.rollBack(tenantId);
			}
			throw new BusinessException("持久化数据出错："+e.getMessage());
		}
	}

	private void initQYWXAndDDDefaultProject(TenantEntity tenantEntity,OrgEntity orgEntity,EnterpriseVO enterpriseVO){
		String projectUrl = environmentTools.getBaseHost() + "ejc-market-web/projectRegister/no_auth/initQYWXAndDDDefaultProject";
		try {
			JSONObject body = new JSONObject();
			body.put("tenantId",tenantEntity.getId());
			body.put("orgId",orgEntity.getId());
			body.put("orgName",orgEntity.getName());
			body.put("enterpriseId",enterpriseVO.getId());
			String responseStr = HttpTookit.postByJson(projectUrl, JSON.toJSONString(body));
			if(StringUtils.isBlank(responseStr)){
				logger.info("初始化默认项目失败，请求地址{}，参数{}，返回值为空！",projectUrl,body.toJSONString());
				return;
			}
			CommonResponse<JSONObject> response = JSON.parseObject(responseStr, CommonResponse.class);
			if(!response.isSuccess()){
				logger.info("初始化默认项目失败，请求地址{}，参数{}，返回值{}",projectUrl,body.toJSONString(),responseStr);
				return;
			}
			logger.info("初始化默认项目成功，请求地址{}，参数{}，返回值{}",projectUrl,body.toJSONString(),responseStr);
			JSONObject data = response.getData();
			if(!data.getBoolean("exist")){
				/** 项目不存在，新增项目部*/
				OrgEntity orgDeptInfo = data.getObject("orgDeptInfo",OrgEntity.class);
				orgDeptInfo.setInnerCode(orgEntity.getInnerCode()+"|"+orgDeptInfo.getId());
				iOrgService.saveOrUpdate(orgDeptInfo, false);
				logger.info("项目不存在，新增项目部, 初始化默认项目部成功，{}",JSONObject.toJSONString(orgDeptInfo));
			}else {
				logger.info("项目部已存在，不再新增项目部,返回值{}",responseStr);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public List<EnterpriseVO> getAllEnterpriseList() {
		List<EnterpriseVO> enterpriseVos = enterpriseMapper.getAllEnterpriseList();
		return enterpriseVos;
	}

	@Override
	public Long getAllUserNum() {
		return enterpriseMapper.getAllUserNum();
	}

	@Override
	public Long getUserThisYearNum() {
		return enterpriseMapper.getUserThisYearNum();
	}

	/**
	 * 获取最近即将到期的租户及其到期套餐和时间
	 *
	 * @param endDate
	 * @return
	 */
	@Override
	public List<JSONObject> getEnterpriseComEndTimeLast3Month(String endDate) {
		return enterpriseMapper.getEnterpriseComEndTimeLast3Month(endDate);
	}

	/**
	 * 根据租户查询该租户：
	 * 服务开始时间
	 * 服务结束时间
	 * 套餐内应用数量
	 *
	 * @param tenantId
	 * @return {
	 * id:租户id，
	 * name：租户name，
	 * startTime：服务开始时间，
	 * endTime：服务结束时间，
	 * appNum:套餐内应用数量
	 * }
	 */
	@Override
	public JSONObject getEnterpriseComboInfo(Long tenantId) {
		return enterpriseMapper.getEnterpriseComboInfo(tenantId);
	}

	@Override
	public CommonResponse<EnterpriseVO> saveAndSubmit(EnterpriseVO vo) {
		EnterpriseEntity entity = BeanMapper.map(vo, EnterpriseEntity.class);

		entity.setWays("5");//企业认证
		entity.setExamineState("1");
		entity.setEnterpriseType("1");//入驻客户类型--企业
		entity.setCommitTime(new Date());
		entity.setAuditTime(new Date());
		entity.setAuditOpinion("新增自动审核通过！");
		entity.setId(IdWorker.getId());
		entity.setRegisterPhoneNum(vo.getManagePhone());

		QueryParam param = new QueryParam();
		param.getParams().put("name",new Parameter(QueryParam.EQ,vo.getName()));
		param.getParams().put("businessType",new Parameter(QueryParam.EQ,1));
		List<EnterpriseEntity> list =this.queryList(param);
		if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
			return CommonResponse.error("企业名称已存在！");
		}
		QueryParam params = new QueryParam();
		params.getParams().put("businessType",new Parameter(QueryParam.EQ,1));
		params.getParams().put("socialCreditCode",new Parameter(QueryParam.EQ,vo.getName()));
		List<EnterpriseEntity> listTaxCode =this.queryList(params);
		if(ListUtil.isNotEmpty(listTaxCode) && listTaxCode.get(0).getId()!=null && !listTaxCode.get(0).getId().equals(entity.getId())){
			return CommonResponse.error("统一社会信用代码已经存在！");
		}
		//根据人员手机号查询用户
		QueryWrapper<UserEntity> userPhoneWrapper = new QueryWrapper<>();
		userPhoneWrapper.eq("user_mobile", vo.getManagePhone()).eq("dr", 0);
		UserEntity userEntity = iUserService.getOne(userPhoneWrapper);
		//1、创建租户
		Long tenantId = IdWorker.getId();
		Long passwordPolicyId = IdWorker.getId();
		Long orgId = IdWorker.getId();
		boolean isNewUser = false;
		//4、租户默认密码
		DefaultPwdEntity defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(999999L);
		EmployeeVO employeeVO = null;
		Long userId = null;
		if(userEntity == null){
			isNewUser = true;
			//创建用户
			userId = IdWorker.getId();
			UserVO userVO = new UserVO();
			userVO.setId(userId);
			userVO.setTenantId(tenantId);
			userVO.setUserName(vo.getManageName());
			userVO.setUserCode("PU"+ IdWorker.getId());
			userVO.setUserMobile(vo.getManagePhone());
			userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
			userVO.setDr(BaseVO.DR_UNDELETE);
			userVO.setTypeId(1); //系统管理员
			userVO.setOrgId(orgId);
			PasswordUtils.setSalt(userVO);

			String shaPassword = PasswordUtils.encodePasswordUsingSHA(defaultPwdEntity.getDefaultpwd());
			userVO.setPassword(shaPassword);
			userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
			userVO.setPwdStartTime(new Date());
			userVO.setTenantId(InvocationInfoProxy.getTenantid());

			userEntity = BeanMapper.map(userVO, UserEntity.class);
			userEntity.setTenantId(tenantId);
			userEntity.setOrgId(orgId);

			employeeVO = new EmployeeVO();
			employeeVO.setId(userId);
			employeeVO.setUserId(userId);
			employeeVO.setName(vo.getManageName());
			employeeVO.setMobilePhone(vo.getManagePhone());
			//6、创建人员
			employeeVO.setCode("BASE-EMP"+userEntity.getId());
			employeeVO.setEmployeeType(1);
			employeeVO.setSex(1);
			employeeVO.setMobilePhone(userEntity.getUserMobile());
			employeeVO.setOrgName(entity.getName());
			employeeVO.setOrgId(orgId);
			employeeVO.setTenantId(tenantId);
			employeeVO.setState(1);
			employeeVO.setDr(BaseVO.DR_UNDELETE);
			employeeVO.setSequence(1);
			employeeVO.setWorkTime(new Date());

		}else{
			userId = userEntity.getId();
		}

		entity.setTenantId(tenantId);


		TenantEntity tenantEntity = new TenantEntity();
		tenantEntity.setId(tenantId);
		tenantEntity.setTenantId(tenantId);
		tenantEntity.setName(entity.getName());
		tenantEntity.setCode("T"+tenantId);
		tenantEntity.setEnterpriseId(entity.getId());
		tenantEntity.setPasswordPolicyId(passwordPolicyId);
		tenantEntity.setState(1);
		QueryWrapper<MenuCategoryEntity> categoryWapper = new QueryWrapper<>();
		categoryWapper.eq("code", "cgd").eq("dr", 0);
		List<MenuCategoryEntity> categorylist = menuCategoryService.list(categoryWapper);
		if(ListUtil.isNotEmpty(categorylist)){
			tenantEntity.setMenuCategoryId(categorylist.get(0).getId());
		}
		//3、创建密码策略
		PasswordPolicyVO passwordPolicyVO = iPasswordPolicyService.findByTenantId(999999L);
		passwordPolicyVO.setId(passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setCode("PP"+passwordPolicyId);
		passwordPolicyVO.setTenantId(tenantId);
		passwordPolicyVO.setForceUpdateFlag(0);
		passwordPolicyVO.setValiditeDays(30);
		passwordPolicyVO.setPwdComplexity(1);
		passwordPolicyVO.setMinLength(6);
		PasswordPolicyEntity policyEntity = BeanMapper.map(passwordPolicyVO,PasswordPolicyEntity.class);

		defaultPwdEntity.setId(IdWorker.getId());
		defaultPwdEntity.setTenantId(tenantId);
		defaultPwdEntity.setCreateTime(null);
		defaultPwdEntity.setUpdateTime(null);
		defaultPwdEntity.setUpdateUserCode(null);
		defaultPwdEntity.setCreateUserCode(null);
		defaultPwdEntity.setVersion(null);
		//5、创建组织
		OrgEntity orgEntity = new OrgEntity();
		orgEntity.setId(orgId);
		orgEntity.setCode("BASE"+orgId);
		orgEntity.setEnterpriseId(entity.getId());
		orgEntity.setInnerCode(orgEntity.getId().toString());
		orgEntity.setState(1);
		orgEntity.setTenantId(tenantId);
		orgEntity.setName(entity.getName());
		orgEntity.setOrgType(1);
		orgEntity.setShortName(entity.getName());
		orgEntity.setManager(entity.getLegalName());
		orgEntity.setPhone(entity.getTelephone());
		orgEntity.setSequence(1);


		//2、生成租户与用户之间的关系
		UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
		userTenantRelationEntity.setMainSpaceFlag(1);
		userTenantRelationEntity.setEmployeeId(userId);
		userTenantRelationEntity.setUserId(userId);
		userTenantRelationEntity.setTenantId(tenantId);
		userTenantRelationEntity.setTypeId(1);
		userTenantRelationEntity.setOrgId(orgId);
		userTenantRelationEntity.setState(1);

		//生成openapi并初始化数据
		//查询默认的供方api服务地址
		QueryWrapper<OpenApiGroupEntity> openApiGroupWaper = new QueryWrapper<>();
		openApiGroupWaper.eq("group_name", "协同交互接口");
		openApiGroupWaper.eq("dr", 0);
		List<OpenApiGroupEntity> openApiGroupList = openApiGroupService.list(openApiGroupWaper);
		SecurityKeyEntity securityKeyEntity = new SecurityKeyEntity();
		List<SecurityKeyDetailEntity> securityKeyDetailList = new ArrayList<>();
		Long securityKeyId = IdWorker.getId();
		String appid = IdWorker.getId()+"";
		String secret = Base64Util.encode(appid.getBytes());
		if(ListUtil.isNotEmpty(openApiGroupList)){
			securityKeyEntity.setAppId(appid);
			securityKeyEntity.setId(securityKeyId);
			securityKeyEntity.setSecretKey(secret);
			securityKeyEntity.setTenantId(tenantId);
			securityKeyEntity.setSecretDesc("生成采购租户：【"+entity.getName()+"】接收数据服务接口");
			securityKeyEntity.setSecretState(1);//启用
			securityKeyEntity.setSecurityName(entity.getName()+"接收数据服务接口");

			//获取具体的api服务
			QueryWrapper<OpenApiEntity> openApiWrapper = new QueryWrapper<>();
			openApiWrapper.eq("group_id", openApiGroupList.get(0).getId());
			openApiWrapper.eq("dr", 0);
			List<OpenApiEntity> openApiList = openApiService.list(openApiWrapper);
			if(ListUtil.isNotEmpty(openApiList)){
				for(OpenApiEntity apiEntity : openApiList){
					SecurityKeyDetailEntity detailEntity = new SecurityKeyDetailEntity();
					detailEntity.setOpenApiId(apiEntity.getId());
					detailEntity.setSecurityKeyId(securityKeyId);
					detailEntity.setTenantId(tenantId);
					securityKeyDetailList.add(detailEntity);
				}
				securityKeyService.saveOrUpdate(securityKeyEntity,false);
				securityKeyDetailService.saveOrUpdateBatch(securityKeyDetailList, securityKeyDetailList.size(),false);
				entity.setDataAppId(appid);
				entity.setDataAppSecret(secret);
				entity.setDataHost(environmentTools.getBaseHost().substring(0,environmentTools.getBaseHost().length()-1));
				logger.info("生成采购租户，初始化【协同交互接口】组具体的openapi服务成功！ "+entity.getName());
			}else {
				logger.error("生成采购租户,未初始化【协同交互接口】组具体的openapi服务,请联系管理员初始化数据 , enterpriseEntity = "+entity.getId());
			}
		}else{
			logger.error("未初始化openapi的【协同交互接口】组,请联系管理员初始化数据 , enterpriseEntity = "+entity.getId());
		}

		//7、向支撑中心初始化数据
		try {
			EnterpriseInitVO vo1 = BeanMapper.map(entity,EnterpriseInitVO.class);
			initDataApi.initData(vo1);
		}catch (Exception e){
			initDataApi.rollBack(tenantId);
			throw new BusinessException("初始化支撑中心数据出错："+e.getMessage());
		}

		//8、数据持久化
		try {
			this.saveOrUpdateNoES(entity);
			iTenantService.saveOrUpdate(tenantEntity,false);
			iPasswordPolicyService.saveOrUpdate(policyEntity,false);
			iDefaultpwdService.saveOrUpdate(defaultPwdEntity,false);
			iOrgService.saveOrUpdate(orgEntity,false);
			//生成job信息
			JobEntity jobEntity = new JobEntity();
			// 属性类型：主职
			jobEntity.setProperty(JobVO.JOB_TYPE_MAIN);
			jobEntity.setEmployeeId(userId);
			// 新的工作记录
			jobEntity.setCurState(JobVO.STATE_ACTIVE);
			jobEntity.setJobStartTime(new Date());
			jobEntity.setOrgId(orgId);
			jobEntity.setDr(BaseVO.DR_UNDELETE);
			jobEntity.setTenantId(tenantId);
			jobService.saveOrUpdate(jobEntity, false);

			if(isNewUser){
				iUserService.saveOrUpdate(userEntity);
				iEmployeeService.saveOrUpdate(BeanMapper.map(employeeVO, EmployeeEntity.class));
			}
			logger.info("------插入用户租户关系表start------");
			userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
		}catch (Exception e){
			initDataApi.rollBack(tenantId);
			throw new BusinessException("持久化数据出错："+e.getMessage());
		}
		EnterpriseVO back = BeanMapper.map(entity, EnterpriseVO.class);
		back.setManageName(vo.getManageName());
		back.setManageAccount(vo.getManageAccount());
		back.setManagePhone(vo.getManagePhone());
		return CommonResponse.success(back);
	}

	@Override
	public void fixUserRelation() {
		QueryParam param = new QueryParam();
		param.getParams().put("employee_id",new Parameter(QueryParam.EQ,null));
		List<UserTenantRelationEntity> relationEntities = userTenantRelationService.queryList(param);
		if(ListUtil.isNotEmpty(relationEntities)){
			param = new QueryParam();
			List<JobEntity> jobEntities = new ArrayList<>();
			for (UserTenantRelationEntity entity : relationEntities) {
				entity.setEmployeeId(entity.getUserId());
				param.getParams().put("orgId",new Parameter(QueryParam.EQ,entity.getOrgId()));
				param.getParams().put("employeeId",new Parameter(QueryParam.EQ,entity.getOrgId()));
				List<JobEntity> list = jobService.queryList(param);
				if(ListUtil.isEmpty(list)){
					JobEntity job = new JobEntity();
					job.setTenantId(entity.getTenantId());
					job.setOrgId(entity.getOrgId());
					job.setEmployeeId(entity.getUserId());
					job.setCurState(0);
					job.setProperty(1);
					jobEntities.add(job);
				}
			}
			userTenantRelationService.saveOrUpdateBatch(relationEntities);
			if(ListUtil.isNotEmpty(jobEntities)){
				jobService.saveOrUpdateBatch(jobEntities);
			}
		}
	}
}
