package com.ejianc.foundation.usercenter.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 用户与租户关系表
 * 
 * @author guoming
 *
 */
@TableName("ejc_idm_user_tenant_relation")
public class UserTenantRelationEntity extends BaseEntity {

	private static final long serialVersionUID = 6186458085180906222L;

	@TableField(value = "user_id")
	private Long userId;

	@TableField(value = "employee_id")
	private Long employeeId;

	@TableField(value = "type_id")
	private Integer typeId; // 用户类型（1：超级管理员，2：普通用户，3.管理员）

	@TableField(value = "main_space_flag")
	private Integer mainSpaceFlag; // 是否主空间（1：是，0：否）

	@TableField(value = "org_id")
	private Long orgId; // 任职组织

	@TableField(value = "dept_id")
	private Long deptId; // 任职部门

	@TableField(value = "post_id")
	private Long postId; // 任职岗位
	/**
	 * 状态标识 (1:启用，0：停用)
	 */
	@TableField(value = "state")
	private Integer state;

	@TableField(value = "manager_notes")
	private String managerNotes; // 描述（管理员页面使用，描述管理员的类型）

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public Integer getTypeId() {
		return typeId;
	}

	public void setTypeId(Integer typeId) {
		this.typeId = typeId;
	}

	public Integer getMainSpaceFlag() {
		return mainSpaceFlag;
	}

	public void setMainSpaceFlag(Integer mainSpaceFlag) {
		this.mainSpaceFlag = mainSpaceFlag;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public Long getPostId() {
		return postId;
	}

	public void setPostId(Long postId) {
		this.postId = postId;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getManagerNotes() {
		return managerNotes;
	}

	public void setManagerNotes(String managerNotes) {
		this.managerNotes = managerNotes;
	}

}
