package com.ejianc.foundation.nav.bean;

import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 模块导航图基础导航图标
 * 
 * @author generator
 * 
 */
 @TableName("ejc_idm_nav_mode_base")
public class NavModeBaseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="name")
    private String name; // 显示名称
    @TableField(value="left_top")
    private String leftTop; // 左上角坐标
    @TableField(value="right_bottom")
    private String rightBottom; // 右下角坐标
    @TableField(value="type")
    private String type; // 类型：model：弹窗；url：链接应用
    @TableField(value="alert_name")
    private String alertName; // 弹窗名称
    @TableField(value="app_url")
    private String appUrl; // 应用跳转地址
    @TableField(value="file_url")
    private String fileUrl; // 图片地址
    @TableField(value="pid")
    private Long pid; // 模块id
    @TableField(value="app_id")
    private Long appId; // 应用id
    @TableField(value="width")
    private Integer width; // 弹窗宽度
    @TableField(value="height")
    private Integer height; // 弹窗高度

    
    @TableField(exist=false)
    @SubEntity(serviceName="navModeBaseAppService")
    private List<NavModeBaseAppEntity> navModeBaseAppList = new ArrayList<>(); // 模块导航图弹窗应用配置
    

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getLeftTop() {
        return leftTop;
    }

    public void setLeftTop(String leftTop) {
        this.leftTop = leftTop;
    }
    public String getRightBottom() {
        return rightBottom;
    }

    public void setRightBottom(String rightBottom) {
        this.rightBottom = rightBottom;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getAlertName() {
        return alertName;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }
    public String getAppUrl() {
        return appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public List<NavModeBaseAppEntity> getNavModeBaseAppList() {
        return navModeBaseAppList;
    }

    public void setNavModeBaseAppList(List<NavModeBaseAppEntity> navModeBaseAppList) {
        this.navModeBaseAppList = navModeBaseAppList;
    }
}
