package com.ejianc.foundation.permission.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.permission.bean.ButtonEntity;
import com.ejianc.foundation.permission.mapper.ButtonMapper;
import com.ejianc.foundation.permission.service.IButtonService;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class ButtonServiceImpl extends BaseServiceImpl<ButtonMapper, ButtonEntity> implements IButtonService {
	
	@Override
	public ButtonVO queryDetail(Long id) {
		ButtonEntity entity = super.getById(id);
		if(entity != null) {
			return BeanMapper.map(entity, ButtonVO.class);
		}
		throw new BusinessException("未查询到该主键对应的详情");
	}
	
	@Override
	public void delete(List<Long> ids) {
		super.removeByIds(ids);
	}

	@Override
	public List<ButtonEntity> querylist(QueryWrapper<ButtonEntity> queryWrapper) {
		return this.list(queryWrapper);
	}
}
