package com.ejianc.foundation.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;

public class OrgAsTree {
	
	public static List<OrgEntity> createTreeData(List<OrgEntity> list) {
		List<OrgEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, OrgEntity> listMap = new HashMap<>();
		for(OrgEntity orgEntity:list) {
			listMap.put(orgEntity.getId().toString(), orgEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	OrgEntity orgEntity = list.get(i);
        	String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
        	OrgEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<OrgEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(orgEntity);
        		}else{
        			List<OrgEntity> children = new ArrayList<OrgEntity>();
        			children.add(orgEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(orgEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}
	
	public static List<OrgVO> createTreeDataVO(List<OrgVO> list) {
		List<OrgVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, OrgVO> listMap = new HashMap<>();
		for(OrgVO orgEntity:list) {
			listMap.put(orgEntity.getId().toString(), orgEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	OrgVO orgEntity = list.get(i);
        	String parentId = (orgEntity.getParentId() != null && orgEntity.getParentId() > 0) ? orgEntity.getParentId().toString():"";
        	OrgVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<OrgVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(orgEntity);
        		}else{
        			List<OrgVO> children = new ArrayList<OrgVO>();
        			children.add(orgEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(orgEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
