/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.operatelog.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.operatelog.service.IOperateLogService;
import com.ejianc.foundation.operatelog.vo.OperateLogVO;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperateLogServiceImpl
implements IOperateLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MongodbCrudTemplate mongodbCrudTemplate;
    @Autowired
    private IUserService userService;
    @Autowired
    private IOrgService orgService;

    @Override
    public IPage<OperateLogVO> queryPageList(QueryParam queryParam) {
        IPage pageData = this.mongodbCrudTemplate.queryPage(queryParam, "ejc_operation_log");
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(pageData.getTotal());
        List records = pageData.getRecords();
        if (records != null && records.size() > 0) {
            OperateLogVO operateLogVO = null;
            ArrayList<OperateLogVO> operateLogVOS = new ArrayList<OperateLogVO>();
            for (JSONObject jsonObject : records) {
                operateLogVO = new OperateLogVO();
                OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getById(jsonObject.getLong("orgId")));
                if (orgEntity != null) {
                    operateLogVO.setOrgName(orgEntity.getName());
                }
                operateLogVO.setId(jsonObject.getString("id"));
                UserEntity userEntity = (UserEntity)((Object)this.userService.getById(jsonObject.getLong("userId")));
                if (userEntity != null) {
                    operateLogVO.setOperateUserName(userEntity.getUserName());
                }
                operateLogVO.setRequestUrl(jsonObject.getString("requestUrl"));
                operateLogVO.setOperateUser(jsonObject.getString("operateUser"));
                operateLogVO.setOperateTime(jsonObject.getString("operateTime"));
                operateLogVO.setIpAddr(jsonObject.getString("ipAddr"));
                operateLogVO.setContent(jsonObject.getString("content"));
                operateLogVOS.add(operateLogVO);
            }
            page.setRecords(operateLogVOS);
        }
        return page;
    }

    @Override
    public List<OperateLogVO> exportData(List<String> param) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)(InvocationInfoProxy.getTenantid() + "")));
        queryParam.getOrderMap().put("operateTime", "asc");
        queryParam.getParams().put("operateTime", new Parameter("between", (Object)(param.get(0) + "," + param.get(1))));
        List records = this.mongodbCrudTemplate.selectList(queryParam, "ejc_operation_log");
        if (records != null && records.size() > 0) {
            ArrayList<OperateLogVO> operateLogVOS = new ArrayList<OperateLogVO>();
            for (JSONObject jsonObject : records) {
                OperateLogVO operateLogVO = new OperateLogVO();
                operateLogVO.setId(jsonObject.getString("id"));
                operateLogVO.setRequestUrl(jsonObject.getString("requestUrl"));
                operateLogVO.setOperateTime(jsonObject.getString("operateTime"));
                operateLogVO.setOperateUser(jsonObject.getString("operateUser"));
                operateLogVO.setTenantId(jsonObject.getString("tenantId"));
                operateLogVO.setUserId(jsonObject.getString("userId"));
                operateLogVO.setContent(jsonObject.getString("content"));
                operateLogVO.setIpAddr(jsonObject.getString("ipAddr"));
                operateLogVO.setOrgId(jsonObject.getString("orgId"));
                operateLogVO.setParamContent(jsonObject.getString("paramContent"));
                operateLogVOS.add(operateLogVO);
            }
            return operateLogVOS;
        }
        return null;
    }

    @Override
    public OperateLogVO queryOperateLogDetail(String id) {
        JSONObject jsonObject = this.mongodbCrudTemplate.selectById(id, "ejc_operation_log");
        if (jsonObject != null) {
            OperateLogVO operateLogVO = new OperateLogVO();
            operateLogVO.setId(jsonObject.getString("id"));
            operateLogVO.setRequestUrl(jsonObject.getString("requestUrl"));
            operateLogVO.setOperateUser(jsonObject.getString("operateUser"));
            operateLogVO.setOperateTime(jsonObject.getString("operateTime"));
            operateLogVO.setIpAddr(jsonObject.getString("ipAddr"));
            operateLogVO.setContent(jsonObject.getString("content"));
            operateLogVO.setParamContent(jsonObject.getString("paramContent"));
            return operateLogVO;
        }
        return null;
    }
}

