/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.helpcenter.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.helpcenter.bean.ScDocEntity;
import com.ejianc.foundation.helpcenter.bean.ScGroupEntity;
import com.ejianc.foundation.helpcenter.mapper.ScDocMapper;
import com.ejianc.foundation.helpcenter.mapper.ScGroupMapper;
import com.ejianc.foundation.helpcenter.service.IScDocService;
import com.ejianc.foundation.helpcenter.vo.ScDocVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScDocServiceImpl
extends BaseServiceImpl<ScDocMapper, ScDocEntity>
implements IScDocService {
    @Autowired
    private ScDocMapper scDocMapper;
    @Autowired
    private ScGroupMapper scGroupMapper;

    @Override
    public List<ScDocEntity> queryListByGroupId(Long groupId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"group_id", (Object)groupId);
        List resultList = super.list((Wrapper)queryWrapper);
        return resultList;
    }

    @Override
    public IPage<ScDocVO> queryScDocPage(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("groupId".equals(entry.getKey())) {
                ScGroupEntity scGroupEntity;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (scGroupEntity = (ScGroupEntity)((Object)this.scGroupMapper.selectById((Serializable)((Object)(parameter.getValue() + ""))))) == null) continue;
                condition.put("innerCode", scGroupEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<ScDocVO> records = this.scDocMapper.queryList(condition);
        Long count = this.scDocMapper.queryCount(condition);
        for (ScDocVO vo : records) {
            vo.setIntro(null);
        }
        Page page = new Page();
        page.setCurrent((long)queryParam.getPageIndex());
        page.setSize((long)queryParam.getPageSize());
        page.setTotal(count.longValue());
        page.setRecords(BeanMapper.mapList(records, ScDocVO.class));
        return page;
    }

    @Override
    public List<ScDocVO> queryScDocListByInnercode(String innerCode) {
        List<ScDocVO> scDocVos = this.scDocMapper.queryScDocListByInnercode(innerCode);
        return scDocVos;
    }

    @Override
    public List<ScDocVO> queryDocListBySearch(String searchText) {
        List<ScDocVO> scDocVos = this.scDocMapper.queryDocListBySearch(searchText);
        return scDocVos;
    }
}

