package com.ejianc.foundation.wzxtUserProject.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.wzxtUserProject.bean.WzxtUserProjectRelationEntity;
import com.ejianc.foundation.wzxtUserProject.mapper.WzxtUserProjectRelationMapper;
import com.ejianc.foundation.wzxtUserProject.service.IWzxtUserProjectRelationService;
import com.ejianc.foundation.wzxtUserProject.vo.WzxtUserProjectRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class WzxtUserProjectRelationServiceImpl extends BaseServiceImpl<WzxtUserProjectRelationMapper, WzxtUserProjectRelationEntity> implements IWzxtUserProjectRelationService {

	@Autowired
	private WzxtUserProjectRelationMapper wzxtUserProjectRelationMapper;
	@Autowired
	private IUserService userService;

	@Override
	@Transactional
	public CommonResponse<String> save(List<WzxtUserProjectRelationVO> relationVO) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("userId", new Parameter("eq",relationVO.get(0).getUserId()));
		List<WzxtUserProjectRelationEntity> projectList = this.queryList(queryParam , false);
		String message = "";
		List<WzxtUserProjectRelationEntity> entitys = new ArrayList<>();
		if(projectList!=null&&projectList.size()>0){
			Map<Long,Long> map = new HashMap<>();
			projectList.forEach(e -> {
				map.put(e.getProjectId(), e.getProjectId());
			});
			for(WzxtUserProjectRelationVO vo : relationVO){
				if(map.get(vo.getProjectId())!=null){
					//该应用已存在，不保存
					if(message.length()>0){
						message += ("、"+vo.getProjectName());
					}else{
						message += (vo.getProjectName());
					}
				}else{
					entitys.add(BeanMapper.map(vo, WzxtUserProjectRelationEntity.class));
				}
			}
			if(entitys!=null&&entitys.size()>0){
				this.saveOrUpdateBatch(entitys,entitys.size(), false);
			}
		}else{
			entitys = BeanMapper.mapList(relationVO, WzxtUserProjectRelationEntity.class);
			this.saveOrUpdateBatch(entitys,entitys.size(), false);
		}
		if(message.length()>0){
			if(projectList.size()!=entitys.size()){
				//说明选择的有已存在的；
				return CommonResponse.success("关联项目成功，其中"+message+"已存在");
			}else{
				//选择的全部是已存在的
				return CommonResponse.success("关联的项目全部已存在");
			}
		}
		return CommonResponse.success("关联项目成功");
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<WzxtUserProjectRelationVO> relationVO) {
		List<Long> projectIds = new ArrayList<>();
		relationVO.forEach(e -> {
			projectIds.add(e.getProjectId());
		});
		QueryWrapper<WzxtUserProjectRelationEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("user_id", relationVO.get(0).getUserId());
		wrapper.in("project_id", projectIds);
		wzxtUserProjectRelationMapper.delete(wrapper);
		return CommonResponse.success("删除成功");
	}

	@Override
	public CommonResponse<List<WzxtUserProjectRelationVO>> queryProjectByUserId(Long userId) {
		QueryWrapper<WzxtUserProjectRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("user_id", userId);
		queryWrapper.eq("dr", 0);
		List<WzxtUserProjectRelationEntity> listEntity = this.list(queryWrapper);
		if(listEntity!=null&&listEntity.size()>0){
			return CommonResponse.success(BeanMapper.mapList(listEntity, WzxtUserProjectRelationVO.class));
		}
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<List<UserVO>> queryUserByProjectAndTenant(Long projectId, Long tenantId) {
		List<UserVO> backData = new ArrayList<>();
		//1、获取已分配的有关联的项目；
		QueryWrapper<WzxtUserProjectRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.eq("tenant_id", tenantId);
		queryWrapper.eq("dr", 0);
		List<WzxtUserProjectRelationEntity> listEntity = this.list(queryWrapper);
		if(listEntity!=null&&listEntity.size()>0){
			List<Long> userIds = new ArrayList<>();
			listEntity.forEach(e -> {
				userIds.add(e.getUserId());
			});
			List<UserEntity> entitys = (List<UserEntity>) userService.listByIds(userIds);
			if(entitys!=null&&entitys.size()>0){
				backData.addAll(BeanMapper.mapList(entitys, UserVO.class));
			}
		}
		//2、获取具有所有项目权限的用户（即所有用户-在关系表中有关系的用户）
		List<UserVO> list = wzxtUserProjectRelationMapper.queryUserByProjectAndTenant(tenantId);
		if(list!=null&&list.size()>0){
			backData.addAll(list);
		}
		return CommonResponse.success(backData);
	}
    
}
