/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.usercenter.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserManagerRelationAppEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.mapper.UserManagerRelationAppMapper;
import com.ejianc.foundation.usercenter.service.IUserManagerRelationAppService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.vo.UserManagerAppRelationVO;
import com.ejianc.foundation.usercenter.vo.UserManagerRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserManagerRelationAppServiceImpl
extends BaseServiceImpl<UserManagerRelationAppMapper, UserManagerRelationAppEntity>
implements IUserManagerRelationAppService {
    @Autowired
    private UserManagerRelationAppMapper userManagerRelationMapper;
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;

    @Override
    public IPage<UserManagerRelationVO> queryManagerList(Map<String, Object> params) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(params.get("pageIndex").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.userManagerRelationMapper.countManagerList(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        voList = this.userManagerRelationMapper.queryManagerList(params);
        if (voList != null && voList.size() > 0) {
            for (UserManagerRelationVO userManagerRelationVO : voList) {
                if (userManagerRelationVO.getTypeId() == 1) continue;
                List<UserManagerAppRelationVO> list = this.userManagerRelationMapper.queryAppListbyUserId(userManagerRelationVO.getUserId(), InvocationInfoProxy.getTenantid());
                userManagerRelationVO.setRelationList(list);
            }
        }
        page.setRecords(voList);
        return page;
    }

    @Override
    @Transactional
    public CommonResponse<String> save(UserManagerRelationVO relationVO, boolean b) {
        HashMap<String, Long> columnMap = new HashMap<String, Long>();
        columnMap.put("user_id", relationVO.getUserId());
        columnMap.put("tenant_id", InvocationInfoProxy.getTenantid());
        this.userManagerRelationMapper.deleteByMap(columnMap);
        if (relationVO.getRelationList() != null && relationVO.getRelationList().size() > 0) {
            List list = relationVO.getRelationList();
            List entitys = BeanMapper.mapList((Iterable)list, UserManagerRelationAppEntity.class);
            this.saveOrUpdateBatch(entitys);
        }
        UserTenantRelationEntity userTenantRelation = this.userTenantRelationService.getOne(relationVO.getUserId(), null);
        userTenantRelation.setTypeId(3);
        userTenantRelation.setManagerNotes(relationVO.getManagerNotes());
        if (userTenantRelation.getMainSpaceFlag() == 1) {
            UserEntity entity = (UserEntity)((Object)this.userService.getById(relationVO.getUserId()));
            entity.setTypeId(3);
            entity.setManagerNotes(relationVO.getManagerNotes());
            this.userService.saveOrUpdate((Object)entity, false);
        }
        this.userTenantRelationService.saveOrUpdate((Object)userTenantRelation, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(Long userId) {
        HashMap<String, Long> columnMap = new HashMap<String, Long>();
        columnMap.put("user_id", userId);
        columnMap.put("tenant_id", InvocationInfoProxy.getTenantid());
        this.userManagerRelationMapper.deleteByMap(columnMap);
        UserTenantRelationEntity userTenantRelation = this.userTenantRelationService.getOne(userId, null);
        userTenantRelation.setTypeId(2);
        userTenantRelation.setManagerNotes(null);
        if (userTenantRelation.getMainSpaceFlag() == 1) {
            UserEntity entity = (UserEntity)((Object)this.userService.getById(userId));
            entity.setTypeId(2);
            entity.setManagerNotes(null);
            this.userService.saveOrUpdate((Object)entity, false);
        }
        this.userTenantRelationService.saveOrUpdate((Object)userTenantRelation, false);
        return CommonResponse.success((String)"\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @Override
    public CommonResponse<String> removeManager(Long sourceUserId, Long targetUserId, String managerNotes) {
        UserTenantRelationEntity sourceUserTenantRelation = this.userTenantRelationService.getOne(sourceUserId, null);
        sourceUserTenantRelation.setTypeId(2);
        sourceUserTenantRelation.setManagerNotes(null);
        if (sourceUserTenantRelation.getMainSpaceFlag() == 1) {
            UserEntity sourceEntity = (UserEntity)((Object)this.userService.getById(sourceUserId));
            sourceEntity.setTypeId(2);
            sourceEntity.setManagerNotes(null);
            this.userService.saveOrUpdate((Object)sourceEntity, false);
        }
        this.userTenantRelationService.saveOrUpdate((Object)sourceUserTenantRelation, false);
        UserTenantRelationEntity targetUserTenantRelation = this.userTenantRelationService.getOne(targetUserId, null);
        targetUserTenantRelation.setTypeId(1);
        targetUserTenantRelation.setManagerNotes(managerNotes);
        if (sourceUserTenantRelation.getMainSpaceFlag() == 1) {
            UserEntity targetEntity = (UserEntity)((Object)this.userService.getById(targetUserId));
            targetEntity.setTypeId(1);
            targetEntity.setManagerNotes(managerNotes);
            this.userService.saveOrUpdate((Object)targetEntity, false);
        }
        this.userTenantRelationService.saveOrUpdate((Object)targetUserTenantRelation, false);
        HashMap<String, Long> columnMap = new HashMap<String, Long>();
        columnMap.put("user_id", targetUserId);
        columnMap.put("tenant_id", InvocationInfoProxy.getTenantid());
        this.userManagerRelationMapper.deleteByMap(columnMap);
        return CommonResponse.success((String)"\u79fb\u4ea4\u7ba1\u7406\u5458\u6210\u529f");
    }

    @Override
    public IPage<AppEntity> queryUserAppList(Map<String, Object> params) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.userManagerRelationMapper.countUserAppList(params);
        Page page = new Page();
        if (count > 0L) {
            List<AppEntity> appEntity = this.userManagerRelationMapper.queryUserAppList(params);
            page.setRecords(appEntity);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    public CommonResponse<String> saveUserApp(List<UserManagerAppRelationVO> relationVO) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", relationVO.get(0).getUserId());
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        List<AppEntity> appVO = this.userManagerRelationMapper.queryUserAppList(params);
        String message = "";
        List<Object> entitys = new ArrayList();
        if (appVO != null && appVO.size() > 0) {
            HashMap map = new HashMap();
            appVO.forEach(e -> map.put(e.getId(), e.getId()));
            for (UserManagerAppRelationVO vo : relationVO) {
                if (map.get(vo.getAppId()) != null) {
                    if (message.length() > 0) {
                        message = message + "\u3001" + vo.getAppName();
                        continue;
                    }
                    message = message + vo.getAppName();
                    continue;
                }
                entitys.add(BeanMapper.map((Object)vo, UserManagerRelationAppEntity.class));
            }
            if (entitys != null && entitys.size() > 0) {
                this.saveOrUpdateBatch(entitys, entitys.size(), false);
            }
        } else {
            entitys = BeanMapper.mapList(relationVO, UserManagerRelationAppEntity.class);
            this.saveOrUpdateBatch(entitys, entitys.size(), false);
        }
        if (message.length() > 0) {
            if (entitys.size() > 0) {
                return CommonResponse.success((String)("\u5206\u914d\u5e94\u7528\u6743\u9650\u6210\u529f\uff0c\u5176\u4e2d" + message + "\u5df2\u5b58\u5728"));
            }
            return CommonResponse.success((String)"\u9009\u62e9\u7684\u5e94\u7528\u6743\u9650\u5168\u90e8\u5df2\u5b58\u5728");
        }
        return CommonResponse.success((String)"\u5206\u914d\u5e94\u7528\u6743\u9650\u6210\u529f");
    }

    @Override
    public CommonResponse<String> delUserApp(List<UserManagerAppRelationVO> relationVO) {
        ArrayList appIds = new ArrayList();
        relationVO.forEach(e -> appIds.add(e.getAppId()));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)relationVO.get(0).getUserId());
        wrapper.in((Object)"app_id", appIds);
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        this.userManagerRelationMapper.delete((Wrapper)wrapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public IPage<AppEntity> queryUserApp(Map<String, Object> params) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.userManagerRelationMapper.countUserApp(params);
        Page page = new Page();
        if (count > 0L) {
            List<AppEntity> appEntity = this.userManagerRelationMapper.queryUserApp(params);
            page.setRecords(appEntity);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }
}

