package com.ejianc.foundation.news.service;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.news.bean.NewsEntity;
import com.ejianc.foundation.news.vo.NewsVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface INewsService extends IBaseService<NewsEntity> {

	NewsVO queryDetail(Long id);

	void delete(Long id);
	
	IPage<NewsVO> queryPageByParams(QueryParam queryParam, boolean isEs);

	List<NewsEntity> queryImageList(Long tenantId);

	List<NewsEntity> queryNewsList(Long tenantId);

	/**
	 * 小程序首页新闻列表查询，只查询新闻标题，简介，缩略图，不查询详情
	 * @param tenantId
	 * @return
	 */
    List<NewsEntity> queryIndexNewsList(Long tenantId);
}
