package com.ejianc.foundation.orgcenter.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.utils.gdty.param.GdtyOrg;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 组织service
 * 
 * @author guominga
 *
 */
public interface IOrgService extends IBaseService<OrgEntity> {

	/**
	 * 查询组织树--只查询启用的组织
	 * 
	 * @param params
	 * @return
	 */
	List<OrgEntity> queryListTree(Map<String, Object> params);

	/**
	 * 查询组织详情
	 * 
	 * @param id
	 * @return
	 */
	OrgVO queryDetail(Long id);

	/**
	 * 根据主键删除
	 * 
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 根据父ID查询所有子节点
	 * 
	 * @param id
	 * @return
	 */
	List<OrgVO> queryListByPid(Long id);

	/**
	 * 根据map参数查询组织list
	 * 
	 * @param map
	 * @return
	 */
	List<OrgVO> selectByMap(Map<String, Object> map);

	/**
	 * 根据组织主键ID查询对应的组织列表
	 *
	 * @param list
	 * @return
	 */
    List<OrgEntity> getAllByIds(List<Long> list);

    /**
     * 查询用户上下文组织
     * 
     * @param orgId
     * @return
     */
	OrgVO queryUserContextOrg(Long orgId);

	/**
	 * 查询上下文组织树的下级节点
	 * 
	 * @param orgId
	 * @param prjstate
	 * @return
	 */
	List<OrgVO> getSubOrgs(Long orgId, Integer prjstate);

	/**
	 * 查询上下文组织
	 * 
	 * @param searchText
	 * @param orgIds
	 * @param prjstate
	 * @return
	 */
	List<OrgVO> searchOrgs(String searchText, String orgIds, Integer prjstate);

	/**
	 * 查询用户上下文组织list
	 * 
	 * @param resultList
	 * @param prjstate
	 * @return
	 */
	List<OrgVO> queryUserContextOrgList(List<Long> resultList, Integer prjstate);

	/**
	 * 查询当前登录人的所有任职组织
	 * 
	 * @param userId
	 * @return
	 */
	List<OrgVO> queryJobOrgs(Long userId);

	/**
	 * 根据父Id查询其所有下级节点
	 * 
	 * @param orgId
	 * @return
	 */
	List<OrgVO> queryAppSubByPid(Long orgId);

	/**
	 * 根据组织ID查询其所有父节点
	 * 
	 * @param orgId
	 * @return
	 */
	List<OrgVO> findParentsByOrgId(Long orgId);
	
	/**
	 * 根据组织ID查询其所有父节点---升序
	 * 
	 * @param orgId
	 * @return
	 */
	List<OrgVO> findParentsByOrgIdAsc(Long orgId);

	/**
	 * 根据租户ID查询其根节点组织信息
	 * 
	 * @param orgId
	 * @return
	 */
	OrgVO findOrgByTenantId(Long tenantId);

	/**
	 * 根据orgIds获取orgVOList
	 * 
	 * @param orgIds
	 * @return
	 */
	List<OrgVO> queryOrgListByIds(List<Long> orgIds);

	/**
	 * 查询其下所有的项目部
	 * 
	 * @param innerCode
	 * @return
	 */
	List<OrgVO> queryAllProjectOrgsByInnerCode(String innerCode);

	/**
	 * 查询其下所有的非项目部
	 *
	 * @param innerCode
	 * @return
	 */
	List<OrgVO> queryAllOrgByInnerCodeWithoutProjectDept(String innerCode);

	List<OrgVO> queryOrgList(Map<String, Object> params);

    //查询组织部门树时，之前的无法判断该节点是否是叶子节点，故作处理
    List<OrgVO> queryOrgList2(Map<String, Object> params);

    /**
	 * 根据父组织Id查询所有子组织信息列表, parentId缺省时查询根组织
	 *
	 * @param parentId
	 * @param searchText
	 * @return
	 */
    List<OrgVO> getDirectChildrenByPid(Long parentId, String searchText);

	OrgEntity queryBySourceId(String sourceId,Long tenantId);

	/**
	 * 查询指定组织下的所有直接子级以及对应的人员数量
	 *
	 * @param orgId
	 * @return
	 */
    List<Map<String, Object>> getSubOrgMaps(Long orgId);

	/**
	 * 根据租户ID查询其根节点组织信息
	 *
	 * @param tenantId
	 * @return
	 */
	List<Map<String, Object>> findOrgMapsByTenantId(Long tenantId);

	/**
	 * 根据组织Id删除组织相关所有信息
	 * (项目立项使用，仅删除项目部)
	 *
	 * @param orgId
	 */
	String delAllByOrgId(Long orgId);

	/**
	 * 根据组织Id删除组织相关所有信息
	 * (水电三局项目申请使用，仅删除项目部)
	 * @param orgId
	 * @return
	 */
    String delSDSJPrjDepartmentByOrgId(Long orgId);

    /**
     * 云南建投-生成组织和部门
     * 
     * @param saveOrgBean
     */
	void saveOrgAndDept(OrgEntity saveOrgBean);

	/**
	 * 云南建投-修改组织或部门
	 * 
	 * @param saveOrgBean
	 */
	void updateOrgAndDept(OrgEntity saveOrgBean);

	/**
	 * 插入广东腾越数据
	 * 
	 * @param insertOrgSql
	 */
	void insertGdtyOrgData(String insertOrgSql);

	/**
	 * 查询广东腾越数据
	 * 
	 * @param insertOrgSql
	 */
	List<GdtyOrg> queryGdtyOrgData();

	JSONObject getAuthority(String authority);

	public List<OrgVO> queryOrgNewList(Map<String, Object> params);

	List<OrgEntity> getRootOrgList(Long tenantId);
}
