package com.ejianc.foundation.permission.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.permission.bean.TasklistConfigEntity;
import com.ejianc.foundation.permission.mapper.TasklistConfigMapper;
import com.ejianc.foundation.permission.service.ITasklistConfigService;
import com.ejianc.foundation.permission.vo.TasklistConfigVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.gson.*;
import com.google.gson.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

@Service
public class TasklistConfigServiceImpl extends BaseServiceImpl<TasklistConfigMapper, TasklistConfigEntity> implements ITasklistConfigService {

	// 日志
	private final Logger logger = LoggerFactory.getLogger(getClass());

	private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
	@Autowired
	private TasklistConfigMapper tasklistConfigMapper;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IMdApi mdApi;
	@Autowired
	private EnvironmentTools environmentTools;

	@Override
	public List<TasklistConfigVO> queryListData(HttpServletRequest request){
		List<TasklistConfigVO> vos = new ArrayList<>();
		String authority = request.getHeader("authority");

		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		Map<String, String> order = queryParam.getOrderMap();
		order.put("sequence", "asc");
		order.put("createTime", "desc");
		List<TasklistConfigEntity> pageData = this.queryList(queryParam, false);
		if(pageData!=null && pageData.size()>0){
			//创建一个固定数量的线程池
			ExecutorService threadPool = Executors.newFixedThreadPool(5);
			for(TasklistConfigEntity entity : pageData){
				TasklistConfigVO vo = BeanMapper.map(entity, TasklistConfigVO.class);
				try {
					Callable<Integer> myCallable = new MyTask(RequestContextHolder.getRequestAttributes(), authority, entity);
					Future<Integer> myFuture = threadPool.submit(myCallable);
					vo.setCountNumber(myFuture.get());
				} catch (Exception e) {
					logger.error("异常：", e);
				}
				vos.add(vo);
			}
			threadPool.shutdown();
		}

		return vos;
	}

	class MyTask implements Callable<Integer> {

		private RequestAttributes context;
		private String authority;
		private TasklistConfigEntity entity;

		public MyTask(RequestAttributes context, String authority, TasklistConfigEntity entity) {
			this.context = context;
			this.authority = authority;
			this.entity = entity;
		}

		@Override
		public Integer call() throws Exception {
			Integer resp = null;
			context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
			RequestContextHolder.setRequestAttributes(context);

			CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getById(entity.getBillTypeId());
			if(billTypeResponse.isSuccess()) {
				BillTypeVO billTypeVo = billTypeResponse.getData();
				logger.info("调用元数据api参数：---------------"+billTypeVo.getMetadataId());
				if(billTypeVo.getMetadataId()!=null){
					CommonResponse<MdReferVO> referResponse = mdApi.queryMetadataById(billTypeVo.getMetadataId());
					if(referResponse.isSuccess()) {
						MdReferVO vo = referResponse.getData();
						Map<String, Object> paramterMap = new HashMap<>();
						paramterMap.put("sql", entity.getCountSql());
						String paramterStr = gson.toJson(paramterMap);
						String url = environmentTools.getBaseHost() + vo.getProjectName() + "/commonQuery/queryNumberBySql";
						logger.info("调用restUrl-----------------------"+url);
						try {
							String result = ReferHttpClientUtils.postByJson(url, paramterStr);
							CommonResponse<Integer> re = gson.fromJson(result, new TypeToken<CommonResponse<Integer>>() {}.getType());
							resp = re.getData();
						} catch (Exception e) {
							e.printStackTrace();
						}
					}else{
						logger.info("调用查询元数据服务异常：---------------"+referResponse.getMsg());
					}
				}
			}
			return resp;
		}

	}
}
