package com.ejianc.foundation.usercenter.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.mapper.UserTenantRelationMapper;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class UserTenantRelationServiceImpl extends BaseServiceImpl<UserTenantRelationMapper, UserTenantRelationEntity> implements IUserTenantRelationService {

	@Autowired
	private UserTenantRelationMapper userTenantRelationMapper;
	
	@Override
	public void updateUserMainSpace(Long userId, String tenantId) {
		userTenantRelationMapper.updateNoMainSpace(userId);
		userTenantRelationMapper.updateUserMainSpace(userId, tenantId);
	}

	@Override
	public UserTenantRelationEntity getOne(Long userId, Long employeeId) {
		QueryWrapper<UserTenantRelationEntity> wrapper = new QueryWrapper<>();
		if(userId!=null){
			wrapper.eq("user_id", userId);
		}
		if(employeeId!=null){
			wrapper.eq("employee_id", employeeId);
		}
		wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		wrapper.eq("dr", 0);
		List<UserTenantRelationEntity> userTenantList = this.list(wrapper);
		if(userTenantList!=null&&userTenantList.size()>0){
			return userTenantList.get(0);
		}
		return null;
	}
	
}
