package com.ejianc.foundation.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.ejianc.foundation.utils.gdty.param.GdtyOrg;

public class GdtyOrgAsTree {
	
	public static List<GdtyOrg> createTreeData(List<GdtyOrg> list) {
		List<GdtyOrg> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, GdtyOrg> listMap = new HashMap<>();
		for(GdtyOrg gdtyOrg:list) {
			listMap.put(gdtyOrg.getOrgCode(), gdtyOrg);
		}
        
        for(int i =0; i<list.size(); i++) {
        	GdtyOrg gdtyOrg = list.get(i);
        	String parentOrgCode = (StringUtils.isNotBlank(gdtyOrg.getParentOrgCode())) ? gdtyOrg.getParentOrgCode():"";
        	GdtyOrg parent = listMap.get(parentOrgCode);
        	if(parent != null) {
        		List<GdtyOrg> child = parent.getChildren();
        		if(child != null) {
        			child.add(gdtyOrg);
        		}else{
        			List<GdtyOrg> children = new ArrayList<GdtyOrg>();
        			children.add(gdtyOrg);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(gdtyOrg.getOrgCode());
        	}
        }
        for(String rootId : rootItems) {
        	GdtyOrg rootOrg = listMap.get(rootId);
        	resp.add(rootOrg);
        }
		return resp;
	}

}
