/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.sync.service.ISdbjSyncService;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.HttpTookit8Ju;
import com.ejianc.foundation.utils.WeixinRestUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class SdbjSyncServiceImpl
implements ISdbjSyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IDeptService deptService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;

    @Override
    public void syncData(String begintime, String endtime, Boolean updateTime) {
        ExecutorService threadPool = Executors.newFixedThreadPool(3);
        RequestAttributes context = RequestContextHolder.getRequestAttributes();
        String orgUrl = "http://10.60.231.40/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/orgAddQuery";
        DataSync orgDeptCallable = new DataSync(begintime, endtime, orgUrl, context);
        Future<JSONArray> orgDeptFuture = threadPool.submit(orgDeptCallable);
        String userUrl = "http://10.60.231.40/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/personAddCommonQuery";
        DataSync userCallable = new DataSync(begintime, endtime, userUrl, context);
        Future<JSONArray> userFuture = threadPool.submit(userCallable);
        String jobUrl = "http://10.60.231.40/cwbase/sg/V1/ERP/SI/JZSIFI/api_jzwfw_Org/personParttimeQuery";
        DataSync jobCallable = new DataSync(begintime, endtime, jobUrl, context);
        Future<JSONArray> jobFuture = threadPool.submit(jobCallable);
        JSONArray orgDeptData = null;
        JSONArray userData = null;
        JSONArray jobData = null;
        try {
            orgDeptData = orgDeptFuture.get();
            userData = userFuture.get();
            jobData = jobFuture.get();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u540c\u6b65\u6570\u636e\u5931\u8d25\uff1a{}", (Throwable)e);
            this.sendMsg("\u83b7\u53d6\u540c\u6b65\u4fe1\u606f\u63a5\u53e3\u62a5\u9519", begintime + "----" + endtime);
            throw new BusinessException("\u83b7\u53d6\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
        finally {
            threadPool.shutdown();
        }
        this.logger.info("\u5904\u7406\u7ec4\u7ec7\u6570\u636e-------");
        try {
            this.syncOrgAndDeptList(orgDeptData);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u7ec4\u7ec7\u6570\u636e\u5931\u8d25\uff1a{}", (Throwable)e);
            this.sendMsg("\u5904\u7406\u7ec4\u7ec7\u6570\u636e\u62a5\u9519", begintime + "----" + endtime);
            throw new BusinessException("\u5904\u7406\u7ec4\u7ec7\u6570\u636e\u5931\u8d25");
        }
        this.logger.info("\u5904\u7406\u4eba\u5458\u6570\u636e-------");
        try {
            this.syncEmployeeAndUserList(userData);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u4eba\u5458\u6570\u636e\u5931\u8d25\uff1a{}", (Throwable)e);
            this.sendMsg("\u5904\u7406\u4eba\u5458\u6570\u636e\u62a5\u9519", begintime + "----" + endtime);
            throw new BusinessException("\u5904\u7406\u4eba\u5458\u6570\u636e\u5931\u8d25");
        }
        this.logger.info("\u5904\u7406\u517c\u804c\u6570\u636e-------");
        try {
            this.syncJobList(jobData);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u517c\u804c\u6570\u636e\u5931\u8d25\uff1a{}", (Throwable)e);
            this.sendMsg("\u5904\u7406\u517c\u804c\u6570\u636e\u62a5\u9519", begintime + "----" + endtime);
            throw new BusinessException("\u5904\u7406\u517c\u804c\u6570\u636e\u5931\u8d25");
        }
        this.logger.info("\u6570\u636e\u5904\u7406\u7ed3\u675f(- v -)!-------");
        if (updateTime.booleanValue()) {
            ThirdSystemEntity thirdSystemVO = this.thirdSystemService.queryThirdSystemByCode("sdbjSyncDate");
            thirdSystemVO.setConfigInfo(endtime);
            this.thirdSystemService.saveOrUpdate((Object)thirdSystemVO, false);
        }
    }

    @Override
    public void syncOrgAndDeptList(JSONArray orgDeptData) {
        QueryWrapper wrapper;
        Object flag;
        ArrayList<String> disabldOrgSourceIds = new ArrayList<String>();
        ArrayList<OrgEntity> addEditOrgList = new ArrayList<OrgEntity>();
        ArrayList<String> sourceOrgIds = new ArrayList<String>();
        ArrayList<String> disabldDeptSourceIds = new ArrayList<String>();
        ArrayList<DeptEntity> addEditDeptList = new ArrayList<DeptEntity>();
        ArrayList<String> sourceDeptIds = new ArrayList<String>();
        for (Object data : orgDeptData) {
            String name;
            JSONObject jdata = (JSONObject)data;
            if ("UN".equals(jdata.getString("codesetid"))) {
                Object object = flag = jdata.get((Object)"flag") != null ? jdata.getString("flag") : null;
                if ("3".equals(flag)) {
                    String string = jdata.get((Object)"unique_id") != null ? jdata.getString("unique_id").replaceAll("-", "") : null;
                    disabldOrgSourceIds.add(string);
                    continue;
                }
                String string = jdata.get((Object)"b0110_0") != null ? jdata.getString("b0110_0") : null;
                String sourceId2 = jdata.get((Object)"unique_id") != null ? jdata.getString("unique_id").replaceAll("-", "") : null;
                name = jdata.get((Object)"codeitemdesc") != null ? jdata.getString("codeitemdesc") : null;
                String shortName = jdata.get((Object)"codeitemdesc") != null ? jdata.getString("codeitemdesc") : null;
                Integer orgType = null;
                if (jdata.get((Object)"f0107") != null) {
                    orgType = "5".equals(jdata.getString("f0107")) ? Integer.valueOf(1) : ("6".equals(jdata.getString("f0107")) ? Integer.valueOf(4) : ("3".equals(jdata.getString("f0107")) ? Integer.valueOf(2) : ("8".equals(jdata.getString("f0107")) ? Integer.valueOf(4) : ("7".equals(jdata.getString("f0107")) ? Integer.valueOf(2) : ("2".equals(jdata.getString("f0107")) ? Integer.valueOf(3) : Integer.valueOf(4))))));
                }
                String sourceOrgParentId = null;
                if (jdata.get((Object)"parentid") != null) {
                    sourceOrgParentId = jdata.getString("parentid").replaceAll("-", "");
                }
                OrgEntity org = new OrgEntity();
                org.setEnterpriseId(999999L);
                org.setTenantId(999999L);
                org.setCode(string);
                org.setSourceId(sourceId2);
                org.setName(name);
                org.setShortName(shortName);
                org.setOrgType(orgType);
                org.setProjectCode(sourceOrgParentId);
                org.setId(IdWorker.getId());
                org.setSystemId("1247777316689256450");
                addEditOrgList.add(org);
                if (!sourceOrgIds.contains(sourceId2)) {
                    sourceOrgIds.add(sourceId2);
                }
                if (sourceOrgIds.contains(sourceOrgParentId)) continue;
                sourceOrgIds.add(sourceOrgParentId);
                continue;
            }
            if (!"UM".equals(jdata.getString("codesetid"))) continue;
            Object object = flag = jdata.get((Object)"flag") != null ? jdata.getString("flag") : null;
            if ("3".equals(flag)) {
                String string = jdata.get((Object)"unique_id") != null ? jdata.getString("unique_id").replaceAll("-", "") : null;
                disabldDeptSourceIds.add(string);
                continue;
            }
            String string = jdata.get((Object)"unique_id") != null ? jdata.getString("unique_id").replaceAll("-", "") : null;
            String code = jdata.get((Object)"b0110_0") != null ? jdata.getString("b0110_0") : null;
            name = jdata.get((Object)"codeitemdesc") != null ? jdata.getString("codeitemdesc") : null;
            Integer sequence = jdata.get((Object)"a0000") != null ? Integer.valueOf(jdata.getString("a0000")) : null;
            String orgId = jdata.getString("parentid").replaceAll("-", "");
            if (!sourceDeptIds.contains(string)) {
                sourceDeptIds.add(string);
                sourceDeptIds.add(orgId);
            }
            if (!sourceOrgIds.contains(orgId)) {
                sourceOrgIds.add(orgId);
            }
            DeptEntity deptEntity = new DeptEntity();
            deptEntity.setSourceOrgId(orgId);
            deptEntity.setSourceId(string);
            deptEntity.setCode(code);
            deptEntity.setName(name);
            deptEntity.setSequence(sequence);
            deptEntity.setSystemId("1247777316689256450");
            addEditDeptList.add(deptEntity);
        }
        HashMap<String, OrgEntity> orgMap = new HashMap<String, OrgEntity>();
        if (sourceOrgIds != null && sourceOrgIds.size() > 0) {
            QueryWrapper wrapper2 = new QueryWrapper();
            wrapper2.in((Object)"source_id", sourceOrgIds);
            wrapper2.eq((Object)"tenant_id", (Object)999999L);
            List orgList = this.orgService.list((Wrapper)wrapper2);
            if (orgList != null && orgList.size() > 0) {
                flag = orgList.iterator();
                while (flag.hasNext()) {
                    OrgEntity orgEntity = (OrgEntity)((Object)flag.next());
                    orgMap.put(orgEntity.getSourceId(), orgEntity);
                }
            }
        }
        this.logger.info("\u5904\u7406\u7ec4\u7ec7-----------------");
        if (disabldOrgSourceIds != null && disabldOrgSourceIds.size() > 0) {
            UpdateWrapper wrapper2 = new UpdateWrapper();
            wrapper2.in((Object)"source_id", disabldOrgSourceIds);
            wrapper2.eq((Object)"tenant_id", (Object)999999L);
            wrapper2.set((Object)"state", (Object)0);
            this.orgService.update(null, (Wrapper)wrapper2);
        }
        if (addEditOrgList != null && addEditOrgList.size() > 0) {
            ArrayList<OrgEntity> addList = new ArrayList<OrgEntity>();
            for (OrgEntity entity : addEditOrgList) {
                OrgEntity orgEntity = (OrgEntity)((Object)orgMap.get(entity.getSourceId()));
                OrgEntity parentEntity = (OrgEntity)((Object)orgMap.get(entity.getProjectCode()));
                if (orgEntity != null) {
                    orgEntity.setOrgType(entity.getOrgType());
                    orgEntity.setState(1);
                    if (orgEntity.getProjectState() == null) {
                        orgEntity.setProjectState(2);
                    }
                    orgEntity.setName(entity.getName());
                    orgEntity.setShortName(entity.getShortName());
                    orgEntity.setCode(entity.getCode());
                    if (parentEntity != null && !orgEntity.getParentId().equals(parentEntity.getId())) {
                        String innerCode = parentEntity.getInnerCode() + "|" + orgEntity.getId();
                        orgEntity.setInnerCode(innerCode);
                        orgEntity.setParentId(parentEntity.getId());
                    }
                    addList.add(orgEntity);
                    continue;
                }
                Long id = IdWorker.getId();
                if (parentEntity != null) {
                    String innerCode = parentEntity.getInnerCode() + "|" + id;
                    entity.setInnerCode(innerCode);
                    entity.setParentId(parentEntity.getId());
                } else {
                    entity.setInnerCode(id.toString());
                }
                entity.setId(id);
                entity.setState(1);
                entity.setProjectState(2);
                entity.setProjectCode(null);
                addList.add(entity);
                orgMap.put(entity.getSourceId(), entity);
            }
            this.orgService.saveOrUpdateBatch(addList, addList.size(), false);
        }
        this.logger.info("\u5904\u7406\u90e8\u95e8-----------------");
        HashMap<String, DeptEntity> deptMap = new HashMap<String, DeptEntity>();
        if (sourceDeptIds != null && sourceDeptIds.size() > 0) {
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"tenant_id", (Object)999999L);
            wrapper.in((Object)"source_id", sourceDeptIds);
            List deptList = this.deptService.list((Wrapper)wrapper);
            if (deptList != null && deptList.size() > 0) {
                for (DeptEntity entity : deptList) {
                    deptMap.put(entity.getSourceId(), entity);
                }
            }
        }
        if (disabldDeptSourceIds != null && disabldDeptSourceIds.size() > 0) {
            wrapper = new UpdateWrapper();
            wrapper.in((Object)"source_id", disabldDeptSourceIds);
            wrapper.eq((Object)"tenant_id", (Object)999999L);
            wrapper.set((Object)"state", (Object)0);
            this.deptService.update(null, (Wrapper)wrapper);
        }
        if (addEditDeptList != null && addEditDeptList.size() > 0) {
            ArrayList<DeptEntity> addList = new ArrayList<DeptEntity>();
            for (DeptEntity deptEntity : addEditDeptList) {
                BaseEntity parentEntity;
                DeptEntity oldEntity = (DeptEntity)((Object)deptMap.get(deptEntity.getSourceId()));
                Long orgId = null;
                Long parentId = null;
                if (deptMap.get(deptEntity.getSourceOrgId()) != null) {
                    parentEntity = (DeptEntity)((Object)deptMap.get(deptEntity.getSourceOrgId()));
                    orgId = parentEntity.getOrgId();
                    parentId = parentEntity.getId();
                } else if (orgMap.get(deptEntity.getSourceOrgId()) != null) {
                    parentEntity = (OrgEntity)((Object)orgMap.get(deptEntity.getSourceOrgId()));
                    orgId = parentEntity.getId();
                }
                if (oldEntity != null) {
                    oldEntity.setName(deptEntity.getName());
                    oldEntity.setCode(deptEntity.getCode());
                    oldEntity.setSequence(deptEntity.getSequence());
                    oldEntity.setOrgId(orgId);
                    oldEntity.setSourceOrgId(deptEntity.getSourceOrgId());
                    oldEntity.setPid(parentId);
                    oldEntity.setState(1);
                    addList.add(oldEntity);
                    continue;
                }
                deptEntity.setOrgId(orgId);
                deptEntity.setState(1);
                deptEntity.setPid(parentId);
                addList.add(deptEntity);
            }
            this.deptService.saveOrUpdateBatch(addList, addList.size(), false);
        }
    }

    @Override
    public void syncEmployeeAndUserList(JSONArray userData) {
        ArrayList<String> disabldUserSourceIds = new ArrayList<String>();
        ArrayList<EmployeeEntity> addEditUserList = new ArrayList<EmployeeEntity>();
        ArrayList<Object> sourceOrgIds = new ArrayList<Object>();
        ArrayList<Object> sourceUserIds = new ArrayList<Object>();
        for (Object data : userData) {
            Object userName;
            Object sourceId;
            String flag;
            JSONObject jdata = (JSONObject)data;
            String string = flag = jdata.get((Object)"flag") != null ? jdata.getString("flag") : null;
            if ("3".equals(flag)) {
                sourceId = jdata.get((Object)"unique_id") != null ? jdata.getString("unique_id").replaceAll("-", "") : null;
                disabldUserSourceIds.add((String)sourceId);
                continue;
            }
            sourceId = jdata.get((Object)"unique_id") != null ? jdata.getString("unique_id").replaceAll("-", "") : null;
            String userCode = jdata.get((Object)"e0127") != null ? jdata.getString("e0127") : null;
            Object object = userName = jdata.get((Object)"a0101") != null ? jdata.getString("a0101") : null;
            Integer sex = jdata.get((Object)"a0107") != null ? Integer.valueOf("\u5973".equals(jdata.getString("a0107")) ? 2 : 1) : null;
            Object registTime = null;
            try {
                registTime = jdata.get((Object)"c0183") != null ? new SimpleDateFormat("yyyy-MM-dd").parse(jdata.getString("c0183")) : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            String userMobile = jdata.get((Object)"c0104") != null ? jdata.getString("c0104") : null;
            String userEmail = jdata.get((Object)"c0102") != null ? jdata.getString("c0102") : null;
            String qqId = jdata.get((Object)"h01sm") != null ? jdata.getString("h01sm") : null;
            String sourceOrgId = jdata.get((Object)"orgid") != null ? jdata.getString("orgid").replaceAll("-", "") : null;
            String idcard = jdata.get((Object)"a0177") != null ? jdata.getString("a0177") : null;
            Date birthday = null;
            try {
                birthday = jdata.get((Object)"a0111") != null ? new SimpleDateFormat("yyyy-MM-dd").parse(jdata.getString("a0111")) : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            String otherPhone = jdata.get((Object)"c010v") != null ? jdata.getString("c010v") : null;
            String postName = jdata.get((Object)"c010k") != null ? jdata.getString("c010k") : null;
            EmployeeEntity employeeEntity = new EmployeeEntity();
            Long id = IdWorker.getId();
            employeeEntity.setUserId(id);
            employeeEntity.setId(id);
            employeeEntity.setSourceId((String)sourceId);
            employeeEntity.setCode(userCode);
            employeeEntity.setName((String)userName);
            employeeEntity.setSex(sex);
            employeeEntity.setWorkTime((Date)registTime);
            employeeEntity.setMobilePhone(userMobile);
            employeeEntity.setIdcard(idcard);
            employeeEntity.setBirthday(birthday);
            employeeEntity.setOtherPhone(otherPhone);
            employeeEntity.setSystemId("1247777316689256450");
            employeeEntity.setTenantId(999999L);
            employeeEntity.setPhotoPath(userEmail);
            employeeEntity.setUserSignaturePath(qqId);
            employeeEntity.setNote(sourceOrgId);
            addEditUserList.add(employeeEntity);
            sourceUserIds.add(sourceId);
            sourceOrgIds.add(sourceOrgId);
        }
        if (disabldUserSourceIds != null && disabldUserSourceIds.size() > 0) {
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.in((Object)"source_id", disabldUserSourceIds);
            wrapper.eq((Object)"tenant_id", (Object)999999L);
            wrapper.set((Object)"user_state", (Object)0);
            this.userService.update(null, (Wrapper)wrapper);
            QueryWrapper qwrapper = new QueryWrapper();
            qwrapper.in((Object)"source_id", disabldUserSourceIds);
            qwrapper.eq((Object)"tenant_id", (Object)999999L);
            List userList = this.userService.list((Wrapper)qwrapper);
            if (userList != null && userList.size() > 0) {
                ArrayList<Long> disabldUserIds = new ArrayList<Long>();
                for (UserEntity en : userList) {
                    disabldUserIds.add(en.getId());
                }
                UpdateWrapper ewrapper = new UpdateWrapper();
                ewrapper.in((Object)"user_id", disabldUserIds);
                ewrapper.eq((Object)"tenant_id", (Object)999999L);
                ewrapper.set((Object)"state", (Object)0);
                this.employeeService.update(null, (Wrapper)ewrapper);
                UpdateWrapper twrapper = new UpdateWrapper();
                twrapper.in((Object)"user_id", disabldUserIds);
                twrapper.eq((Object)"tenant_id", (Object)999999L);
                twrapper.set((Object)"state", (Object)0);
                this.userTenantRelationService.update(null, (Wrapper)twrapper);
            }
        }
        HashMap<String, DeptEntity> deptMap = new HashMap<String, DeptEntity>();
        HashMap<String, OrgEntity> orgMap = new HashMap<String, OrgEntity>();
        if (sourceOrgIds != null && sourceOrgIds.size() > 0) {
            QueryWrapper owrapper = new QueryWrapper();
            owrapper.in((Object)"source_id", sourceOrgIds);
            owrapper.eq((Object)"tenant_id", (Object)999999L);
            List orgList = this.orgService.list((Wrapper)owrapper);
            if (orgList != null && orgList.size() > 0) {
                for (OrgEntity entity : orgList) {
                    orgMap.put(entity.getSourceId(), entity);
                }
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"source_id", sourceOrgIds);
            wrapper.eq((Object)"tenant_id", (Object)999999L);
            List deptList = this.deptService.list((Wrapper)wrapper);
            if (deptList != null && deptList.size() > 0) {
                for (DeptEntity entity : deptList) {
                    deptMap.put(entity.getSourceId(), entity);
                }
            }
        }
        HashMap<String, UserEntity> userMap = new HashMap<String, UserEntity>();
        HashMap<String, EmployeeEntity> employeeMap = new HashMap<String, EmployeeEntity>();
        HashMap<Long, UserTenantRelationEntity> userTenantMap = new HashMap<Long, UserTenantRelationEntity>();
        if (sourceUserIds != null && sourceUserIds.size() > 0) {
            QueryWrapper qwrapper = new QueryWrapper();
            qwrapper.in((Object)"source_id", sourceUserIds);
            qwrapper.eq((Object)"tenant_id", (Object)999999L);
            List userList = this.userService.list((Wrapper)qwrapper);
            ArrayList<Long> userIds = new ArrayList<Long>();
            if (userList != null && userList.size() > 0) {
                for (UserEntity en : userList) {
                    userIds.add(en.getId());
                    userMap.put(en.getSourceId(), en);
                }
                this.logger.info("\u67e5\u8be2\u51fa\u7684\u7528\u6237\u6570\u91cf\uff1a{}", (Object)userIds.size());
                QueryWrapper ewrapper = new QueryWrapper();
                ewrapper.in((Object)"user_id", userIds);
                ewrapper.eq((Object)"tenant_id", (Object)999999L);
                List employeeList = this.employeeService.list((Wrapper)ewrapper);
                for (EmployeeEntity en : employeeList) {
                    employeeMap.put(en.getSourceId(), en);
                }
                this.logger.info("\u67e5\u8be2\u51fa\u7684\u4eba\u5458\u6570\u91cf\uff1a{}", (Object)employeeList.size());
                QueryWrapper twrapper = new QueryWrapper();
                twrapper.in((Object)"user_id", userIds);
                twrapper.eq((Object)"tenant_id", (Object)999999L);
                List userTenantRelationList = this.userTenantRelationService.list((Wrapper)twrapper);
                for (UserTenantRelationEntity en : userTenantRelationList) {
                    userTenantMap.put(en.getUserId(), en);
                }
                this.logger.info("\u67e5\u8be2\u51fa\u7684\u5173\u7cfb\u6570\u91cf\uff1a{}", (Object)userTenantRelationList.size());
            }
            ArrayList<UserEntity> addUserList = new ArrayList<UserEntity>();
            ArrayList<EmployeeEntity> addEmployeeList = new ArrayList<EmployeeEntity>();
            ArrayList<UserTenantRelationEntity> addUserTenantList = new ArrayList<UserTenantRelationEntity>();
            ArrayList<JobEntity> addJobList = new ArrayList<JobEntity>();
            ArrayList<RoleUserRelationVO> addRoleUserList = new ArrayList<RoleUserRelationVO>();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            for (EmployeeEntity entity : addEditUserList) {
                UserEntity oldentity = (UserEntity)((Object)userMap.get(entity.getSourceId()));
                String sourceOrgId = null;
                String sourceDeptId = null;
                Long deptId = null;
                Long orgId = null;
                String orgName = null;
                if (deptMap.get(entity.getNote()) != null) {
                    sourceDeptId = entity.getNote();
                    deptId = ((DeptEntity)((Object)deptMap.get(entity.getNote()))).getId();
                    orgId = ((DeptEntity)((Object)deptMap.get(entity.getNote()))).getOrgId();
                } else if (orgMap.get(entity.getNote()) != null) {
                    sourceOrgId = entity.getNote();
                    orgId = ((OrgEntity)((Object)orgMap.get(entity.getNote()))).getId();
                    orgName = ((OrgEntity)((Object)orgMap.get(entity.getNote()))).getName();
                }
                if (oldentity != null) {
                    EmployeeEntity oldEmployeeEntity = (EmployeeEntity)((Object)employeeMap.get(entity.getSourceId()));
                    UserTenantRelationEntity oldUserTenantRelationEntity = (UserTenantRelationEntity)((Object)userTenantMap.get(oldentity.getId()));
                    Boolean move = false;
                    if (oldEmployeeEntity != null && (orgId != null && oldEmployeeEntity.getOrgId() == null || oldEmployeeEntity.getOrgId() != null && orgId == null || orgId != null && oldEmployeeEntity.getOrgId() != null && !orgId.equals(oldEmployeeEntity.getOrgId()))) {
                        move = true;
                    }
                    oldentity.setSourceOrgId(entity.getNote());
                    oldentity.setUserName(entity.getName());
                    oldentity.setWeixineeId(entity.getCode());
                    oldentity.setSex(entity.getSex() != null ? Integer.valueOf(entity.getSex()) : null);
                    oldentity.setRegistTime(entity.getWorkTime());
                    oldentity.setUserMobile(entity.getMobilePhone());
                    oldentity.setUserEmail(entity.getPhotoPath());
                    oldentity.setSystemId(entity.getSystemId());
                    oldentity.setOrgId(orgId);
                    oldentity.setQqId(entity.getUserSignaturePath());
                    addUserList.add(oldentity);
                    if (oldEmployeeEntity == null) {
                        oldEmployeeEntity = new EmployeeEntity();
                        oldEmployeeEntity.setId(oldentity.getId());
                        oldEmployeeEntity.setUserId(oldentity.getId());
                    }
                    oldEmployeeEntity.setSourceId(entity.getSourceId());
                    oldEmployeeEntity.setCode(entity.getCode());
                    oldEmployeeEntity.setName(entity.getName());
                    oldEmployeeEntity.setSex(entity.getSex());
                    oldEmployeeEntity.setWorkTime(entity.getWorkTime());
                    oldEmployeeEntity.setMobilePhone(entity.getMobilePhone());
                    oldEmployeeEntity.setIdcard(entity.getIdcard());
                    oldEmployeeEntity.setBirthday(entity.getBirthday());
                    oldEmployeeEntity.setOtherPhone(entity.getOtherPhone());
                    oldEmployeeEntity.setOrgId(orgId);
                    oldEmployeeEntity.setDeptId(deptId);
                    oldEmployeeEntity.setSystemId(entity.getSystemId());
                    addEmployeeList.add(oldEmployeeEntity);
                    if (oldUserTenantRelationEntity == null) {
                        oldUserTenantRelationEntity = new UserTenantRelationEntity();
                        oldUserTenantRelationEntity.setId(IdWorker.getId());
                        oldUserTenantRelationEntity.setUserId(oldentity.getId());
                        oldUserTenantRelationEntity.setEmployeeId(oldentity.getId());
                        oldUserTenantRelationEntity.setMainSpaceFlag(1);
                        oldUserTenantRelationEntity.setTypeId(2);
                        oldUserTenantRelationEntity.setState(1);
                    }
                    oldUserTenantRelationEntity.setDeptId(deptId);
                    oldUserTenantRelationEntity.setOrgId(orgId);
                    oldUserTenantRelationEntity.setTenantId(oldentity.getTenantId());
                    addUserTenantList.add(oldUserTenantRelationEntity);
                    if (!move.booleanValue()) continue;
                    Long pkJobId = IdWorker.getId();
                    QueryWrapper jobWrapper = new QueryWrapper();
                    jobWrapper.eq((Object)"dr", (Object)0);
                    jobWrapper.eq((Object)"employee_id", (Object)oldEmployeeEntity.getId());
                    jobWrapper.eq((Object)"property", (Object)1);
                    jobWrapper.eq((Object)"cur_state", (Object)0);
                    jobWrapper.eq((Object)"tenant_id", (Object)999999L);
                    JobEntity jobEntity = (JobEntity)((Object)this.jobService.getOne((Wrapper)jobWrapper, false));
                    if (jobEntity != null) {
                        jobEntity.setCurState(1);
                        jobEntity.setJobEndTime(new Date());
                        addJobList.add(jobEntity);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        ArrayList<Long> jobIds = new ArrayList<Long>();
                        jobIds.add(jobEntity.getId());
                        params.put("jobIds", jobIds);
                        params.put("tenantId", InvocationInfoProxy.getTenantid());
                        List<RoleUserRelationVO> roleList = this.roleUserRelationService.queryListByProperties(params);
                        if (roleList != null && roleList.size() > 0) {
                            for (RoleUserRelationVO vo : roleList) {
                                roleIds.add(vo.getId());
                                RoleUserRelationVO add = new RoleUserRelationVO();
                                if (orgId == null) continue;
                                add.setAuthOrgId(orgId);
                                if (StringUtils.isNotBlank((CharSequence)orgName)) {
                                    add.setAuthOrgName(orgName);
                                } else {
                                    OrgEntity org = (OrgEntity)((Object)this.orgService.getById(orgId));
                                    if (org != null) {
                                        orgName = org.getName();
                                        add.setAuthOrgName(orgName);
                                    }
                                }
                                add.setEmployeeId(oldEmployeeEntity.getId());
                                add.setEmployeeName(oldEmployeeEntity.getName());
                                add.setJobId(pkJobId);
                                add.setProperty("1");
                                add.setRoleId(vo.getRoleId());
                                add.setRoleName(vo.getRoleName());
                                add.setUserId(oldentity.getId());
                                add.setUserMobile(oldentity.getUserMobile());
                                add.setUserName(oldentity.getUserName());
                                addRoleUserList.add(add);
                            }
                        }
                    }
                    JobEntity jobNewEntity = new JobEntity();
                    jobNewEntity.setSourceDeptId(sourceDeptId);
                    jobNewEntity.setSourceOrgId(sourceOrgId);
                    jobNewEntity.setId(pkJobId);
                    jobNewEntity.setOrgId(orgId);
                    jobNewEntity.setDeptId(deptId);
                    jobNewEntity.setEmployeeId(oldEmployeeEntity.getId());
                    jobNewEntity.setProperty(1);
                    jobNewEntity.setJobStartTime(new Date());
                    jobNewEntity.setCurState(0);
                    jobNewEntity.setSystemId(entity.getSystemId());
                    addJobList.add(jobNewEntity);
                    continue;
                }
                UserEntity userEntity = new UserEntity();
                userEntity.setId(entity.getUserId());
                userEntity.setOrgId(orgId);
                userEntity.setUserName(entity.getName());
                userEntity.setUserCode(entity.getCode());
                userEntity.setUserMobile(entity.getMobilePhone());
                userEntity.setTypeId(2);
                userEntity.setUserState(UserVO.USER_STATE_ACTIVE);
                userEntity.setDr(BaseVO.DR_UNDELETE);
                userEntity.setSex(entity.getSex());
                userEntity.setWeixineeId(userEntity.getUserCode());
                userEntity.setSystemId(entity.getSystemId());
                userEntity.setSourceId(entity.getSourceId());
                userEntity.setSourceOrgId(entity.getNote());
                UserVO userVO = (UserVO)BeanMapper.map((Object)((Object)userEntity), UserVO.class);
                PasswordUtils.setSalt(userVO);
                String shaPassword = PasswordUtils.encodePasswordUsingSHA("sdbj_ejc_2020");
                userEntity.setSalt(userVO.getSalt());
                userEntity.setPassword(shaPassword);
                userEntity.setPassword(PasswordUtils.encodebyUserCode(userVO));
                userEntity.setPwdStartTime(new Date());
                addUserList.add(userEntity);
                entity.setOrgId(orgId);
                entity.setDeptId(deptId);
                entity.setPhotoPath(null);
                entity.setUserSignaturePath(null);
                entity.setNote(null);
                entity.setState(1);
                entity.setEmployeeType(1);
                addEmployeeList.add(entity);
                JobEntity job = new JobEntity();
                job.setSourceDeptId(sourceDeptId);
                job.setSourceOrgId(sourceOrgId);
                job.setOrgId(orgId);
                job.setDeptId(deptId);
                job.setEmployeeId(entity.getId());
                job.setProperty(1);
                job.setJobStartTime(new Date());
                job.setCurState(0);
                job.setSystemId(entity.getSystemId());
                addJobList.add(job);
                UserTenantRelationEntity userTenantEntity = new UserTenantRelationEntity();
                userTenantEntity.setUserId(userEntity.getId());
                userTenantEntity.setEmployeeId(entity.getId());
                userTenantEntity.setOrgId(entity.getOrgId());
                userTenantEntity.setTenantId(entity.getTenantId());
                userTenantEntity.setDeptId(entity.getDeptId());
                userTenantEntity.setMainSpaceFlag(1);
                userTenantEntity.setTypeId(2);
                userTenantEntity.setState(1);
                addUserTenantList.add(userTenantEntity);
            }
            if (addUserList != null && addUserList.size() > 0) {
                this.userService.saveOrUpdateBatch(addUserList, addUserList.size(), false);
            }
            if (addEmployeeList != null && addEmployeeList.size() > 0) {
                this.employeeService.saveOrUpdateBatch(addEmployeeList, addEmployeeList.size(), false);
            }
            if (addUserTenantList != null && addUserTenantList.size() > 0) {
                this.userTenantRelationService.saveOrUpdateBatch(addUserTenantList, addUserTenantList.size(), false);
            }
            if (addJobList != null && addJobList.size() > 0) {
                this.jobService.saveOrUpdateBatch(addJobList, addJobList.size(), false);
            }
            if (roleIds != null && roleIds.size() > 0) {
                this.roleUserRelationService.delete(roleIds);
            }
            if (addRoleUserList != null && addRoleUserList.size() > 0) {
                this.roleUserRelationService.saveRoleUser(addRoleUserList);
            }
        }
    }

    @Override
    public void syncJobList(JSONArray jobData) {
        ArrayList<String> delSourceJobIds = new ArrayList<String>();
        ArrayList<JobEntity> delJobList = new ArrayList<JobEntity>();
        ArrayList<String> sourceJobIds = new ArrayList<String>();
        ArrayList<String> sourceOrgIds = new ArrayList<String>();
        ArrayList<String> sourceUserIds = new ArrayList<String>();
        ArrayList<String> sourceDeptIds = new ArrayList<String>();
        ArrayList<JobEntity> addJobList = new ArrayList<JobEntity>();
        for (Object data : jobData) {
            JSONObject jdata = (JSONObject)data;
            String flag = jdata.get((Object)"flag") != null ? jdata.getString("flag") : null;
            String sourceId = jdata.get((Object)"partid") != null ? jdata.getString("partid").replaceAll("-", "") : null;
            String sourceEmployeeId = jdata.get((Object)"staffid") != null ? jdata.getString("staffid").replaceAll("-", "") : null;
            String sourceDeptId = jdata.get((Object)"deptid") != null ? jdata.getString("deptid").replaceAll("-", "") : null;
            String sourceOrgId = jdata.get((Object)"orgnm") != null ? jdata.getString("orgnm").replaceAll("-", "") : null;
            Date jobStartTime = null;
            Date jobEndTime = null;
            if (jdata.get((Object)"sdate") != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date date = simpleDateFormat.parse(jdata.getString("sdate"));
                    if (jdata.get((Object)"ryrm") != null && "1".equals(jdata.getString("ryrm"))) {
                        jobEndTime = date;
                    } else {
                        jobStartTime = date;
                    }
                }
                catch (Exception date) {
                    // empty catch block
                }
            }
            JobEntity job = new JobEntity();
            job.setSourceId(sourceId);
            job.setSourceOrgId(sourceOrgId);
            job.setSourceDeptId(sourceDeptId);
            job.setSystemId(sourceEmployeeId);
            job.setJobStartTime(jobStartTime);
            job.setJobEndTime(jobEndTime);
            job.setProperty(0);
            job.setCurState(0);
            if ("3".equals(flag)) {
                delSourceJobIds.add(sourceId);
                delJobList.add(job);
            } else if (jdata.get((Object)"ryrm") != null && "1".equals(jdata.getString("ryrm"))) {
                delSourceJobIds.add(sourceId);
                delJobList.add(job);
            } else {
                addJobList.add(job);
            }
            sourceJobIds.add(sourceId);
            sourceOrgIds.add(sourceOrgId);
            sourceUserIds.add(sourceEmployeeId);
            sourceDeptIds.add(sourceDeptId);
        }
        HashMap<String, Object> employeeMap = new HashMap<String, Object>();
        if (sourceUserIds != null && sourceUserIds.size() > 0) {
            QueryWrapper qwrapper = new QueryWrapper();
            qwrapper.in((Object)"source_id", sourceUserIds);
            qwrapper.eq((Object)"tenant_id", (Object)999999L);
            List userList = this.employeeService.list((Wrapper)qwrapper);
            for (Object entity : userList) {
                employeeMap.put(((EmployeeEntity)((Object)entity)).getSourceId(), entity);
            }
        }
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        if (sourceOrgIds != null && sourceOrgIds.size() > 0) {
            QueryWrapper qwrapper = new QueryWrapper();
            qwrapper.in((Object)"source_id", sourceOrgIds);
            qwrapper.eq((Object)"tenant_id", (Object)999999L);
            List userList = this.orgService.list((Wrapper)qwrapper);
            for (Object entity : userList) {
                orgMap.put(((OrgEntity)((Object)entity)).getSourceId(), entity);
            }
        }
        HashMap<String, DeptEntity> deptMap = new HashMap<String, DeptEntity>();
        if (sourceDeptIds != null && sourceDeptIds.size() > 0) {
            QueryWrapper qwrapper = new QueryWrapper();
            qwrapper.in((Object)"source_id", sourceDeptIds);
            qwrapper.eq((Object)"tenant_id", (Object)999999L);
            List deptList = this.deptService.list((Wrapper)qwrapper);
            for (DeptEntity entity : deptList) {
                deptMap.put(entity.getSourceId(), entity);
            }
        }
        HashMap<String, JobEntity> jobMap = new HashMap<String, JobEntity>();
        if (sourceJobIds != null && sourceJobIds.size() > 0) {
            QueryWrapper qwrapper = new QueryWrapper();
            qwrapper.in((Object)"source_id", sourceJobIds);
            qwrapper.eq((Object)"tenant_id", (Object)999999L);
            List jobList = this.jobService.list((Wrapper)qwrapper);
            for (JobEntity entity : jobList) {
                jobMap.put(entity.getSourceId(), entity);
            }
        }
        ArrayList<JobEntity> dealJobList = new ArrayList<JobEntity>();
        ArrayList<Long> delJobIds = new ArrayList<Long>();
        if (delJobList != null && delJobList.size() > 0) {
            for (JobEntity entity : delJobList) {
                JobEntity old = (JobEntity)((Object)jobMap.get(entity.getSourceId()));
                if (old == null) continue;
                if (entity.getJobEndTime() != null) {
                    old.setJobEndTime(entity.getJobEndTime());
                } else {
                    old.setJobEndTime(new Date());
                }
                old.setCurState(1);
                delJobIds.add(old.getId());
                dealJobList.add(old);
            }
        }
        if (addJobList != null && addJobList.size() > 0) {
            for (JobEntity entity : addJobList) {
                JobEntity oldJob = (JobEntity)((Object)jobMap.get(entity.getSourceId()));
                OrgEntity org = (OrgEntity)((Object)orgMap.get(entity.getSourceOrgId()));
                DeptEntity dept = (DeptEntity)((Object)deptMap.get(entity.getSourceDeptId()));
                EmployeeEntity employee = (EmployeeEntity)((Object)employeeMap.get(entity.getSystemId()));
                if (oldJob != null) {
                    if (org != null) {
                        oldJob.setOrgId(org.getId());
                    }
                    if (dept != null) {
                        oldJob.setDeptId(dept.getId());
                        oldJob.setOrgId(dept.getOrgId());
                    }
                    if (employee != null) {
                        oldJob.setEmployeeId(employee.getId());
                    }
                    oldJob.setSourceOrgId(entity.getSourceOrgId());
                    oldJob.setSourceDeptId(entity.getSourceDeptId());
                    oldJob.setJobStartTime(entity.getJobStartTime());
                    oldJob.setJobEndTime(entity.getJobEndTime());
                    dealJobList.add(oldJob);
                    continue;
                }
                entity.setSystemId("1247777316689256450");
                if (org != null) {
                    entity.setOrgId(org.getId());
                }
                if (dept != null) {
                    entity.setDeptId(dept.getId());
                    entity.setOrgId(dept.getOrgId());
                }
                if (employee != null) {
                    entity.setEmployeeId(employee.getId());
                }
                dealJobList.add(entity);
            }
        }
        if (dealJobList != null && dealJobList.size() > 0) {
            this.jobService.saveOrUpdateBatch(dealJobList, dealJobList.size(), false);
        }
        if (delJobIds != null && delJobIds.size() > 0) {
            this.roleUserRelationService.deleteByJobIds(delJobIds);
        }
    }

    @Override
    public void sendMsg(String range, String time) {
        ThirdSystemEntity thirdSystemVO = this.thirdSystemService.queryThirdSystemByCode("WeixinEE");
        String configInfo = thirdSystemVO.getConfigInfo();
        JSONObject zzyjConfig = JSONObject.parseObject((String)configInfo);
        String appid = zzyjConfig.getString("corp_appId");
        String secret = zzyjConfig.getString("corp_secret");
        String accessToken = this.thirdSystemService.getWeixineeAccessToken(appid, secret, true);
        this.logger.info("access_token = " + accessToken);
        String content = "\u6c34\u7535\u516b\u5c40\u540c\u6b65\u5931\u8d25,\u8303\u56f4:[" + range + "],\u65f6\u95f4:[" + time + "]";
        JSONObject templateJson = new JSONObject();
        templateJson.put("agentid", (Object)appid);
        ThirdSystemEntity third = this.thirdSystemService.queryThirdSystemByCode("sdbjSyncWeixinEeId");
        String weixinEeId = third.getConfigInfo();
        templateJson.put("touser", (Object)weixinEeId);
        templateJson.put("msgtype", (Object)"text");
        templateJson.put("safe", (Object)0);
        JSONObject contentJson = new JSONObject();
        contentJson.put("content", (Object)content);
        templateJson.put("text", (Object)contentJson);
        String templateContent = JSON.toJSONString((Object)templateJson);
        this.logger.info("\u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u53c2\u6570\uff1a accessToken={}, templateContent={}", (Object)accessToken, (Object)templateContent);
        String templateResult = WeixinRestUtil.doPostByURL("https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessToken + "&debug=1", templateContent);
        this.logger.info("\u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)templateResult);
        JSONObject httpResult = JSON.parseObject((String)templateResult);
        if (httpResult != null) {
            this.logger.info("weixin_response = " + JSON.toJSONString((Object)httpResult));
        }
        if ("ok".equals(httpResult.get((Object)"errmsg"))) {
            this.logger.info("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6210\u529f!");
        } else {
            this.logger.info("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u5931\u8d25------------!");
        }
    }

    class DataSync
    implements Callable<JSONArray> {
        private String begintime;
        private String endtime;
        private String url;
        private RequestAttributes context;

        public DataSync(String begintime, String endtime, String url, RequestAttributes context) {
            this.begintime = begintime;
            this.endtime = endtime;
            this.url = url;
            this.context = context;
        }

        @Override
        public JSONArray call() throws Exception {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            JSONArray datas = new JSONArray();
            boolean flag = true;
            int pageNumber = 1;
            while (flag) {
                JSONObject json = new JSONObject();
                json.put("input1", (Object)"");
                json.put("input2", (Object)pageNumber);
                json.put("begintime", (Object)this.begintime);
                json.put("endtime", (Object)this.endtime);
                String backData = HttpTookit8Ju.postByJson(this.url, json.toJSONString());
                JSONObject jsonResponse = JSON.parseObject((String)backData);
                JSONArray data = (JSONArray)jsonResponse.get((Object)"data");
                if (data != null && data.size() > 0) {
                    datas.addAll((Collection)data);
                    if (data.size() < 100) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                ++pageNumber;
            }
            return datas;
        }
    }
}

